/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.logging;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicInteger;
import org.neo4j.annotations.documented.DocumentedUtils;
import org.neo4j.annotations.documented.Warning;
import org.neo4j.logging.InternalLog;

public class LoggingReporterFactoryInvocationHandler
implements InvocationHandler {
    private final InternalLog log;
    private final boolean formattedMessages;
    private final AtomicInteger errors = new AtomicInteger();
    private final AtomicInteger warnings = new AtomicInteger();

    public LoggingReporterFactoryInvocationHandler(InternalLog log, boolean formattedMessages) {
        this.log = log;
        this.formattedMessages = formattedMessages;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String message;
        String string = message = this.formattedMessages ? DocumentedUtils.extractFormattedMessage((Method)method, (Object[])args) : DocumentedUtils.extractMessage((Method)method);
        if (method.getAnnotation(Warning.class) == null) {
            this.errors.incrementAndGet();
            this.log.error(message);
        } else {
            this.warnings.incrementAndGet();
            this.log.warn(message);
        }
        return null;
    }

    public int errors() {
        return this.errors.get();
    }

    public int warnings() {
        return this.warnings.get();
    }
}

