/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v3_2;

import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import org.neo4j.cypher.internal.compiler.v3_2.spi.InternalResultRow;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;

public class ResultRowImpl
implements InternalResultRow {
    private Map<String, Object> results;

    public ResultRowImpl(Map<String, Object> results) {
        this.results = results;
    }

    public ResultRowImpl() {
        this(new HashMap<String, Object>());
    }

    public void set(String k, Object value) {
        this.results.put(k, value);
    }

    @Override
    public Object get(String key) {
        return this.get(key, Object.class);
    }

    @Override
    public Node getNode(String key) {
        return this.get(key, Node.class);
    }

    @Override
    public Relationship getRelationship(String key) {
        return this.get(key, Relationship.class);
    }

    @Override
    public String getString(String key) {
        return this.get(key, String.class);
    }

    @Override
    public Number getNumber(String key) {
        return this.get(key, Number.class);
    }

    @Override
    public Boolean getBoolean(String key) {
        return this.get(key, Boolean.class);
    }

    @Override
    public Path getPath(String key) {
        return this.get(key, Path.class);
    }

    private <T> T get(String key, Class<T> type) {
        Object value = this.results.get(key);
        if (value == null && !this.results.containsKey(key)) {
            throw new IllegalArgumentException("No column \"" + key + "\" exists");
        }
        try {
            return type.cast(value);
        }
        catch (ClassCastException e) {
            String message = String.format("The current item in column \"%s\" is not a %s; it's \"%s\"", key, type.getSimpleName(), value);
            throw new NoSuchElementException(message);
        }
    }
}

