/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.parser.internal.parser.javacc;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.neo4j.cypherdsl.parser.internal.parser.javacc.ExpressionTokens;
import org.neo4j.cypherdsl.parser.internal.parser.javacc.IdentifierTokens;

public class ParseExceptions
extends RuntimeException {
    public static List<String> expected(int[][] expectedTokenSequences, String[] tokenImage, String currentToken) {
        HashMap<Integer, Long> tokenCount = new HashMap<Integer, Long>();
        Arrays.stream(expectedTokenSequences).flatMapToInt(Arrays::stream).boxed().forEach(token -> tokenCount.put((Integer)token, tokenCount.getOrDefault(token, 0L) + 1L));
        List<String> strings = ParseExceptions.processExpectedList(tokenCount, tokenImage, currentToken);
        Collections.sort(strings);
        return strings;
    }

    public static List<String> processExpectedList(Map<Integer, Long> expectedTokens, String[] tokenImage, String curentToken) {
        long identifiers = expectedTokens.getOrDefault(367, 0L);
        long plusCount = expectedTokens.getOrDefault(257, 0L);
        long expressions = Math.min(identifiers, plusCount);
        if (identifiers > 0L) {
            ParseExceptions.filterTokenSet(expectedTokens, IdentifierTokens.getIdentifierTokens(), identifiers);
        }
        if (expressions > 0L) {
            ParseExceptions.filterTokenSet(expectedTokens, ExpressionTokens.getExpressionTokens(), expressions);
        }
        List<String> expectedMessage = expectedTokens.keySet().stream().map(token -> {
            String image = tokenImage[token];
            return image.equals("\"$\"") && !curentToken.equals(":") ? "a parameter" : image;
        }).collect(Collectors.toList());
        if (identifiers - expressions > 0L) {
            expectedMessage.add("an identifier");
        }
        if (expressions > 0L) {
            expectedMessage.add("an expression");
        }
        return expectedMessage;
    }

    private static Map<Integer, Long> filterTokenSet(Map<Integer, Long> expectedTokens, Set<Integer> tokens, long quantitiy) {
        for (Integer token : tokens) {
            if (!expectedTokens.containsKey(token)) continue;
            long newCount = expectedTokens.get(token) - quantitiy;
            if (newCount > 0L) {
                expectedTokens.replace(token, newCount);
                continue;
            }
            expectedTokens.remove(token);
        }
        return expectedTokens;
    }
}

