/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import org.apiguardian.api.API;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.neo4j.cypherdsl.core.BooleanFunctionCondition;
import org.neo4j.cypherdsl.core.BuiltInFunctions;
import org.neo4j.cypherdsl.core.Condition;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.FunctionInvocation;
import org.neo4j.cypherdsl.core.ListPredicate;
import org.neo4j.cypherdsl.core.Property;
import org.neo4j.cypherdsl.core.RelationshipPattern;
import org.neo4j.cypherdsl.core.SymbolicName;
import org.neo4j.cypherdsl.core.Where;
import org.neo4j.cypherdsl.core.utils.Assertions;
import org.neo4j.cypherdsl.core.utils.CheckReturnValue;

@API(status=API.Status.STABLE, since="1.0")
public final class Predicates {
    @NotNull
    @Contract(pure=true)
    public static Condition exists(Property property) {
        return new BooleanFunctionCondition(FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Predicates.EXISTS, property));
    }

    @NotNull
    @Contract(pure=true)
    public static Condition exists(RelationshipPattern pattern) {
        return new BooleanFunctionCondition(FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Predicates.EXISTS, pattern));
    }

    @NotNull
    @Contract(pure=true)
    public static OngoingListBasedPredicateFunction all(String variable) {
        return Predicates.all(SymbolicName.of(variable));
    }

    @NotNull
    @Contract(pure=true)
    public static OngoingListBasedPredicateFunction all(SymbolicName variable) {
        return new Builder(BuiltInFunctions.Predicates.ALL, variable);
    }

    @NotNull
    @Contract(pure=true)
    public static OngoingListBasedPredicateFunction any(String variable) {
        return Predicates.any(SymbolicName.of(variable));
    }

    @NotNull
    @Contract(pure=true)
    public static OngoingListBasedPredicateFunction any(SymbolicName variable) {
        return new Builder(BuiltInFunctions.Predicates.ANY, variable);
    }

    @NotNull
    @Contract(pure=true)
    public static OngoingListBasedPredicateFunction none(String variable) {
        return Predicates.none(SymbolicName.of(variable));
    }

    @NotNull
    @Contract(pure=true)
    public static OngoingListBasedPredicateFunction none(SymbolicName variable) {
        return new Builder(BuiltInFunctions.Predicates.NONE, variable);
    }

    @NotNull
    @Contract(pure=true)
    public static OngoingListBasedPredicateFunction single(String variable) {
        return Predicates.single(SymbolicName.of(variable));
    }

    @NotNull
    @Contract(pure=true)
    public static OngoingListBasedPredicateFunction single(SymbolicName variable) {
        return new Builder(BuiltInFunctions.Predicates.SINGLE, variable);
    }

    private Predicates() {
    }

    private static class Builder
    implements OngoingListBasedPredicateFunction,
    OngoingListBasedPredicateFunctionWithList {
        private final BuiltInFunctions.Predicates predicate;
        private final SymbolicName name;
        private Expression listExpression;

        Builder(BuiltInFunctions.Predicates predicate, SymbolicName name) {
            Assertions.notNull(predicate, "The predicate is required");
            Assertions.notNull(name, "The name is required");
            this.predicate = predicate;
            this.name = name;
        }

        @Override
        public OngoingListBasedPredicateFunctionWithList in(Expression list) {
            Assertions.notNull(list, "The list expression is required");
            this.listExpression = list;
            return this;
        }

        @Override
        public Condition where(Condition condition) {
            Assertions.notNull(condition, "The condition is required");
            return new BooleanFunctionCondition(FunctionInvocation.create((FunctionInvocation.FunctionDefinition)this.predicate, new ListPredicate(this.name, this.listExpression, new Where(condition))));
        }
    }

    public static interface OngoingListBasedPredicateFunctionWithList {
        @NotNull
        @Contract(pure=true)
        public Condition where(Condition var1);
    }

    public static interface OngoingListBasedPredicateFunction {
        @NotNull
        @CheckReturnValue
        public OngoingListBasedPredicateFunctionWithList in(Expression var1);
    }
}

