/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core.renderer;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.neo4j.cypherdsl.build.RegisterForReflection;
import org.neo4j.cypherdsl.core.Comparison;
import org.neo4j.cypherdsl.core.Operator;
import org.neo4j.cypherdsl.core.Property;
import org.neo4j.cypherdsl.core.ast.EnterResult;
import org.neo4j.cypherdsl.core.ast.Visitable;
import org.neo4j.cypherdsl.core.ast.VisitorWithResult;
import org.neo4j.cypherdsl.core.renderer.DefaultVisitor;
import org.neo4j.cypherdsl.core.renderer.Neo4j5FunctionInvocationVisitor;

@RegisterForReflection(allDeclaredConstructors=true)
final class Neo4j5ComparisonVisitor
extends VisitorWithResult {
    private final DefaultVisitor delegate;

    Neo4j5ComparisonVisitor(DefaultVisitor delegate) {
        this.delegate = delegate;
    }

    @Override
    public EnterResult enterWithResult(Visitable segment) {
        Comparison comparison = (Comparison)segment;
        final AtomicReference capture = new AtomicReference();
        final AtomicInteger level = new AtomicInteger(0);
        final AtomicReference nPropExists = new AtomicReference();
        comparison.accept(new VisitorWithResult(){

            @Override
            public EnterResult enterWithResult(Visitable visitable) {
                boolean isOneLevelBelow;
                boolean bl = isOneLevelBelow = level.getAndIncrement() == 1;
                if (isOneLevelBelow) {
                    if (visitable instanceof Operator) {
                        capture.compareAndSet(null, (Operator)visitable);
                    } else if (Neo4j5FunctionInvocationVisitor.isNPropExists(visitable)) {
                        nPropExists.compareAndSet(null, visitable);
                    }
                }
                return EnterResult.CONTINUE;
            }

            @Override
            public void leave(Visitable segment) {
                level.decrementAndGet();
            }
        });
        if (capture.get() == Operator.NOT && nPropExists.get() != null) {
            Neo4j5FunctionInvocationVisitor.SingleArgExtractor<Property> singleArgExtractor = new Neo4j5FunctionInvocationVisitor.SingleArgExtractor<Property>(Property.class);
            ((Visitable)nPropExists.get()).accept(singleArgExtractor);
            ((Property)singleArgExtractor.singleArg).accept(this.delegate);
            this.delegate.builder.append(" IS NULL");
            return EnterResult.SKIP_CHILDREN;
        }
        return EnterResult.CONTINUE;
    }
}

