/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.interpreted.commands.expressions;

import java.io.Serializable;
import org.neo4j.cypher.internal.runtime.interpreted.commands.expressions.CoerceTo;
import org.neo4j.cypher.internal.runtime.interpreted.commands.expressions.Expression;
import org.neo4j.cypher.internal.util.symbols.AnyType;
import org.neo4j.cypher.internal.util.symbols.BooleanType;
import org.neo4j.cypher.internal.util.symbols.CypherType;
import org.neo4j.cypher.internal.util.symbols.DateType;
import org.neo4j.cypher.internal.util.symbols.DurationType;
import org.neo4j.cypher.internal.util.symbols.FloatType;
import org.neo4j.cypher.internal.util.symbols.GeometryType;
import org.neo4j.cypher.internal.util.symbols.IntegerType;
import org.neo4j.cypher.internal.util.symbols.ListType;
import org.neo4j.cypher.internal.util.symbols.LocalDateTimeType;
import org.neo4j.cypher.internal.util.symbols.LocalTimeType;
import org.neo4j.cypher.internal.util.symbols.MapType;
import org.neo4j.cypher.internal.util.symbols.NodeType;
import org.neo4j.cypher.internal.util.symbols.NumberType;
import org.neo4j.cypher.internal.util.symbols.PathType;
import org.neo4j.cypher.internal.util.symbols.PointType;
import org.neo4j.cypher.internal.util.symbols.RelationshipType;
import org.neo4j.cypher.internal.util.symbols.StringType;
import org.neo4j.cypher.internal.util.symbols.ZonedDateTimeType;
import org.neo4j.cypher.internal.util.symbols.ZonedTimeType;
import org.neo4j.exceptions.CypherTypeException;
import org.neo4j.internal.kernel.api.procs.Neo4jTypes;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.runtime.ModuleSerializationProxy;

public final class CoerceTo$
implements Serializable {
    public static final CoerceTo$ MODULE$ = new CoerceTo$();

    public Neo4jTypes.AnyType toNeo4jType(CypherType typ) {
        CypherType cypherType = typ;
        if (cypherType instanceof AnyType) {
            return Neo4jTypes.NTAny;
        }
        if (cypherType instanceof BooleanType) {
            return Neo4jTypes.NTBoolean;
        }
        if (cypherType instanceof DateType) {
            return Neo4jTypes.NTDate;
        }
        if (cypherType instanceof DurationType) {
            return Neo4jTypes.NTDuration;
        }
        if (cypherType instanceof FloatType) {
            return Neo4jTypes.NTFloat;
        }
        if (cypherType instanceof GeometryType) {
            return Neo4jTypes.NTGeometry;
        }
        if (cypherType instanceof IntegerType) {
            return Neo4jTypes.NTInteger;
        }
        if (cypherType instanceof ListType) {
            ListType listType = (ListType)cypherType;
            CypherType innerType = listType.innerType();
            return new Neo4jTypes.ListType(this.toNeo4jType(innerType));
        }
        if (cypherType instanceof LocalDateTimeType) {
            return Neo4jTypes.NTLocalDateTime;
        }
        if (cypherType instanceof LocalTimeType) {
            return Neo4jTypes.NTLocalTime;
        }
        if (cypherType instanceof MapType) {
            return Neo4jTypes.NTMap;
        }
        if (cypherType instanceof NodeType) {
            return Neo4jTypes.NTNode;
        }
        if (cypherType instanceof NumberType) {
            return Neo4jTypes.NTNumber;
        }
        if (cypherType instanceof PathType) {
            return Neo4jTypes.NTPath;
        }
        if (cypherType instanceof PointType) {
            return Neo4jTypes.NTPoint;
        }
        if (cypherType instanceof RelationshipType) {
            return Neo4jTypes.NTRelationship;
        }
        if (cypherType instanceof StringType) {
            return Neo4jTypes.NTString;
        }
        if (cypherType instanceof ZonedDateTimeType) {
            return Neo4jTypes.NTDateTime;
        }
        if (cypherType instanceof ZonedTimeType) {
            return Neo4jTypes.NTTime;
        }
        throw CypherTypeException.invalidCoercion((String)"", (String)typ.toCypherTypeString(), (String)("Wrong argument type: Can't coerce to " + typ + " (" + typ.getClass() + ")"));
    }

    public CoerceTo apply(Expression expr, CypherType typ) {
        return new CoerceTo(expr, typ);
    }

    public Option<Tuple2<Expression, CypherType>> unapply(CoerceTo x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple2((Object)x$0.expr(), (Object)x$0.typ()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(CoerceTo$.class);
    }

    private CoerceTo$() {
    }
}

