/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.interpreted.pipes.aggregation;

import java.io.Serializable;
import org.neo4j.cypher.internal.runtime.ReadableRow;
import org.neo4j.cypher.internal.runtime.interpreted.commands.expressions.Expression;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.QueryState;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.aggregation.AggregationFunction;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.aggregation.NumericOrDurationAggregationExpression;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.aggregation.NumericOrDurationAggregationExpression$AggregatingDurations$;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.aggregation.NumericOrDurationAggregationExpression$AggregatingNumbers$;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.aggregation.SumFunction$;
import org.neo4j.exceptions.InternalException;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.NumberValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.utils.ValueMath;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005Y4AAD\b\u0001A!A\u0001\u0006\u0001BC\u0002\u0013\u0005\u0011\u0006\u0003\u00053\u0001\t\u0005\t\u0015!\u0003+\u0011\u0015\u0019\u0004\u0001\"\u00015\u0011\u00199\u0004\u0001)Q\u0005q!1\u0001\t\u0001Q!\n\u0005CQ\u0001\u0012\u0001\u0005\u0002\u0015CQA\u0014\u0001\u0005B=CQA\u0017\u0001\u0005Bm;Q![\b\t\u0002)4QAD\b\t\u0002-DQa\r\u0006\u0005\u0002=Dq\u0001\u001d\u0006C\u0002\u0013\u0005\u0011\u000f\u0003\u0004v\u0015\u0001\u0006IA\u001d\u0002\f'Vlg)\u001e8di&|gN\u0003\u0002\u0011#\u0005Y\u0011mZ4sK\u001e\fG/[8o\u0015\t\u00112#A\u0003qSB,7O\u0003\u0002\u0015+\u0005Y\u0011N\u001c;feB\u0014X\r^3e\u0015\t1r#A\u0004sk:$\u0018.\\3\u000b\u0005aI\u0012\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005iY\u0012AB2za\",'O\u0003\u0002\u001d;\u0005)a.Z85U*\ta$A\u0002pe\u001e\u001c\u0001aE\u0002\u0001C\u0015\u0002\"AI\u0012\u000e\u0003=I!\u0001J\b\u0003'\u0005;wM]3hCRLwN\u001c$v]\u000e$\u0018n\u001c8\u0011\u0005\t2\u0013BA\u0014\u0010\u0005\u0019rU/\\3sS\u000e|%\u000fR;sCRLwN\\!hOJ,w-\u0019;j_:,\u0005\u0010\u001d:fgNLwN\\\u0001\u0006m\u0006dW/Z\u000b\u0002UA\u00111\u0006M\u0007\u0002Y)\u0011QFL\u0001\fKb\u0004(/Z:tS>t7O\u0003\u00020'\u0005A1m\\7nC:$7/\u0003\u00022Y\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002\rY\fG.^3!\u0003\u0019a\u0014N\\5u}Q\u0011QG\u000e\t\u0003E\u0001AQ\u0001K\u0002A\u0002)\n\u0011b];n\u001dVl'-\u001a:\u0011\u0005erT\"\u0001\u001e\u000b\u0005mb\u0014\u0001C:u_J\f'\r\\3\u000b\u0005uZ\u0012A\u0002<bYV,7/\u0003\u0002@u\tYa*^7cKJ4\u0016\r\\;f\u0003-\u0019X/\u001c#ve\u0006$\u0018n\u001c8\u0011\u0005e\u0012\u0015BA\";\u00055!UO]1uS>tg+\u00197vK\u0006!a.Y7f+\u00051\u0005CA$M\u001b\u0005A%BA%K\u0003\u0011a\u0017M\\4\u000b\u0003-\u000bAA[1wC&\u0011Q\n\u0013\u0002\u0007'R\u0014\u0018N\\4\u0002\rI,7/\u001e7u)\t\u0001F\u000b\u0005\u0002R%6\tA(\u0003\u0002Ty\tA\u0011I\\=WC2,X\rC\u0003V\u000f\u0001\u0007a+A\u0003ti\u0006$X\r\u0005\u0002X16\t\u0011#\u0003\u0002Z#\tQ\u0011+^3ssN#\u0018\r^3\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0007q\u0013\u0007\u000e\u0005\u0002^A6\taLC\u0001`\u0003\u0015\u00198-\u00197b\u0013\t\tgL\u0001\u0003V]&$\b\"B2\t\u0001\u0004!\u0017\u0001\u00023bi\u0006\u0004\"!\u001a4\u000e\u0003UI!aZ\u000b\u0003\u0017I+\u0017\rZ1cY\u0016\u0014vn\u001e\u0005\u0006+\"\u0001\rAV\u0001\f'Vlg)\u001e8di&|g\u000e\u0005\u0002#\u0015M\u0011!\u0002\u001c\t\u0003;6L!A\u001c0\u0003\r\u0005s\u0017PU3g)\u0005Q\u0017\u0001D*I\u00032cujV0T\u0013j+U#\u0001:\u0011\u0005u\u001b\u0018B\u0001;_\u0005\u0011auN\\4\u0002\u001bMC\u0015\t\u0014'P/~\u001b\u0016JW#!\u0001")
public class SumFunction
extends AggregationFunction
implements NumericOrDurationAggregationExpression {
    private final Expression value;
    private NumberValue sumNumber;
    private DurationValue sumDuration;
    private volatile NumericOrDurationAggregationExpression$AggregatingNumbers$ AggregatingNumbers$module;
    private volatile NumericOrDurationAggregationExpression$AggregatingDurations$ AggregatingDurations$module;
    private Option<NumericOrDurationAggregationExpression.AggregatingType> aggregatingType;

    public static long SHALLOW_SIZE() {
        return SumFunction$.MODULE$.SHALLOW_SIZE();
    }

    @Override
    public void actOnNumberOrDuration(AnyValue vl, Function1<NumberValue, BoxedUnit> aggNumber, Function1<DurationValue, BoxedUnit> aggDuration, QueryState state) {
        NumericOrDurationAggregationExpression.actOnNumberOrDuration$(this, vl, aggNumber, aggDuration, state);
    }

    @Override
    public NumericOrDurationAggregationExpression$AggregatingNumbers$ AggregatingNumbers() {
        if (this.AggregatingNumbers$module == null) {
            this.AggregatingNumbers$lzycompute$1();
        }
        return this.AggregatingNumbers$module;
    }

    @Override
    public NumericOrDurationAggregationExpression$AggregatingDurations$ AggregatingDurations() {
        if (this.AggregatingDurations$module == null) {
            this.AggregatingDurations$lzycompute$1();
        }
        return this.AggregatingDurations$module;
    }

    @Override
    public Option<NumericOrDurationAggregationExpression.AggregatingType> aggregatingType() {
        return this.aggregatingType;
    }

    @Override
    public void aggregatingType_$eq(Option<NumericOrDurationAggregationExpression.AggregatingType> x$1) {
        this.aggregatingType = x$1;
    }

    @Override
    public Expression value() {
        return this.value;
    }

    @Override
    public String name() {
        return "SUM";
    }

    @Override
    public AnyValue result(QueryState state) {
        boolean bl = false;
        Some some = null;
        Option<NumericOrDurationAggregationExpression.AggregatingType> option = this.aggregatingType();
        if (None$.MODULE$.equals(option)) {
            return this.sumNumber;
        }
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            NumericOrDurationAggregationExpression.AggregatingType aggregatingType = (NumericOrDurationAggregationExpression.AggregatingType)some.value();
            if (this.AggregatingNumbers().equals(aggregatingType)) {
                return this.sumNumber;
            }
        }
        if (bl) {
            NumericOrDurationAggregationExpression.AggregatingType aggregatingType = (NumericOrDurationAggregationExpression.AggregatingType)some.value();
            if (this.AggregatingDurations().equals(aggregatingType)) {
                return this.sumDuration;
            }
        }
        throw InternalException.internalError((String)this.getClass().getSimpleName(), (String)("invalid aggregation type " + this.aggregatingType()));
    }

    @Override
    public void apply(ReadableRow data, QueryState state) {
        AnyValue vl = this.value().apply(data, state);
        this.actOnNumberOrDuration(vl, (Function1<NumberValue, BoxedUnit>)(Function1 & Serializable)number -> {
            this.sumNumber = ValueMath.overflowSafeAdd((NumberValue)this.sumNumber, (NumberValue)number);
            return BoxedUnit.UNIT;
        }, (Function1<DurationValue, BoxedUnit>)(Function1 & Serializable)duration -> {
            this.sumDuration = this.sumDuration.add(duration);
            return BoxedUnit.UNIT;
        }, state);
    }

    private final void AggregatingNumbers$lzycompute$1() {
        SumFunction sumFunction = this;
        synchronized (sumFunction) {
            if (this.AggregatingNumbers$module == null) {
                this.AggregatingNumbers$module = new NumericOrDurationAggregationExpression$AggregatingNumbers$(this);
            }
        }
    }

    private final void AggregatingDurations$lzycompute$1() {
        SumFunction sumFunction = this;
        synchronized (sumFunction) {
            if (this.AggregatingDurations$module == null) {
                this.AggregatingDurations$module = new NumericOrDurationAggregationExpression$AggregatingDurations$(this);
            }
        }
    }

    public SumFunction(Expression value) {
        this.value = value;
        NumericOrDurationAggregationExpression.$init$(this);
        this.sumNumber = Values.ZERO_INT;
        this.sumDuration = DurationValue.ZERO;
    }
}

