/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.ir.v3_5;

import org.neo4j.cypher.internal.ir.v3_5.InterestingOrder;
import org.neo4j.cypher.internal.ir.v3_5.InterestingOrder$;
import org.neo4j.cypher.internal.ir.v3_5.PlannerQuery;
import org.neo4j.cypher.internal.ir.v3_5.QueryGraph;
import org.neo4j.cypher.internal.ir.v3_5.QueryHorizon;
import org.neo4j.cypher.internal.ir.v3_5.QueryProjection;
import org.neo4j.cypher.internal.ir.v3_5.RegularPlannerQuery;
import org.neo4j.cypher.internal.ir.v3_5.RegularPlannerQuery$;
import org.neo4j.cypher.internal.ir.v3_5.RegularQueryProjection;
import org.neo4j.cypher.internal.ir.v3_5.StrictnessMode;
import org.opencypher.v9_0.ast.Hint;
import org.opencypher.v9_0.expressions.Expression;
import org.opencypher.v9_0.expressions.LabelName;
import org.opencypher.v9_0.expressions.Variable;
import org.opencypher.v9_0.util.InternalException;
import org.opencypher.v9_0.util.InternalException$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSeq;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;

public abstract class PlannerQuery$class {
    public static boolean readOnly(PlannerQuery $this) {
        return $this.queryGraph().readOnly() && $this.horizon().readOnly() && $this.tail().forall((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(PlannerQuery x$1) {
                return x$1.readOnly();
            }
        });
    }

    public static Option preferredStrictness(PlannerQuery $this) {
        return $this.horizon().preferredStrictness().orElse((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlannerQuery $outer;

            public final Option<StrictnessMode> apply() {
                return this.$outer.tail().flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Option<StrictnessMode> apply(PlannerQuery x$2) {
                        return x$2.preferredStrictness();
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public static PlannerQuery last(PlannerQuery $this) {
        return (PlannerQuery)$this.tail().map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final PlannerQuery apply(PlannerQuery x$3) {
                return x$3.last();
            }
        }).getOrElse((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlannerQuery $outer;

            public final PlannerQuery apply() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public static QueryGraph lastQueryGraph(PlannerQuery $this) {
        return $this.last().queryGraph();
    }

    public static QueryHorizon lastQueryHorizon(PlannerQuery $this) {
        return $this.last().horizon();
    }

    public static PlannerQuery withTail(PlannerQuery $this, PlannerQuery newTail) {
        Option<PlannerQuery> option = $this.tail();
        if (None$.MODULE$.equals(option)) {
            Some x$11 = new Some((Object)newTail);
            QueryGraph x$12 = $this.copy$default$1();
            InterestingOrder x$13 = $this.copy$default$2();
            QueryHorizon x$14 = $this.copy$default$3();
            PlannerQuery plannerQuery = $this.copy(x$12, x$13, x$14, (Option<PlannerQuery>)x$11);
            return plannerQuery;
        }
        if (option instanceof Some) {
            throw new InternalException("Attempt to set a second tail on a query graph", InternalException$.MODULE$.$lessinit$greater$default$2());
        }
        throw new MatchError(option);
    }

    public static PlannerQuery withoutHints(PlannerQuery $this, GenSeq hintsToIgnore) {
        QueryGraph x$15 = $this.queryGraph().withoutHints((GenSeq<Hint>)hintsToIgnore);
        Option x$16 = $this.tail().map((Function1)new Serializable($this, hintsToIgnore){
            public static final long serialVersionUID = 0L;
            private final GenSeq hintsToIgnore$1;

            public final PlannerQuery apply(PlannerQuery x) {
                return x.withoutHints((GenSeq<Hint>)this.hintsToIgnore$1);
            }
            {
                this.hintsToIgnore$1 = hintsToIgnore$1;
            }
        });
        InterestingOrder x$17 = $this.copy$default$2();
        QueryHorizon x$18 = $this.copy$default$3();
        return $this.copy(x$15, x$17, x$18, (Option<PlannerQuery>)x$16);
    }

    public static PlannerQuery withHorizon(PlannerQuery $this, QueryHorizon horizon) {
        QueryHorizon x$19 = horizon;
        QueryGraph x$20 = $this.copy$default$1();
        InterestingOrder x$21 = $this.copy$default$2();
        Option<PlannerQuery> x$22 = $this.copy$default$4();
        return $this.copy(x$20, x$21, x$19, x$22);
    }

    public static PlannerQuery withQueryGraph(PlannerQuery $this, QueryGraph queryGraph) {
        return $this.copy(queryGraph, $this.copy$default$2(), $this.copy$default$3(), $this.copy$default$4());
    }

    public static PlannerQuery withInterestingOrder(PlannerQuery $this, InterestingOrder interestingOrder) {
        InterestingOrder x$23 = interestingOrder;
        QueryGraph x$24 = $this.copy$default$1();
        QueryHorizon x$25 = $this.copy$default$3();
        Option<PlannerQuery> x$26 = $this.copy$default$4();
        return $this.copy(x$24, x$23, x$25, x$26);
    }

    public static PlannerQuery withTailInterestingOrder(PlannerQuery $this, InterestingOrder interestingOrder) {
        return (PlannerQuery)PlannerQuery$class.f$1($this, $this, interestingOrder)._1();
    }

    public static boolean isCoveredByHints(PlannerQuery $this, PlannerQuery other) {
        Seq<Hint> seq = other.allHints();
        return $this.allHints().forall((Function1)new Serializable($this, seq){
            public static final long serialVersionUID = 0L;
            private final Seq eta$0$1$1;

            public final boolean apply(Object elem) {
                return this.eta$0$1$1.contains(elem);
            }
            {
                this.eta$0$1$1 = eta$0$1$1;
            }
        });
    }

    public static Seq allHints(PlannerQuery $this) {
        Option<PlannerQuery> option;
        block4: {
            Seq seq;
            block3: {
                block2: {
                    option = $this.tail();
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    PlannerQuery tailPlannerQuery = (PlannerQuery)some.x();
                    seq = (Seq)$this.queryGraph().allHints().$plus$plus(tailPlannerQuery.allHints(), Seq$.MODULE$.canBuildFrom());
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                seq = $this.queryGraph().allHints();
            }
            return seq;
        }
        throw new MatchError(option);
    }

    public static int numHints(PlannerQuery $this) {
        return $this.allHints().size();
    }

    public static PlannerQuery amendQueryGraph(PlannerQuery $this, Function1 f) {
        return $this.withQueryGraph((QueryGraph)f.apply((Object)$this.queryGraph()));
    }

    public static PlannerQuery updateHorizon(PlannerQuery $this, Function1 f) {
        return $this.withHorizon((QueryHorizon)f.apply((Object)$this.horizon()));
    }

    public static PlannerQuery updateQueryProjection(PlannerQuery $this, Function1 f) {
        QueryHorizon queryHorizon = $this.horizon();
        if (queryHorizon instanceof QueryProjection) {
            QueryProjection queryProjection = (QueryProjection)queryHorizon;
            PlannerQuery plannerQuery = $this.withHorizon((QueryHorizon)f.apply((Object)queryProjection));
            return plannerQuery;
        }
        throw new InternalException("Tried updating projection when there was no projection there", InternalException$.MODULE$.$lessinit$greater$default$2());
    }

    public static PlannerQuery updateTail(PlannerQuery $this, Function1 f) {
        Option<PlannerQuery> option;
        block4: {
            PlannerQuery plannerQuery;
            block3: {
                block2: {
                    option = $this.tail();
                    if (!None$.MODULE$.equals(option)) break block2;
                    plannerQuery = $this;
                    break block3;
                }
                if (!(option instanceof Some)) break block4;
                Some some = (Some)option;
                PlannerQuery tailQuery = (PlannerQuery)some.x();
                Some x$39 = new Some(f.apply((Object)tailQuery));
                QueryGraph x$40 = $this.copy$default$1();
                InterestingOrder x$41 = $this.copy$default$2();
                QueryHorizon x$42 = $this.copy$default$3();
                plannerQuery = $this.copy(x$40, x$41, x$42, (Option<PlannerQuery>)x$39);
            }
            return plannerQuery;
        }
        throw new MatchError(option);
    }

    public static PlannerQuery updateTailOrSelf(PlannerQuery $this, Function1 f) {
        Option<PlannerQuery> option;
        block4: {
            PlannerQuery plannerQuery;
            block3: {
                block2: {
                    option = $this.tail();
                    if (!None$.MODULE$.equals(option)) break block2;
                    plannerQuery = (PlannerQuery)f.apply((Object)$this);
                    break block3;
                }
                if (!(option instanceof Some)) break block4;
                plannerQuery = $this.updateTail((Function1<PlannerQuery, PlannerQuery>)new Serializable($this, f){
                    public static final long serialVersionUID = 0L;
                    private final Function1 f$2;

                    public final PlannerQuery apply(PlannerQuery x$5) {
                        return x$5.updateTailOrSelf((Function1<PlannerQuery, PlannerQuery>)this.f$2);
                    }
                    {
                        this.f$2 = f$2;
                    }
                });
            }
            return plannerQuery;
        }
        throw new MatchError(option);
    }

    public static PlannerQuery tailOrSelf(PlannerQuery $this) {
        Option<PlannerQuery> option;
        block4: {
            PlannerQuery plannerQuery;
            block3: {
                block2: {
                    option = $this.tail();
                    if (!None$.MODULE$.equals(option)) break block2;
                    plannerQuery = $this;
                    break block3;
                }
                if (!(option instanceof Some)) break block4;
                Some some = (Some)option;
                PlannerQuery t = (PlannerQuery)some.x();
                plannerQuery = t.tailOrSelf();
            }
            return plannerQuery;
        }
        throw new MatchError(option);
    }

    public static boolean exists(PlannerQuery $this, Function1 f) {
        return BoxesRunTime.unboxToBoolean((Object)f.apply((Object)$this)) || $this.tail().exists((Function1)new Serializable($this, f){
            public static final long serialVersionUID = 0L;
            private final Function1 f$3;

            public final boolean apply(PlannerQuery x$6) {
                return x$6.exists((Function1<PlannerQuery, Object>)this.f$3);
            }
            {
                this.f$3 = f$3;
            }
        });
    }

    public static PlannerQuery $plus$plus(PlannerQuery $this, PlannerQuery other) {
        Tuple2 tuple2 = new Tuple2((Object)$this.horizon(), (Object)other.horizon());
        if (tuple2 != null) {
            QueryHorizon a = (QueryHorizon)tuple2._1();
            QueryHorizon b = (QueryHorizon)tuple2._2();
            if (a instanceof RegularQueryProjection) {
                RegularQueryProjection regularQueryProjection = (RegularQueryProjection)a;
                if (b instanceof RegularQueryProjection) {
                    RegularQueryProjection regularQueryProjection2 = (RegularQueryProjection)b;
                    RegularQueryProjection x$43 = regularQueryProjection.$plus$plus(regularQueryProjection2);
                    QueryGraph x$44 = $this.queryGraph().$plus$plus(other.queryGraph());
                    Option x$45 = PlannerQuery$class.either($this, $this.tail(), other.tail());
                    InterestingOrder x$46 = RegularPlannerQuery$.MODULE$.apply$default$2();
                    RegularPlannerQuery regularPlannerQuery = new RegularPlannerQuery(x$44, x$46, x$43, (Option<PlannerQuery>)x$45);
                    return regularPlannerQuery;
                }
            }
        }
        throw new InternalException("Tried to concatenate non-regular query projections", InternalException$.MODULE$.$lessinit$greater$default$2());
    }

    private static Option either(PlannerQuery $this, Option a, Option b) {
        Tuple2 tuple2;
        block7: {
            Option option;
            block6: {
                block5: {
                    tuple2 = new Tuple2((Object)a, (Object)b);
                    if (tuple2 != null) {
                        Option option2 = (Option)tuple2._1();
                        Option option3 = (Option)tuple2._2();
                        if (option2 instanceof Some && option3 instanceof Some) {
                            throw new InternalException("Can't join two query graphs with different SKIP", InternalException$.MODULE$.$lessinit$greater$default$2());
                        }
                    }
                    if (tuple2 == null) break block5;
                    Option s = (Option)tuple2._1();
                    Option option4 = (Option)tuple2._2();
                    if (!(s instanceof Some)) break block5;
                    Some some = (Some)s;
                    if (!None$.MODULE$.equals(option4)) break block5;
                    option = some;
                    break block6;
                }
                if (tuple2 == null) break block7;
                Option option5 = (Option)tuple2._1();
                Option s = (Option)tuple2._2();
                if (!None$.MODULE$.equals(option5)) break block7;
                option = s;
            }
            return option;
        }
        throw new MatchError((Object)tuple2);
    }

    public static QueryGraph copy$default$1(PlannerQuery $this) {
        return $this.queryGraph();
    }

    public static InterestingOrder copy$default$2(PlannerQuery $this) {
        return $this.interestingOrder();
    }

    public static QueryHorizon copy$default$3(PlannerQuery $this) {
        return $this.horizon();
    }

    public static Option copy$default$4(PlannerQuery $this) {
        return $this.tail();
    }

    public static PlannerQuery foldMap(PlannerQuery $this, Function2 f) {
        Option<PlannerQuery> option;
        block4: {
            PlannerQuery plannerQuery;
            block3: {
                block2: {
                    option = $this.tail();
                    if (!None$.MODULE$.equals(option)) break block2;
                    plannerQuery = $this;
                    break block3;
                }
                if (!(option instanceof Some)) break block4;
                Some some = (Some)option;
                PlannerQuery oldTail = (PlannerQuery)some.x();
                PlannerQuery newTail = (PlannerQuery)f.apply((Object)$this, (Object)oldTail);
                Some x$47 = new Some((Object)newTail.foldMap((Function2<PlannerQuery, PlannerQuery, PlannerQuery>)f));
                QueryGraph x$48 = $this.copy$default$1();
                InterestingOrder x$49 = $this.copy$default$2();
                QueryHorizon x$50 = $this.copy$default$3();
                plannerQuery = $this.copy(x$48, x$49, x$50, (Option<PlannerQuery>)x$47);
            }
            return plannerQuery;
        }
        throw new MatchError(option);
    }

    public static Object fold(PlannerQuery $this, Object in, Function2 f) {
        return PlannerQuery$class.recurse$1($this, in, $this, f);
    }

    public static Seq allQueryGraphs(PlannerQuery $this) {
        return (Seq)$this.allPlannerQueries().map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final QueryGraph apply(PlannerQuery x$7) {
                return x$7.queryGraph();
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public static Seq allPlannerQueries(PlannerQuery $this) {
        return PlannerQuery$class.loop$1($this, (Seq)Seq$.MODULE$.empty(), (Option)new Some((Object)$this));
    }

    public static Map labelInfo(PlannerQuery $this) {
        Map map;
        Map<String, Set<LabelName>> labelInfo2 = $this.lastQueryGraph().selections().labelInfo();
        QueryHorizon queryHorizon = $this.lastQueryHorizon();
        if (queryHorizon instanceof QueryProjection) {
            QueryProjection queryProjection = (QueryProjection)queryHorizon;
            map = (Map)queryProjection.projections().collect((PartialFunction)new Serializable($this, labelInfo2){
                public static final long serialVersionUID = 0L;
                private final Map labelInfo$1;

                /*
                 * Enabled aggressive block sorting
                 */
                public final <A1 extends Tuple2<String, Expression>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (A1 != null) {
                        Variable variable;
                        String name;
                        String projectedName = (String)A1._1();
                        Expression expression = (Expression)A1._2();
                        if (expression instanceof Variable && this.labelInfo$1.contains((Object)(name = (variable = (Variable)expression).name()))) {
                            object = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)projectedName), this.labelInfo$1.apply((Object)name));
                            return (B1)object;
                        }
                    }
                    object = function1.apply(x1);
                    return (B1)object;
                }

                public final boolean isDefinedAt(Tuple2<String, Expression> x1) {
                    Variable variable;
                    String name;
                    Expression expression;
                    Tuple2<String, Expression> tuple2 = x1;
                    boolean bl = tuple2 != null && (expression = (Expression)tuple2._2()) instanceof Variable && this.labelInfo$1.contains((Object)(name = (variable = (Variable)expression).name()));
                    return bl;
                }
                {
                    this.labelInfo$1 = labelInfo$1;
                }
            }, Map$.MODULE$.canBuildFrom());
        } else {
            map = Predef$.MODULE$.Map().empty();
        }
        Map projectedLabelInfo = map;
        return labelInfo2.$plus$plus((GenTraversableOnce)projectedLabelInfo);
    }

    private static final Tuple2 f$1(PlannerQuery $this, PlannerQuery plannerQuery, InterestingOrder interestingOrder$1) {
        Option<PlannerQuery> option;
        block9: {
            Tuple2 tuple2;
            block10: {
                Tuple2 tuple22;
                block8: {
                    Tuple2 tuple23;
                    Tuple2 tuple24;
                    block7: {
                        option = plannerQuery.tail();
                        if (!None$.MODULE$.equals(option)) break block7;
                        InterestingOrder x$27 = interestingOrder$1;
                        QueryGraph x$28 = plannerQuery.copy$default$1();
                        QueryHorizon x$29 = plannerQuery.copy$default$3();
                        Option<PlannerQuery> x$30 = plannerQuery.copy$default$4();
                        tuple22 = new Tuple2((Object)plannerQuery.copy(x$28, x$27, x$29, x$30), (Object)interestingOrder$1.asInteresting());
                        break block8;
                    }
                    if (!(option instanceof Some)) break block9;
                    Some some = (Some)option;
                    PlannerQuery q = (PlannerQuery)some.x();
                    tuple2 = PlannerQuery$class.f$1($this, q, interestingOrder$1);
                    if (tuple2 == null) break block10;
                    PlannerQuery newTail = (PlannerQuery)tuple2._1();
                    InterestingOrder tailOrder = (InterestingOrder)tuple2._2();
                    Tuple2 tuple25 = tuple24 = new Tuple2((Object)newTail, (Object)tailOrder);
                    PlannerQuery newTail2 = (PlannerQuery)tuple25._1();
                    InterestingOrder tailOrder2 = (InterestingOrder)tuple25._2();
                    if (plannerQuery.interestingOrder().isEmpty()) {
                        InterestingOrder reverseProjected;
                        InterestingOrder interestingOrder;
                        QueryHorizon queryHorizon = plannerQuery.horizon();
                        if (queryHorizon instanceof QueryProjection) {
                            QueryProjection queryProjection = (QueryProjection)queryHorizon;
                            interestingOrder = tailOrder2.withReverseProjectedColumns(queryProjection.projections(), newTail2.queryGraph().argumentIds());
                        } else {
                            interestingOrder = tailOrder2;
                        }
                        InterestingOrder x$31 = reverseProjected = interestingOrder;
                        Some x$32 = new Some((Object)newTail2);
                        QueryGraph x$33 = plannerQuery.copy$default$1();
                        QueryHorizon x$34 = plannerQuery.copy$default$3();
                        Tuple2 tuple26 = new Tuple2((Object)plannerQuery.copy(x$33, x$31, x$34, (Option<PlannerQuery>)x$32), (Object)reverseProjected);
                        tuple23 = tuple26;
                    } else {
                        Some x$35 = new Some((Object)newTail2);
                        QueryGraph x$36 = plannerQuery.copy$default$1();
                        InterestingOrder x$37 = plannerQuery.copy$default$2();
                        QueryHorizon x$38 = plannerQuery.copy$default$3();
                        Tuple2 tuple27 = new Tuple2((Object)plannerQuery.copy(x$36, x$37, x$38, (Option<PlannerQuery>)x$35), (Object)InterestingOrder$.MODULE$.empty());
                        tuple23 = tuple27;
                    }
                    tuple22 = tuple23;
                }
                return tuple22;
            }
            throw new MatchError((Object)tuple2);
        }
        throw new MatchError(option);
    }

    private static final Object recurse$1(PlannerQuery $this, Object acc, PlannerQuery pq, Function2 f$4) {
        Option<PlannerQuery> option;
        Object nextAcc;
        while (true) {
            PlannerQuery tailPQ;
            nextAcc = f$4.apply(acc, (Object)pq);
            option = pq.tail();
            if (!(option instanceof Some)) break;
            Some some = (Some)option;
            pq = tailPQ = (PlannerQuery)some.x();
            acc = nextAcc;
        }
        if (None$.MODULE$.equals(option)) {
            Object object = nextAcc;
            return object;
        }
        throw new MatchError(option);
    }

    private static final Seq loop$1(PlannerQuery $this, Seq acc, Option remaining) {
        Option<PlannerQuery> option;
        while (true) {
            if (None$.MODULE$.equals(option = remaining)) {
                Seq seq = acc;
                return seq;
            }
            if (!(option instanceof Some)) break;
            Some some = (Some)option;
            PlannerQuery inner = (PlannerQuery)some.x();
            remaining = inner.tail();
            acc = (Seq)acc.$colon$plus((Object)inner, Seq$.MODULE$.canBuildFrom());
        }
        throw new MatchError((Object)option);
    }

    public static void $init$(PlannerQuery $this) {
    }
}

