/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.parser.javacc;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.neo4j.cypher.internal.ast.factory.ASTFactory;
import org.neo4j.cypher.internal.parser.common.ast.factory.ASTExceptionFactory;
import org.neo4j.cypher.internal.parser.javacc.ParseException;
import org.neo4j.cypher.internal.parser.javacc.Token;

public class AliasName<DATABASE_NAME, PARAMETER> {
    ASTExceptionFactory exceptionFactory;
    List<Token> names = new ArrayList<Token>();
    PARAMETER parameter;
    private int componentCount = 1;
    private Token lastToken;

    public AliasName(ASTExceptionFactory exceptionFactory, Token token) throws Exception {
        this.exceptionFactory = exceptionFactory;
        this.lastToken = token;
        this.names.add(token);
    }

    public AliasName(ASTExceptionFactory exceptionFactory, PARAMETER parameter) {
        this.exceptionFactory = exceptionFactory;
        this.parameter = parameter;
    }

    public void add(Token token) throws Exception {
        if (this.isEscaped(token) || this.isEscaped(this.lastToken)) {
            ++this.componentCount;
        }
        this.lastToken = token;
        this.names.add(token);
    }

    public DATABASE_NAME getRemoteAliasName(ASTFactory astFactory) throws Exception {
        if (this.parameter != null) {
            return (DATABASE_NAME)astFactory.databaseName(this.parameter);
        }
        if (this.names.size() > 2) {
            throw this.exceptionFactory.syntaxException((Exception)new ParseException(ASTExceptionFactory.invalidDotsInRemoteAliasName((String)this.originalRepresentation())), this.names.get((int)0).beginOffset, this.names.get((int)0).beginLine, this.names.get((int)0).beginColumn);
        }
        return (DATABASE_NAME)astFactory.databaseName(astFactory.inputPosition(this.names.get((int)0).beginOffset, this.names.get((int)0).beginLine, this.names.get((int)0).beginColumn), this.tokensAsStrings());
    }

    public DATABASE_NAME getAsDatabaseName(ASTFactory astFactory) throws Exception {
        Optional<Token> invalidToken;
        if (this.parameter != null) {
            return (DATABASE_NAME)astFactory.databaseName(this.parameter);
        }
        if (this.componentCount > 1 && (invalidToken = this.names.stream().filter(this::isEscaped).findFirst()).isPresent()) {
            throw this.exceptionFactory.syntaxException((Exception)new ParseException(ASTExceptionFactory.tooManyDatabaseNameComponents((String)this.originalRepresentation())), this.names.get((int)0).beginOffset, this.names.get((int)0).beginLine, this.names.get((int)0).beginColumn);
        }
        return (DATABASE_NAME)astFactory.databaseName(astFactory.inputPosition(this.names.get((int)0).beginOffset, this.names.get((int)0).beginLine, this.names.get((int)0).beginColumn), this.tokensAsStrings());
    }

    public DATABASE_NAME getLocalAliasName(ASTFactory astFactory) throws Exception {
        Optional<Token> invalidToken;
        if (this.parameter != null) {
            return (DATABASE_NAME)astFactory.databaseName(this.parameter);
        }
        if (this.componentCount > 2 && (invalidToken = this.names.stream().filter(this::isEscaped).findFirst()).isPresent()) {
            throw this.exceptionFactory.syntaxException((Exception)new ParseException(ASTExceptionFactory.tooManyAliasNameComponents((String)this.originalRepresentation())), this.names.get((int)0).beginOffset, this.names.get((int)0).beginLine, this.names.get((int)0).beginColumn);
        }
        return (DATABASE_NAME)astFactory.databaseName(astFactory.inputPosition(this.names.get((int)0).beginOffset, this.names.get((int)0).beginLine, this.names.get((int)0).beginColumn), this.tokensAsStrings());
    }

    private boolean isEscaped(Token token) {
        return token.kind == 68;
    }

    private List<String> tokensAsStrings() {
        return this.names.stream().map(t -> t.image).toList();
    }

    private String originalRepresentation() {
        return this.names.stream().map(token -> {
            if (this.isEscaped((Token)token)) {
                return "`" + token.image + "`";
            }
            return token.image;
        }).collect(Collectors.joining("."));
    }
}

