/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.physicalplanning;

import org.neo4j.cypher.internal.physicalplanning.Slot;
import org.neo4j.cypher.internal.physicalplanning.SlotConfiguration;
import org.neo4j.cypher.internal.runtime.CypherRow;
import org.neo4j.cypher.internal.runtime.ReadableRow;
import org.neo4j.cypher.internal.runtime.WritableRow;
import org.neo4j.cypher.operations.CypherTypeValueMapper;
import org.neo4j.exceptions.InternalException;
import org.neo4j.exceptions.ParameterWrongTypeException;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.VirtualNodeValue;
import org.neo4j.values.virtual.VirtualRelationshipValue;
import org.neo4j.values.virtual.VirtualValues;
import scala.collection.immutable.ArraySeq;

public class SlotAccessor {
    private static final int PRIMITIVE_NULL = -1;

    private SlotAccessor() {
    }

    public static AnyValue getValue(ReadableRow row, SlotConfiguration.KeyedSlot slot) {
        int offset = slot.offset();
        return switch (slot.slotType()) {
            case 1 -> VirtualValues.node((long)row.getLongAt(offset));
            case 2 -> SlotAccessor.nullableNode(row.getLongAt(offset));
            case 3 -> VirtualValues.relationship((long)row.getLongAt(offset));
            case 4 -> SlotAccessor.nullableRel(row.getLongAt(offset));
            case 5, 6 -> throw SlotAccessor.failedToMakeGetter(slot.slot());
            case 7, 8, 9, 10, 11, 12 -> row.getRefAt(offset);
            default -> throw InternalException.internalError((String)SlotAccessor.class.getSimpleName(), (String)("Unknown slot type " + slot.slotType()));
        };
    }

    public static void setValue(WritableRow row, SlotConfiguration.KeyedSlot slot, AnyValue value) {
        int offset = slot.offset();
        switch (slot.slotType()) {
            case 1: {
                if (value instanceof VirtualNodeValue) {
                    VirtualNodeValue n = (VirtualNodeValue)value;
                    row.setLongAt(offset, n.id());
                    break;
                }
                throw ParameterWrongTypeException.expectedEntityAtLongSlotFoundInstead((int)offset, (String)"node", (String)String.valueOf(value), (String)value.prettyPrint(), (String)CypherTypeValueMapper.valueType((AnyValue)value));
            }
            case 2: {
                if (value instanceof VirtualNodeValue) {
                    VirtualNodeValue n = (VirtualNodeValue)value;
                    row.setLongAt(offset, n.id());
                    break;
                }
                if (value == Values.NO_VALUE) {
                    row.setLongAt(offset, -1L);
                    break;
                }
                throw ParameterWrongTypeException.expectedEntityAtLongSlotFoundInstead((int)offset, (String)"node", (String)String.valueOf(value), (String)value.prettyPrint(), (String)CypherTypeValueMapper.valueType((AnyValue)value));
            }
            case 3: {
                if (value instanceof VirtualRelationshipValue) {
                    VirtualRelationshipValue n = (VirtualRelationshipValue)value;
                    row.setLongAt(offset, n.id());
                    break;
                }
                throw ParameterWrongTypeException.expectedEntityAtLongSlotFoundInstead((int)offset, (String)"relationship", (String)String.valueOf(value), (String)value.prettyPrint(), (String)CypherTypeValueMapper.valueType((AnyValue)value));
            }
            case 4: {
                if (value instanceof VirtualRelationshipValue) {
                    VirtualRelationshipValue n = (VirtualRelationshipValue)value;
                    row.setLongAt(offset, n.id());
                    break;
                }
                if (value == Values.NO_VALUE) {
                    row.setLongAt(offset, -1L);
                    break;
                }
                throw ParameterWrongTypeException.expectedEntityAtLongSlotFoundInstead((int)offset, (String)"relationship", (String)String.valueOf(value), (String)value.prettyPrint(), (String)CypherTypeValueMapper.valueType((AnyValue)value));
            }
            case 5: 
            case 6: {
                throw SlotAccessor.failedToMakeSetter(slot.slot());
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                row.setRefAt(offset, value);
                break;
            }
            default: {
                throw InternalException.internalError((String)SlotAccessor.class.getSimpleName(), (String)("Unknown slot type " + slot.slotType()));
            }
        }
    }

    public static void invalidateCachedNodeProperties(CypherRow row, SlotConfiguration slots, long node) {
        ArraySeq<SlotConfiguration.KeyedSlot> allSlots = slots.slots();
        int end = slots.cachedPropertiesEndIndex();
        for (int i = slots.cachedPropertiesStartIndex(); i < end; ++i) {
            SlotConfiguration.KeyedSlot cachedSlot = (SlotConfiguration.KeyedSlot)allSlots.apply(i);
            String entityName = ((SlotConfiguration.CachedPropertySlotKey)cachedSlot.key()).property().entityName();
            SlotConfiguration.KeyedSlot entitySlot = slots.getOrElse(new SlotConfiguration.VariableSlotKey(entityName), null);
            if (entitySlot == null || !SlotAccessor.isNode(row, entitySlot, node)) continue;
            row.setCachedPropertyAt(cachedSlot.offset(), null);
        }
    }

    public static void invalidateCachedRelProperties(CypherRow row, SlotConfiguration slots, long node) {
        ArraySeq<SlotConfiguration.KeyedSlot> allSlots = slots.slots();
        int end = slots.cachedPropertiesEndIndex();
        for (int i = slots.cachedPropertiesStartIndex(); i < end; ++i) {
            SlotConfiguration.KeyedSlot cachedSlot = (SlotConfiguration.KeyedSlot)allSlots.apply(i);
            String entityName = ((SlotConfiguration.CachedPropertySlotKey)cachedSlot.key()).property().entityName();
            SlotConfiguration.KeyedSlot entitySlot = slots.getOrElse(new SlotConfiguration.VariableSlotKey(entityName), null);
            if (entitySlot == null || !SlotAccessor.isRel(row, entitySlot, node)) continue;
            row.setCachedPropertyAt(cachedSlot.offset(), null);
        }
    }

    private static boolean isNode(CypherRow row, SlotConfiguration.KeyedSlot slot, long node) {
        return switch (slot.slotType()) {
            case 1, 2 -> {
                if (row.getLongAt(slot.offset()) == node) {
                    yield true;
                }
                yield false;
            }
            case 7, 8 -> {
                VirtualNodeValue n;
                AnyValue var5_3 = row.getRefAt(slot.offset());
                if (var5_3 instanceof VirtualNodeValue && (n = (VirtualNodeValue)var5_3).id() == node) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    private static boolean isRel(CypherRow row, SlotConfiguration.KeyedSlot slot, long rel) {
        return switch (slot.slotType()) {
            case 3, 4 -> {
                if (row.getLongAt(slot.offset()) == rel) {
                    yield true;
                }
                yield false;
            }
            case 9, 10 -> {
                VirtualRelationshipValue n;
                AnyValue var5_3 = row.getRefAt(slot.offset());
                if (var5_3 instanceof VirtualRelationshipValue && (n = (VirtualRelationshipValue)var5_3).id() == rel) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    public static AnyValue nullableNode(long id) {
        return id == -1L ? Values.NO_VALUE : VirtualValues.node((long)id);
    }

    public static AnyValue nullableRel(long id) {
        return id == -1L ? Values.NO_VALUE : VirtualValues.relationship((long)id);
    }

    private static InternalException failedToMakeGetter(Slot slot) {
        return InternalException.internalError((String)SlotAccessor.class.getSimpleName(), (String)("Do not know how to make getter for slot " + String.valueOf(slot)));
    }

    private static InternalException failedToMakeSetter(Slot slot) {
        return InternalException.internalError((String)SlotAccessor.class.getSimpleName(), (String)("Do not know how to make setter for slot " + String.valueOf(slot)));
    }
}

