/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v3_5.helpers;

import org.neo4j.cypher.internal.v3_5.logical.plans.CoerceToPredicate;
import org.neo4j.cypher.internal.v3_5.logical.plans.ResolvedFunctionInvocation;
import org.neo4j.cypher.internal.v3_5.logical.plans.UserFunctionSignature;
import org.opencypher.v9_0.expressions.AndedPropertyInequalities;
import org.opencypher.v9_0.expressions.Ands;
import org.opencypher.v9_0.expressions.BooleanLiteral;
import org.opencypher.v9_0.expressions.Expression;
import org.opencypher.v9_0.expressions.ExtractExpression;
import org.opencypher.v9_0.expressions.FilterExpression;
import org.opencypher.v9_0.expressions.FunctionInvocation;
import org.opencypher.v9_0.expressions.FunctionInvocation$;
import org.opencypher.v9_0.expressions.FunctionName;
import org.opencypher.v9_0.expressions.GreaterThan;
import org.opencypher.v9_0.expressions.HasLabels;
import org.opencypher.v9_0.expressions.In;
import org.opencypher.v9_0.expressions.IterablePredicateExpression;
import org.opencypher.v9_0.expressions.ListComprehension;
import org.opencypher.v9_0.expressions.OperatorExpression;
import org.opencypher.v9_0.expressions.Ors;
import org.opencypher.v9_0.expressions.PatternExpression;
import org.opencypher.v9_0.expressions.TypeSignature;
import org.opencypher.v9_0.expressions.UnsignedDecimalIntegerLiteral;
import org.opencypher.v9_0.expressions.functions.Exists$;
import org.opencypher.v9_0.expressions.functions.Function;
import org.opencypher.v9_0.expressions.functions.Length$;
import org.opencypher.v9_0.expressions.functions.Size$;
import org.opencypher.v9_0.expressions.functions.ToBoolean$;
import org.opencypher.v9_0.util.ASTNode;
import org.opencypher.v9_0.util.InternalException;
import org.opencypher.v9_0.util.InternalException$;
import org.opencypher.v9_0.util.symbols.BooleanType;
import org.opencypher.v9_0.util.symbols.CypherType;
import org.opencypher.v9_0.util.symbols.package$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Set;

public final class PredicateHelper$ {
    public static final PredicateHelper$ MODULE$;
    private final Set<Function> BOOLEAN_FUNCTIONS;

    static {
        new PredicateHelper$();
    }

    private Set<Function> BOOLEAN_FUNCTIONS() {
        return this.BOOLEAN_FUNCTIONS;
    }

    public Ands coercePredicates(Seq<Expression> predicates) {
        Seq mapped = (Seq)predicates.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Expression apply(Expression x0$1) {
                Object object;
                Expression expression = x0$1;
                if (expression instanceof PatternExpression) {
                    PatternExpression patternExpression = (PatternExpression)expression;
                    object = new GreaterThan((Expression)FunctionInvocation$.MODULE$.apply(new FunctionName(Length$.MODULE$.name(), patternExpression.position()), (Expression)patternExpression, patternExpression.position()), (Expression)new UnsignedDecimalIntegerLiteral("0", patternExpression.position()), patternExpression.position());
                } else if (expression instanceof FilterExpression) {
                    FilterExpression filterExpression = (FilterExpression)expression;
                    object = new GreaterThan((Expression)FunctionInvocation$.MODULE$.apply(new FunctionName(Size$.MODULE$.name(), filterExpression.position()), (Expression)filterExpression, filterExpression.position()), (Expression)new UnsignedDecimalIntegerLiteral("0", filterExpression.position()), filterExpression.position());
                } else if (expression instanceof ExtractExpression) {
                    ExtractExpression extractExpression = (ExtractExpression)expression;
                    object = new GreaterThan((Expression)FunctionInvocation$.MODULE$.apply(new FunctionName(Size$.MODULE$.name(), extractExpression.position()), (Expression)extractExpression, extractExpression.position()), (Expression)new UnsignedDecimalIntegerLiteral("0", extractExpression.position()), extractExpression.position());
                } else if (expression instanceof ListComprehension) {
                    ListComprehension listComprehension = (ListComprehension)expression;
                    object = new GreaterThan((Expression)FunctionInvocation$.MODULE$.apply(new FunctionName(Size$.MODULE$.name(), listComprehension.position()), (Expression)listComprehension, listComprehension.position()), (Expression)new UnsignedDecimalIntegerLiteral("0", listComprehension.position()), listComprehension.position());
                } else {
                    object = PredicateHelper$.MODULE$.isPredicate(expression) ? expression : new CoerceToPredicate(expression);
                }
                return object;
            }
        }, Seq$.MODULE$.canBuildFrom());
        if (mapped.isEmpty()) {
            throw new InternalException("Selection need at least one predicate", InternalException$.MODULE$.$lessinit$greater$default$2());
        }
        return new Ands(mapped.toSet(), ((ASTNode)mapped.head()).position());
    }

    public boolean isPredicate(Expression expression) {
        boolean bl;
        Expression expression2 = expression;
        if (expression2 instanceof OperatorExpression) {
            Expression expression3 = expression2;
            bl = ((OperatorExpression)expression3).signatures().forall((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(TypeSignature x$1) {
                    CypherType cypherType = x$1.outputType();
                    BooleanType booleanType = package$.MODULE$.CTBoolean();
                    return !(cypherType != null ? !cypherType.equals(booleanType) : booleanType != null);
                }
            });
        } else if (expression2 instanceof FunctionInvocation) {
            FunctionInvocation functionInvocation = (FunctionInvocation)expression2;
            bl = this.BOOLEAN_FUNCTIONS().contains((Object)functionInvocation.function());
        } else if (expression2 instanceof ResolvedFunctionInvocation) {
            ResolvedFunctionInvocation resolvedFunctionInvocation = (ResolvedFunctionInvocation)expression2;
            bl = resolvedFunctionInvocation.fcnSignature().forall((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(UserFunctionSignature x$2) {
                    CypherType cypherType = x$2.outputType();
                    BooleanType booleanType = package$.MODULE$.CTBoolean();
                    return !(cypherType != null ? !cypherType.equals(booleanType) : booleanType != null);
                }
            });
        } else {
            boolean bl2 = expression2 instanceof Ands ? true : (expression2 instanceof Ors ? true : (expression2 instanceof In ? true : (expression2 instanceof BooleanLiteral ? true : (expression2 instanceof HasLabels ? true : (expression2 instanceof AndedPropertyInequalities ? true : expression2 instanceof IterablePredicateExpression)))));
            bl = bl2;
        }
        return bl;
    }

    private PredicateHelper$() {
        MODULE$ = this;
        this.BOOLEAN_FUNCTIONS = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Function[]{Exists$.MODULE$, ToBoolean$.MODULE$}));
    }
}

