/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.planner.spi;

import java.io.Serializable;
import org.neo4j.cypher.internal.logical.plans.DoNotGetValue$;
import org.neo4j.cypher.internal.logical.plans.GetValueFromIndexBehavior;
import org.neo4j.cypher.internal.planner.spi.IndexBehaviour;
import org.neo4j.cypher.internal.planner.spi.IndexDescriptor;
import org.neo4j.cypher.internal.planner.spi.IndexDescriptor$EntityType$;
import org.neo4j.cypher.internal.planner.spi.IndexOrderCapability;
import org.neo4j.cypher.internal.planner.spi.IndexOrderCapability$NONE$;
import org.neo4j.cypher.internal.util.LabelId;
import org.neo4j.cypher.internal.util.NameId;
import org.neo4j.cypher.internal.util.PropertyKeyId;
import org.neo4j.cypher.internal.util.RelTypeId;
import org.neo4j.cypher.internal.util.symbols.AnyType;
import org.neo4j.cypher.internal.util.symbols.BooleanType;
import org.neo4j.cypher.internal.util.symbols.CypherType;
import org.neo4j.cypher.internal.util.symbols.DateTimeType;
import org.neo4j.cypher.internal.util.symbols.DateType;
import org.neo4j.cypher.internal.util.symbols.DurationType;
import org.neo4j.cypher.internal.util.symbols.FloatType;
import org.neo4j.cypher.internal.util.symbols.GeometryType;
import org.neo4j.cypher.internal.util.symbols.GraphRefType;
import org.neo4j.cypher.internal.util.symbols.IntegerType;
import org.neo4j.cypher.internal.util.symbols.ListType$;
import org.neo4j.cypher.internal.util.symbols.LocalDateTimeType;
import org.neo4j.cypher.internal.util.symbols.LocalTimeType;
import org.neo4j.cypher.internal.util.symbols.MapType;
import org.neo4j.cypher.internal.util.symbols.NodeType;
import org.neo4j.cypher.internal.util.symbols.NumberType;
import org.neo4j.cypher.internal.util.symbols.PathType;
import org.neo4j.cypher.internal.util.symbols.PointType;
import org.neo4j.cypher.internal.util.symbols.RelationshipType;
import org.neo4j.cypher.internal.util.symbols.StringType;
import org.neo4j.cypher.internal.util.symbols.TimeType;
import org.neo4j.internal.schema.IndexCapability;
import org.neo4j.values.storable.ValueCategory;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple8;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class IndexDescriptor$
implements Serializable {
    public static final IndexDescriptor$ MODULE$ = new IndexDescriptor$();

    public Set<IndexBehaviour> $lessinit$greater$default$4() {
        return Predef$.MODULE$.Set().empty();
    }

    public IndexOrderCapability $lessinit$greater$default$5() {
        return IndexOrderCapability$NONE$.MODULE$;
    }

    public GetValueFromIndexBehavior $lessinit$greater$default$6() {
        return DoNotGetValue$.MODULE$;
    }

    public Option<IndexCapability> $lessinit$greater$default$7() {
        return None$.MODULE$;
    }

    public boolean $lessinit$greater$default$8() {
        return false;
    }

    public IndexDescriptor forLabel(IndexDescriptor.IndexType indexType, LabelId labelId, Seq<PropertyKeyId> properties) {
        return new IndexDescriptor(indexType, new IndexDescriptor.EntityType.Node(labelId), properties, this.apply$default$4(), this.apply$default$5(), this.apply$default$6(), this.apply$default$7(), this.apply$default$8());
    }

    public IndexDescriptor forRelType(IndexDescriptor.IndexType indexType, RelTypeId relTypeId, Seq<PropertyKeyId> properties) {
        return new IndexDescriptor(indexType, new IndexDescriptor.EntityType.Relationship(relTypeId), properties, this.apply$default$4(), this.apply$default$5(), this.apply$default$6(), this.apply$default$7(), this.apply$default$8());
    }

    public IndexDescriptor forNameId(IndexDescriptor.IndexType indexType, NameId labelOrRelTypeId, Seq<PropertyKeyId> properties) {
        return new IndexDescriptor(indexType, IndexDescriptor$EntityType$.MODULE$.of(labelOrRelTypeId), properties, this.apply$default$4(), this.apply$default$5(), this.apply$default$6(), this.apply$default$7(), this.apply$default$8());
    }

    public int[] toKernelEncode(Seq<PropertyKeyId> properties) {
        return (int[])((IterableOnceOps)properties.map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.id()))).toArray((ClassTag)ClassTag$.MODULE$.Int());
    }

    private ValueCategory toArrayValueCategory(CypherType cypherType) {
        CypherType cypherType2 = cypherType;
        if (cypherType2 instanceof AnyType) {
            return ValueCategory.ANYTHING;
        }
        if (cypherType2 instanceof DateType) {
            return ValueCategory.TEMPORAL_ARRAY;
        }
        if (cypherType2 instanceof NodeType) {
            return ValueCategory.UNKNOWN;
        }
        if (cypherType2 instanceof PathType) {
            return ValueCategory.UNKNOWN;
        }
        if (cypherType2 instanceof TimeType) {
            return ValueCategory.TEMPORAL_ARRAY;
        }
        if (cypherType2 instanceof FloatType) {
            return ValueCategory.NUMBER_ARRAY;
        }
        if (cypherType2 instanceof PointType) {
            return ValueCategory.GEOMETRY_ARRAY;
        }
        if (cypherType2 instanceof NumberType) {
            return ValueCategory.NUMBER_ARRAY;
        }
        if (cypherType2 instanceof StringType) {
            return ValueCategory.TEXT_ARRAY;
        }
        if (cypherType2 instanceof BooleanType) {
            return ValueCategory.BOOLEAN_ARRAY;
        }
        if (cypherType2 instanceof IntegerType) {
            return ValueCategory.NUMBER_ARRAY;
        }
        if (cypherType2 instanceof DateTimeType) {
            return ValueCategory.TEMPORAL_ARRAY;
        }
        if (cypherType2 instanceof DurationType) {
            return ValueCategory.TEMPORAL_ARRAY;
        }
        if (cypherType2 instanceof GeometryType) {
            return ValueCategory.GEOMETRY_ARRAY;
        }
        if (cypherType2 instanceof GraphRefType) {
            return ValueCategory.UNKNOWN;
        }
        if (cypherType2 instanceof LocalTimeType) {
            return ValueCategory.TEMPORAL_ARRAY;
        }
        if (cypherType2 instanceof RelationshipType) {
            return ValueCategory.UNKNOWN;
        }
        if (cypherType2 instanceof LocalDateTimeType) {
            return ValueCategory.TEMPORAL_ARRAY;
        }
        if (cypherType2 instanceof MapType) {
            return ValueCategory.UNKNOWN;
        }
        return ValueCategory.UNKNOWN;
    }

    public ValueCategory toValueCategory(CypherType cypherType) {
        Option option;
        CypherType cypherType2 = cypherType;
        if (cypherType2 instanceof AnyType) {
            return ValueCategory.ANYTHING;
        }
        if (cypherType2 instanceof DateType) {
            return ValueCategory.TEMPORAL;
        }
        if (cypherType2 instanceof NodeType) {
            return ValueCategory.UNKNOWN;
        }
        if (cypherType2 instanceof PathType) {
            return ValueCategory.UNKNOWN;
        }
        if (cypherType2 instanceof TimeType) {
            return ValueCategory.TEMPORAL;
        }
        if (cypherType2 instanceof FloatType) {
            return ValueCategory.NUMBER;
        }
        if (cypherType2 instanceof PointType) {
            return ValueCategory.GEOMETRY;
        }
        if (cypherType2 instanceof NumberType) {
            return ValueCategory.NUMBER;
        }
        if (cypherType2 instanceof StringType) {
            return ValueCategory.TEXT;
        }
        if (cypherType2 instanceof BooleanType) {
            return ValueCategory.BOOLEAN;
        }
        if (cypherType2 instanceof IntegerType) {
            return ValueCategory.NUMBER;
        }
        if (cypherType2 instanceof DateTimeType) {
            return ValueCategory.TEMPORAL;
        }
        if (cypherType2 instanceof DurationType) {
            return ValueCategory.TEMPORAL;
        }
        if (cypherType2 instanceof GeometryType) {
            return ValueCategory.GEOMETRY;
        }
        if (cypherType2 instanceof GraphRefType) {
            return ValueCategory.UNKNOWN;
        }
        if (cypherType2 instanceof LocalTimeType) {
            return ValueCategory.TEMPORAL;
        }
        if (cypherType2 instanceof RelationshipType) {
            return ValueCategory.UNKNOWN;
        }
        if (cypherType2 instanceof LocalDateTimeType) {
            return ValueCategory.TEMPORAL;
        }
        if (cypherType2 instanceof MapType) {
            return ValueCategory.UNKNOWN;
        }
        if (cypherType2 != null && !(option = ListType$.MODULE$.unapply(cypherType2)).isEmpty()) {
            CypherType cypherType3 = (CypherType)option.get();
            return this.toArrayValueCategory(cypherType3);
        }
        return ValueCategory.UNKNOWN;
    }

    public IndexDescriptor apply(IndexDescriptor.IndexType indexType, IndexDescriptor.EntityType entityType, Seq<PropertyKeyId> properties, Set<IndexBehaviour> behaviours, IndexOrderCapability orderCapability, GetValueFromIndexBehavior valueCapability, Option<IndexCapability> maybeKernelIndexCapability, boolean isUnique) {
        return new IndexDescriptor(indexType, entityType, properties, behaviours, orderCapability, valueCapability, maybeKernelIndexCapability, isUnique);
    }

    public Set<IndexBehaviour> apply$default$4() {
        return Predef$.MODULE$.Set().empty();
    }

    public IndexOrderCapability apply$default$5() {
        return IndexOrderCapability$NONE$.MODULE$;
    }

    public GetValueFromIndexBehavior apply$default$6() {
        return DoNotGetValue$.MODULE$;
    }

    public Option<IndexCapability> apply$default$7() {
        return None$.MODULE$;
    }

    public boolean apply$default$8() {
        return false;
    }

    public Option<Tuple8<IndexDescriptor.IndexType, IndexDescriptor.EntityType, Seq<PropertyKeyId>, Set<IndexBehaviour>, IndexOrderCapability, GetValueFromIndexBehavior, Option<IndexCapability>, Object>> unapply(IndexDescriptor x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple8((Object)x$0.indexType(), (Object)x$0.entityType(), x$0.properties(), x$0.behaviours(), (Object)x$0.orderCapability(), (Object)x$0.valueCapability(), x$0.maybeKernelIndexCapability(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.isUnique())));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(IndexDescriptor$.class);
    }

    private IndexDescriptor$() {
    }
}

