/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.helpers;

import org.neo4j.cypher.internal.util.BucketSize;
import org.neo4j.cypher.internal.util.UnknownSize$;
import org.neo4j.cypher.internal.util.symbols.CypherType;
import org.neo4j.cypher.internal.util.symbols.ListType;
import org.neo4j.cypher.internal.util.symbols.ParameterTypeInfo;
import org.neo4j.cypher.internal.util.symbols.ParameterTypeInfo$;
import org.neo4j.cypher.internal.util.symbols.package$;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.BooleanValue;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.FloatingPointValue;
import org.neo4j.values.storable.IntegralValue;
import org.neo4j.values.storable.LocalDateTimeValue;
import org.neo4j.values.storable.LocalTimeValue;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.TimeValue;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.MapValue;
import scala.Predef;
import scala.Predef$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.mutable.Builder;

public final class ParameterValueTypeHelper$ {
    public static final ParameterValueTypeHelper$ MODULE$ = new ParameterValueTypeHelper$();

    public Map<String, ParameterTypeInfo> asCypherTypeMap(MapValue map2, boolean useSizeHint) {
        Builder builder = Map$.MODULE$.newBuilder();
        map2.keySet().forEach(key -> builder.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(key), (Object)MODULE$.deriveCypherType(map2.get(key), useSizeHint))));
        return (Map)builder.result();
    }

    public ParameterTypeInfo deriveCypherType(AnyValue obj, boolean useSizeHint) {
        boolean bl = false;
        TextValue textValue = null;
        AnyValue anyValue = obj;
        if (anyValue instanceof TextValue) {
            bl = true;
            textValue = (TextValue)anyValue;
            if (useSizeHint) {
                return ParameterTypeInfo$.MODULE$.info((CypherType)package$.MODULE$.CTString(), textValue.length());
            }
        }
        if (bl) {
            return ParameterTypeInfo$.MODULE$.STRING();
        }
        if (anyValue instanceof BooleanValue) {
            return ParameterTypeInfo$.MODULE$.BOOL();
        }
        if (anyValue instanceof IntegralValue) {
            return ParameterTypeInfo$.MODULE$.INT();
        }
        if (anyValue instanceof FloatingPointValue) {
            return ParameterTypeInfo$.MODULE$.FLOAT();
        }
        if (anyValue instanceof PointValue) {
            return ParameterTypeInfo$.MODULE$.POINT();
        }
        if (anyValue instanceof DateTimeValue) {
            return ParameterTypeInfo$.MODULE$.DATE_TIME();
        }
        if (anyValue instanceof LocalDateTimeValue) {
            return ParameterTypeInfo$.MODULE$.LOCAL_DATE_TIME();
        }
        if (anyValue instanceof TimeValue) {
            return ParameterTypeInfo$.MODULE$.TIME();
        }
        if (anyValue instanceof LocalTimeValue) {
            return ParameterTypeInfo$.MODULE$.LOCAL_TIME();
        }
        if (anyValue instanceof DateValue) {
            return ParameterTypeInfo$.MODULE$.DATE();
        }
        if (anyValue instanceof DurationValue) {
            return ParameterTypeInfo$.MODULE$.DURATION();
        }
        if (anyValue instanceof MapValue) {
            return ParameterTypeInfo$.MODULE$.MAP();
        }
        if (anyValue instanceof ListValue) {
            ListType typ;
            ListValue listValue = (ListValue)anyValue;
            ValueGroup valueGroup = listValue.itemValueRepresentation().valueGroup();
            ValueGroup valueGroup2 = ValueGroup.TEXT;
            ListType listType = !(valueGroup != null ? !valueGroup.equals(valueGroup2) : valueGroup2 != null) ? package$.MODULE$.CTList((CypherType)package$.MODULE$.CTString()) : (typ = package$.MODULE$.CTList((CypherType)package$.MODULE$.CTAny()));
            if (useSizeHint) {
                return ParameterTypeInfo$.MODULE$.info((CypherType)typ, listValue.intSize());
            }
            return ParameterTypeInfo$.MODULE$.apply((CypherType)typ, (BucketSize)UnknownSize$.MODULE$);
        }
        return ParameterTypeInfo$.MODULE$.ANY();
    }

    private ParameterValueTypeHelper$() {
    }
}

