/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.neo4j.kernel.api.KernelTransactionHandle;
import org.neo4j.kernel.api.query.QuerySnapshot;
import org.neo4j.lock.ActiveLock;
import org.neo4j.lock.LockType;
import org.neo4j.lock.ResourceType;

public class TransactionDependenciesResolver {
    private final Map<KernelTransactionHandle, Optional<QuerySnapshot>> handleSnapshotsMap;
    private final Map<KernelTransactionHandle, Set<KernelTransactionHandle>> directDependencies;

    public TransactionDependenciesResolver(Map<KernelTransactionHandle, Optional<QuerySnapshot>> handleSnapshotsMap) {
        this.handleSnapshotsMap = handleSnapshotsMap;
        this.directDependencies = this.initDirectDependencies();
    }

    public boolean isBlocked(KernelTransactionHandle handle) {
        return this.directDependencies.get(handle) != null;
    }

    public String describeBlockingTransactions(KernelTransactionHandle handle) {
        TreeSet<KernelTransactionHandle> allBlockers = new TreeSet<KernelTransactionHandle>(Comparator.comparingLong(KernelTransactionHandle::getTransactionSequenceNumber));
        Set<KernelTransactionHandle> handles = this.directDependencies.get(handle);
        if (handles != null) {
            ArrayDeque<KernelTransactionHandle> blockerQueue = new ArrayDeque<KernelTransactionHandle>(handles);
            while (!blockerQueue.isEmpty()) {
                Set<KernelTransactionHandle> transactionHandleSet;
                KernelTransactionHandle transactionHandle = (KernelTransactionHandle)blockerQueue.pop();
                if (!allBlockers.add(transactionHandle) || (transactionHandleSet = this.directDependencies.get(transactionHandle)) == null) continue;
                blockerQueue.addAll(transactionHandleSet);
            }
        }
        return TransactionDependenciesResolver.describe(allBlockers);
    }

    private Map<KernelTransactionHandle, Set<KernelTransactionHandle>> initDirectDependencies() {
        HashMap<KernelTransactionHandle, Set<KernelTransactionHandle>> directDependencies = new HashMap<KernelTransactionHandle, Set<KernelTransactionHandle>>();
        Map<KernelTransactionHandle, Collection<ActiveLock>> transactionLocksMap = this.handleSnapshotsMap.keySet().stream().collect(Collectors.toMap(Function.identity(), TransactionDependenciesResolver.getTransactionLocks()));
        for (Map.Entry<KernelTransactionHandle, Optional<QuerySnapshot>> entry : this.handleSnapshotsMap.entrySet()) {
            Optional<QuerySnapshot> snapshot = entry.getValue();
            if (!snapshot.isPresent()) continue;
            KernelTransactionHandle txHandle = entry.getKey();
            TransactionDependenciesResolver.evaluateDirectDependencies(directDependencies, transactionLocksMap, txHandle, snapshot.get());
        }
        return directDependencies;
    }

    private static Function<KernelTransactionHandle, Collection<ActiveLock>> getTransactionLocks() {
        return KernelTransactionHandle::activeLocks;
    }

    private static void evaluateDirectDependencies(Map<KernelTransactionHandle, Set<KernelTransactionHandle>> directDependencies, Map<KernelTransactionHandle, Collection<ActiveLock>> handleLocksMap, KernelTransactionHandle txHandle, QuerySnapshot querySnapshot) {
        List waitingOnLocks = querySnapshot.waitingLocks();
        for (ActiveLock activeLock : waitingOnLocks) {
            for (Map.Entry<KernelTransactionHandle, Collection<ActiveLock>> handleListEntry : handleLocksMap.entrySet()) {
                KernelTransactionHandle kernelTransactionHandle = handleListEntry.getKey();
                if (kernelTransactionHandle.equals((Object)txHandle) || !TransactionDependenciesResolver.isBlocked(activeLock, handleListEntry.getValue())) continue;
                Set kernelTransactionHandles = directDependencies.computeIfAbsent(txHandle, handle -> new HashSet());
                kernelTransactionHandles.add(kernelTransactionHandle);
            }
        }
    }

    private static boolean isBlocked(ActiveLock activeLock, Collection<ActiveLock> activeLocks) {
        return LockType.EXCLUSIVE == activeLock.lockType() ? TransactionDependenciesResolver.haveAnyLocking(activeLocks, activeLock.resourceType(), activeLock.resourceId()) : TransactionDependenciesResolver.haveExclusiveLocking(activeLocks, activeLock.resourceType(), activeLock.resourceId());
    }

    private static boolean haveAnyLocking(Collection<ActiveLock> locks, ResourceType resourceType, long resourceId) {
        return locks.stream().anyMatch(lock -> lock.resourceId() == resourceId && lock.resourceType() == resourceType);
    }

    private static boolean haveExclusiveLocking(Collection<ActiveLock> locks, ResourceType resourceType, long resourceId) {
        return locks.stream().anyMatch(lock -> LockType.EXCLUSIVE == lock.lockType() && lock.resourceId() == resourceId && lock.resourceType() == resourceType);
    }

    private static String describe(Set<KernelTransactionHandle> allBlockers) {
        if (allBlockers.isEmpty()) {
            return "";
        }
        StringJoiner stringJoiner = new StringJoiner(", ", "[", "]");
        for (KernelTransactionHandle blocker : allBlockers) {
            stringJoiner.add(blocker.getUserTransactionName());
        }
        return stringJoiner.toString();
    }
}

