/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers.traversal.productgraph;

import java.util.Objects;
import java.util.function.LongPredicate;
import org.neo4j.internal.kernel.api.helpers.traversal.productgraph.State;
import org.neo4j.internal.kernel.api.helpers.traversal.productgraph.Transition;
import org.neo4j.util.Preconditions;

public final class NodeJuxtaposition
implements Transition {
    private final LongPredicate nodePredicate;
    private State targetState;

    public NodeJuxtaposition(LongPredicate nodePredicate, State targetState) {
        this.nodePredicate = nodePredicate;
        this.targetState = targetState;
    }

    public boolean testNode(long node) {
        return this.nodePredicate.test(node);
    }

    @Override
    public State targetState() {
        return this.targetState;
    }

    @Override
    public void setTargetState(State state) {
        Preconditions.checkState((this.targetState == null ? 1 : 0) != 0, (String)"Shouldn't set target state more than once. The targetState field is only mutable to support delayed initialization which is require when there are cycles in the NFA");
        this.targetState = state;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        NodeJuxtaposition that = (NodeJuxtaposition)obj;
        return Objects.equals(this.nodePredicate, that.nodePredicate) && Objects.equals(this.targetState, that.targetState);
    }

    public int hashCode() {
        return Objects.hash(this.nodePredicate, this.targetState);
    }

    public String toString() {
        return "NodeJuxtaposition[nodePredicates=" + this.nodePredicate + ", targetState=" + this.targetState + "]";
    }
}

