/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.slotted.pipes;

import java.io.Serializable;
import java.util.function.ToLongFunction;
import org.neo4j.cypher.internal.expressions.SemanticDirection;
import org.neo4j.cypher.internal.logical.plans.FindShortestPaths;
import org.neo4j.cypher.internal.physicalplanning.Slot;
import org.neo4j.cypher.internal.physicalplanning.SlotConfiguration;
import org.neo4j.cypher.internal.physicalplanning.SlotConfigurationUtils$;
import org.neo4j.cypher.internal.planner.spi.ReadTokenContext;
import org.neo4j.cypher.internal.runtime.ClosingIterator;
import org.neo4j.cypher.internal.runtime.ClosingIterator$;
import org.neo4j.cypher.internal.runtime.CypherRow;
import org.neo4j.cypher.internal.runtime.ReadableRow;
import org.neo4j.cypher.internal.runtime.interpreted.commands.convert.DirectionConverter$;
import org.neo4j.cypher.internal.runtime.interpreted.commands.predicates.Predicate;
import org.neo4j.cypher.internal.runtime.interpreted.commands.predicates.True;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.Pipe;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.PipeWithSource;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.QueryState;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.RelationshipTypes;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.TraversalPredicates;
import org.neo4j.cypher.internal.runtime.slotted.SlottedRow;
import org.neo4j.cypher.internal.runtime.slotted.pipes.ShortestPathSlottedPipe$;
import org.neo4j.graphdb.Direction;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.internal.kernel.api.helpers.traversal.BiDirectionalBFS;
import org.neo4j.lang.AutoCloseablePlus;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.values.AnyValue;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.RelationshipReference;
import org.neo4j.values.virtual.VirtualValues;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple15;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\r%f\u0001B%K\u0001fC\u0001B\u001e\u0001\u0003\u0016\u0004%\ta\u001e\u0005\tq\u0002\u0011\t\u0012)A\u0005C\"A\u0011\u0010\u0001BK\u0002\u0013\u0005!\u0010C\u0005\u0002\u0004\u0001\u0011\t\u0012)A\u0005w\"I\u0011Q\u0001\u0001\u0003\u0016\u0004%\tA\u001f\u0005\n\u0003\u000f\u0001!\u0011#Q\u0001\nmD!\"!\u0003\u0001\u0005+\u0007I\u0011AA\u0006\u0011)\t\u0019\u0002\u0001B\tB\u0003%\u0011Q\u0002\u0005\u000b\u0003+\u0001!Q3A\u0005\u0002\u0005-\u0001BCA\f\u0001\tE\t\u0015!\u0003\u0002\u000e!Q\u0011\u0011\u0004\u0001\u0003\u0016\u0004%\t!a\u0007\t\u0015\u0005\r\u0002A!E!\u0002\u0013\ti\u0002\u0003\u0006\u0002&\u0001\u0011)\u001a!C\u0001\u0003OA!\"!\u000e\u0001\u0005#\u0005\u000b\u0011BA\u0015\u0011)\t9\u0004\u0001BK\u0002\u0013\u0005\u0011\u0011\b\u0005\u000b\u0003\u0003\u0002!\u0011#Q\u0001\n\u0005m\u0002BCA\"\u0001\tU\r\u0011\"\u0001\u0002F!Q\u00111\f\u0001\u0003\u0012\u0003\u0006I!a\u0012\t\u0015\u0005u\u0003A!f\u0001\n\u0003\ty\u0006\u0003\u0006\u0002h\u0001\u0011\t\u0012)A\u0005\u0003CB!\"!\u001b\u0001\u0005+\u0007I\u0011AA6\u0011)\tY\n\u0001B\tB\u0003%\u0011Q\u000e\u0005\u000b\u0003;\u0003!Q3A\u0005\u0002\u0005}\u0003BCAP\u0001\tE\t\u0015!\u0003\u0002b!Q\u0011\u0011\u0015\u0001\u0003\u0016\u0004%\t!a)\t\u0015\u0005-\u0006A!E!\u0002\u0013\t)\u000b\u0003\u0006\u0002.\u0002\u0011)\u001a!C\u0001\u0003?B!\"a,\u0001\u0005#\u0005\u000b\u0011BA1\u0011)\t\t\f\u0001BK\u0002\u0013\u0005\u00111\u0017\u0005\u000b\u0003w\u0003!\u0011#Q\u0001\n\u0005U\u0006BCA_\u0001\t\u0015\r\u0011\"\u0001\u0002@\"Q\u0011\u0011\u001b\u0001\u0003\u0002\u0003\u0006I!!1\t\u000f\u0005M\u0007\u0001\"\u0001\u0002V\"I\u0011Q \u0001C\u0002\u0013%\u0011q \u0005\t\u00057\u0001\u0001\u0015!\u0003\u0003\u0002!I!Q\u0004\u0001C\u0002\u0013%\u0011q \u0005\t\u0005?\u0001\u0001\u0015!\u0003\u0003\u0002!9!\u0011\u0005\u0001\u0005R\t\r\u0002\"\u0003B \u0001\u0005\u0005I\u0011\u0001B!\u0011%\u0011)\u0007AI\u0001\n\u0003\u00119\u0007C\u0005\u0003~\u0001\t\n\u0011\"\u0001\u0003\u0000!I!1\u0011\u0001\u0012\u0002\u0013\u0005!q\u0010\u0005\n\u0005\u000b\u0003\u0011\u0013!C\u0001\u0005\u000fC\u0011Ba#\u0001#\u0003%\tAa\"\t\u0013\t5\u0005!%A\u0005\u0002\t=\u0005\"\u0003BJ\u0001E\u0005I\u0011\u0001BK\u0011%\u0011I\nAI\u0001\n\u0003\u0011Y\nC\u0005\u0003 \u0002\t\n\u0011\"\u0001\u0003\"\"I!Q\u0015\u0001\u0012\u0002\u0013\u0005!q\u0015\u0005\n\u0005W\u0003\u0011\u0013!C\u0001\u0005[C\u0011B!-\u0001#\u0003%\tAa*\t\u0013\tM\u0006!%A\u0005\u0002\tU\u0006\"\u0003B]\u0001E\u0005I\u0011\u0001BT\u0011%\u0011Y\fAI\u0001\n\u0003\u0011i\fC\u0005\u0003B\u0002\t\t\u0011\"\u0011\u0003D\"I!\u0011\u001b\u0001\u0002\u0002\u0013\u0005\u00111\u0002\u0005\n\u0005'\u0004\u0011\u0011!C\u0001\u0005+D\u0011B!9\u0001\u0003\u0003%\tEa9\t\u0013\tE\b!!A\u0005\u0002\tM\b\"\u0003B|\u0001\u0005\u0005I\u0011\tB}\u0011%\u0011i\u0010AA\u0001\n\u0003\u0012y\u0010C\u0005\u0004\u0002\u0001\t\t\u0011\"\u0011\u0004\u0004!I1Q\u0001\u0001\u0002\u0002\u0013\u00053qA\u0004\n\u0007\u0017Q\u0015\u0011!E\u0001\u0007\u001b1\u0001\"\u0013&\u0002\u0002#\u00051q\u0002\u0005\b\u0003'\fE\u0011AB\u0011\u0011%\u0019\t!QA\u0001\n\u000b\u001a\u0019\u0001C\u0005\u0004$\u0005\u000b\t\u0011\"!\u0004&!I1\u0011J!\u0012\u0002\u0013\u000511\n\u0005\n\u0007[\n\u0015\u0011!CA\u0007_B\u0011b! B#\u0003%\taa \t\u0013\r}\u0015)!A\u0005\n\r\u0005&aF*i_J$Xm\u001d;QCRD7\u000b\\8ui\u0016$\u0007+\u001b9f\u0015\tYE*A\u0003qSB,7O\u0003\u0002N\u001d\u000691\u000f\\8ui\u0016$'BA(Q\u0003\u001d\u0011XO\u001c;j[\u0016T!!\u0015*\u0002\u0011%tG/\u001a:oC2T!a\u0015+\u0002\r\rL\b\u000f[3s\u0015\t)f+A\u0003oK>$$NC\u0001X\u0003\ry'oZ\u0002\u0001'\u0015\u0001!,\u00193k!\tYv,D\u0001]\u0015\tYUL\u0003\u0002_\u001d\u0006Y\u0011N\u001c;feB\u0014X\r^3e\u0013\t\u0001GL\u0001\bQSB,w+\u001b;i'>,(oY3\u0011\u0005m\u0013\u0017BA2]\u0005\u0011\u0001\u0016\u000e]3\u0011\u0005\u0015DW\"\u00014\u000b\u0003\u001d\fQa]2bY\u0006L!!\u001b4\u0003\u000fA\u0013x\u000eZ;diB\u00111n\u001d\b\u0003YFt!!\u001c9\u000e\u00039T!a\u001c-\u0002\rq\u0012xn\u001c;?\u0013\u00059\u0017B\u0001:g\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001^;\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0005I4\u0017AB:pkJ\u001cW-F\u0001b\u0003\u001d\u0019x.\u001e:dK\u0002\n!b]8ve\u000e,7\u000b\\8u+\u0005Y\bC\u0001?\u0000\u001b\u0005i(B\u0001@Q\u0003A\u0001\b._:jG\u0006d\u0007\u000f\\1o]&tw-C\u0002\u0002\u0002u\u0014Aa\u00157pi\u0006Y1o\\;sG\u0016\u001cFn\u001c;!\u0003)!\u0018M]4fiNcw\u000e^\u0001\fi\u0006\u0014x-\u001a;TY>$\b%\u0001\u0006qCRDwJ\u001a4tKR,\"!!\u0004\u0011\u0007\u0015\fy!C\u0002\u0002\u0012\u0019\u00141!\u00138u\u0003-\u0001\u0018\r\u001e5PM\u001a\u001cX\r\u001e\u0011\u0002\u0015I,Gn](gMN,G/A\u0006sK2\u001cxJ\u001a4tKR\u0004\u0013!\u0002;za\u0016\u001cXCAA\u000f!\rY\u0016qD\u0005\u0004\u0003Ca&!\u0005*fY\u0006$\u0018n\u001c8tQ&\u0004H+\u001f9fg\u00061A/\u001f9fg\u0002\n1\u0001Z5s+\t\tI\u0003\u0005\u0003\u0002,\u0005ERBAA\u0017\u0015\r\ty\u0003U\u0001\fKb\u0004(/Z:tS>t7/\u0003\u0003\u00024\u00055\"!E*f[\u0006tG/[2ESJ,7\r^5p]\u0006!A-\u001b:!\u0003)\u0001(/\u001a3jG\u0006$Xm]\u000b\u0003\u0003w\u00012aWA\u001f\u0013\r\ty\u0004\u0018\u0002\u0014)J\fg/\u001a:tC2\u0004&/\u001a3jG\u0006$Xm]\u0001\faJ,G-[2bi\u0016\u001c\b%\u0001\bqCRD\u0007K]3eS\u000e\fG/Z:\u0016\u0005\u0005\u001d\u0003#B6\u0002J\u00055\u0013bAA&k\n\u00191+Z9\u0011\t\u0005=\u0013qK\u0007\u0003\u0003#RA!a\u000e\u0002T)\u0019\u0011QK/\u0002\u0011\r|W.\\1oINLA!!\u0017\u0002R\tI\u0001K]3eS\u000e\fG/Z\u0001\u0010a\u0006$\b\u000e\u0015:fI&\u001c\u0017\r^3tA\u0005I\"/\u001a;ve:|e.Z*i_J$Xm\u001d;QCRDwJ\u001c7z+\t\t\t\u0007E\u0002f\u0003GJ1!!\u001ag\u0005\u001d\u0011un\u001c7fC:\f!D]3ukJtwJ\\3TQ>\u0014H/Z:u!\u0006$\bn\u00148ms\u0002\nAb]1nK:{G-Z'pI\u0016,\"!!\u001c\u0011\t\u0005=\u0014Q\u0013\b\u0005\u0003c\nyI\u0004\u0003\u0002t\u0005%e\u0002BA;\u0003\u000bsA!a\u001e\u0002\u0004:!\u0011\u0011PAA\u001d\u0011\tY(a \u000f\u00075\fi(C\u0001X\u0013\t)f+\u0003\u0002T)&\u0011\u0011KU\u0005\u0004\u0003\u000f\u0003\u0016a\u00027pO&\u001c\u0017\r\\\u0005\u0005\u0003\u0017\u000bi)A\u0003qY\u0006t7OC\u0002\u0002\bBKA!!%\u0002\u0014\u0006\tb)\u001b8e'\"|'\u000f^3tiB\u000bG\u000f[:\u000b\t\u0005-\u0015QR\u0005\u0005\u0003/\u000bIJ\u0001\u0007TC6,gj\u001c3f\u001b>$WM\u0003\u0003\u0002\u0012\u0006M\u0015!D:b[\u0016tu\u000eZ3N_\u0012,\u0007%A\bbY2|wOW3s_2+gn\u001a;i\u0003A\tG\u000e\\8x5\u0016\u0014x\u000eT3oORD\u0007%\u0001\u0005nCb$U\r\u001d;i+\t\t)\u000bE\u0003f\u0003O\u000bi!C\u0002\u0002*\u001a\u0014aa\u00149uS>t\u0017!C7bq\u0012+\u0007\u000f\u001e5!\u0003=qW-\u001a3P]2LxJ\\3QCRD\u0017\u0001\u00058fK\u0012|e\u000e\\=P]\u0016\u0004\u0016\r\u001e5!\u0003\u0015\u0019Hn\u001c;t+\t\t)\fE\u0002}\u0003oK1!!/~\u0005E\u0019Fn\u001c;D_:4\u0017nZ;sCRLwN\\\u0001\u0007g2|Go\u001d\u0011\u0002\u0005%$WCAAa!\u0011\t\u0019-!4\u000e\u0005\u0005\u0015'\u0002BAd\u0003\u0013\f1\"\u0019;ue&\u0014W\u000f^5p]*\u0019\u00111\u001a)\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003\u001f\f)M\u0001\u0002JI\u0006\u0019\u0011\u000e\u001a\u0011\u0002\rqJg.\u001b;?)\u0001\n9.a8\u0002b\u0006\r\u0018Q]At\u0003S\fY/!<\u0002p\u0006E\u00181_A{\u0003o\fI0a?\u0015\t\u0005e\u0017Q\u001c\t\u0004\u00037\u0004Q\"\u0001&\t\u0013\u0005u\u0016\u0005%AA\u0002\u0005\u0005\u0007\"\u0002<\"\u0001\u0004\t\u0007\"B=\"\u0001\u0004Y\bBBA\u0003C\u0001\u00071\u0010C\u0004\u0002\n\u0005\u0002\r!!\u0004\t\u000f\u0005U\u0011\u00051\u0001\u0002\u000e!9\u0011\u0011D\u0011A\u0002\u0005u\u0001bBA\u0013C\u0001\u0007\u0011\u0011\u0006\u0005\b\u0003o\t\u0003\u0019AA\u001e\u0011\u001d\t\u0019%\ta\u0001\u0003\u000fBq!!\u0018\"\u0001\u0004\t\t\u0007C\u0004\u0002j\u0005\u0002\r!!\u001c\t\u000f\u0005u\u0015\u00051\u0001\u0002b!9\u0011\u0011U\u0011A\u0002\u0005\u0015\u0006bBAWC\u0001\u0007\u0011\u0011\r\u0005\b\u0003c\u000b\u0003\u0019AA[\u0003U9W\r^*pkJ\u001cWMT8eK\u001a+hn\u0019;j_:,\"A!\u0001\u0011\r\t\r!q\u0002B\n\u001b\t\u0011)A\u0003\u0003\u0003\b\t%\u0011\u0001\u00034v]\u000e$\u0018n\u001c8\u000b\t\u0005-'1\u0002\u0006\u0003\u0005\u001b\tAA[1wC&!!\u0011\u0003B\u0003\u00059!v\u000eT8oO\u001a+hn\u0019;j_:\u0004BA!\u0006\u0003\u00185\ta*C\u0002\u0003\u001a9\u00131BU3bI\u0006\u0014G.\u001a*po\u00061r-\u001a;T_V\u00148-\u001a(pI\u00164UO\\2uS>t\u0007%A\u000bhKR$\u0016M]4fi:{G-\u001a$v]\u000e$\u0018n\u001c8\u0002-\u001d,G\u000fV1sO\u0016$hj\u001c3f\rVt7\r^5p]\u0002\nQ#\u001b8uKJt\u0017\r\\\"sK\u0006$XMU3tk2$8\u000f\u0006\u0004\u0003&\tE\"Q\u0007\t\u0007\u0005+\u00119Ca\u000b\n\u0007\t%bJA\bDY>\u001c\u0018N\\4Ji\u0016\u0014\u0018\r^8s!\u0011\u0011)B!\f\n\u0007\t=bJA\u0005DsBDWM\u001d*po\"9!1\u0007\u0014A\u0002\t\u0015\u0012!B5oaV$\bb\u0002B\u001cM\u0001\u0007!\u0011H\u0001\u0006gR\fG/\u001a\t\u00047\nm\u0012b\u0001B\u001f9\nQ\u0011+^3ssN#\u0018\r^3\u0002\t\r|\u0007/\u001f\u000b!\u0005\u0007\u00129E!\u0013\u0003L\t5#q\nB)\u0005'\u0012)Fa\u0016\u0003Z\tm#Q\fB0\u0005C\u0012\u0019\u0007\u0006\u0003\u0002Z\n\u0015\u0003bBA_O\u0001\u0007\u0011\u0011\u0019\u0005\bm\u001e\u0002\n\u00111\u0001b\u0011\u001dIx\u0005%AA\u0002mD\u0001\"!\u0002(!\u0003\u0005\ra\u001f\u0005\n\u0003\u00139\u0003\u0013!a\u0001\u0003\u001bA\u0011\"!\u0006(!\u0003\u0005\r!!\u0004\t\u0013\u0005eq\u0005%AA\u0002\u0005u\u0001\"CA\u0013OA\u0005\t\u0019AA\u0015\u0011%\t9d\nI\u0001\u0002\u0004\tY\u0004C\u0005\u0002D\u001d\u0002\n\u00111\u0001\u0002H!I\u0011QL\u0014\u0011\u0002\u0003\u0007\u0011\u0011\r\u0005\n\u0003S:\u0003\u0013!a\u0001\u0003[B\u0011\"!((!\u0003\u0005\r!!\u0019\t\u0013\u0005\u0005v\u0005%AA\u0002\u0005\u0015\u0006\"CAWOA\u0005\t\u0019AA1\u0011%\t\tl\nI\u0001\u0002\u0004\t),\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\t%$fA1\u0003l-\u0012!Q\u000e\t\u0005\u0005_\u0012I(\u0004\u0002\u0003r)!!1\u000fB;\u0003%)hn\u00195fG.,GMC\u0002\u0003x\u0019\f!\"\u00198o_R\fG/[8o\u0013\u0011\u0011YH!\u001d\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\t\u0005%fA>\u0003l\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001a\u0014AD2paf$C-\u001a4bk2$H\u0005N\u000b\u0003\u0005\u0013SC!!\u0004\u0003l\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012*\u0014AD2paf$C-\u001a4bk2$HEN\u000b\u0003\u0005#SC!!\b\u0003l\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012:TC\u0001BLU\u0011\tICa\u001b\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%qU\u0011!Q\u0014\u0016\u0005\u0003w\u0011Y'\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001d\u0016\u0005\t\r&\u0006BA$\u0005W\nqbY8qs\u0012\"WMZ1vYR$\u0013\u0007M\u000b\u0003\u0005SSC!!\u0019\u0003l\u0005y1m\u001c9zI\u0011,g-Y;mi\u0012\n\u0014'\u0006\u0002\u00030*\"\u0011Q\u000eB6\u0003=\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE\u0012\u0014aD2paf$C-\u001a4bk2$H%M\u001a\u0016\u0005\t]&\u0006BAS\u0005W\nqbY8qs\u0012\"WMZ1vYR$\u0013\u0007N\u0001\u0010G>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132kU\u0011!q\u0018\u0016\u0005\u0003k\u0013Y'A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0005\u000b\u0004BAa2\u0003N6\u0011!\u0011\u001a\u0006\u0005\u0005\u0017\u0014Y!\u0001\u0003mC:<\u0017\u0002\u0002Bh\u0005\u0013\u0014aa\u0015;sS:<\u0017\u0001\u00049s_\u0012,8\r^!sSRL\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0005/\u0014i\u000eE\u0002f\u00053L1Aa7g\u0005\r\te.\u001f\u0005\n\u0005?L\u0014\u0011!a\u0001\u0003\u001b\t1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XC\u0001Bs!\u0019\u00119O!<\u0003X6\u0011!\u0011\u001e\u0006\u0004\u0005W4\u0017AC2pY2,7\r^5p]&!!q\u001eBu\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005\u0005$Q\u001f\u0005\n\u0005?\\\u0014\u0011!a\u0001\u0005/\f!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!!Q\u0019B~\u0011%\u0011y\u000ePA\u0001\u0002\u0004\ti!\u0001\u0005iCND7i\u001c3f)\t\ti!\u0001\u0005u_N#(/\u001b8h)\t\u0011)-\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003C\u001aI\u0001C\u0005\u0003`~\n\t\u00111\u0001\u0003X\u000692\u000b[8si\u0016\u001cH\u000fU1uQNcw\u000e\u001e;fIBK\u0007/\u001a\t\u0004\u00037\f5#B!\u0004\u0012\r]\u0001cA3\u0004\u0014%\u00191Q\u00034\u0003\r\u0005s\u0017PU3g!\u0011\u0019Iba\b\u000e\u0005\rm!\u0002BB\u000f\u0005\u0017\t!![8\n\u0007Q\u001cY\u0002\u0006\u0002\u0004\u000e\u0005)\u0011\r\u001d9msR\u00013qEB\u0016\u0007[\u0019yc!\r\u00044\rU2qGB\u001d\u0007w\u0019ida\u0010\u0004B\r\r3QIB$)\u0011\tIn!\u000b\t\u0013\u0005uF\t%AA\u0002\u0005\u0005\u0007\"\u0002<E\u0001\u0004\t\u0007\"B=E\u0001\u0004Y\bBBA\u0003\t\u0002\u00071\u0010C\u0004\u0002\n\u0011\u0003\r!!\u0004\t\u000f\u0005UA\t1\u0001\u0002\u000e!9\u0011\u0011\u0004#A\u0002\u0005u\u0001bBA\u0013\t\u0002\u0007\u0011\u0011\u0006\u0005\b\u0003o!\u0005\u0019AA\u001e\u0011\u001d\t\u0019\u0005\u0012a\u0001\u0003\u000fBq!!\u0018E\u0001\u0004\t\t\u0007C\u0004\u0002j\u0011\u0003\r!!\u001c\t\u000f\u0005uE\t1\u0001\u0002b!9\u0011\u0011\u0015#A\u0002\u0005\u0015\u0006bBAW\t\u0002\u0007\u0011\u0011\r\u0005\b\u0003c#\u0005\u0019AA[\u0003A\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\nd\u0007\u0006\u0011\u0004N\r=3\u0011KB*\u0007+\u001a9f!\u0017\u0004\\\ru3qLB1\u0007G\u001a)ga\u001a\u0004j\r-$\u0006BAa\u0005WBQA^#A\u0002\u0005DQ!_#A\u0002mDa!!\u0002F\u0001\u0004Y\bbBA\u0005\u000b\u0002\u0007\u0011Q\u0002\u0005\b\u0003+)\u0005\u0019AA\u0007\u0011\u001d\tI\"\u0012a\u0001\u0003;Aq!!\nF\u0001\u0004\tI\u0003C\u0004\u00028\u0015\u0003\r!a\u000f\t\u000f\u0005\rS\t1\u0001\u0002H!9\u0011QL#A\u0002\u0005\u0005\u0004bBA5\u000b\u0002\u0007\u0011Q\u000e\u0005\b\u0003;+\u0005\u0019AA1\u0011\u001d\t\t+\u0012a\u0001\u0003KCq!!,F\u0001\u0004\t\t\u0007C\u0004\u00022\u0016\u0003\r!!.\u0002\u000fUt\u0017\r\u001d9msR!1\u0011OB=!\u0015)\u0017qUB:!y)7QO1|w\u00065\u0011QBA\u000f\u0003S\tY$a\u0012\u0002b\u00055\u0014\u0011MAS\u0003C\n),C\u0002\u0004x\u0019\u0014q\u0001V;qY\u0016\fT\u0007C\u0005\u0004|\u0019\u000b\t\u00111\u0001\u0002Z\u0006\u0019\u0001\u0010\n\u0019\u00029\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00132mQ\u00013QJBA\u0007\u0007\u001b)ia\"\u0004\n\u000e-5QRBH\u0007#\u001b\u0019j!&\u0004\u0018\u000ee51TBO\u0011\u00151x\t1\u0001b\u0011\u0015Ix\t1\u0001|\u0011\u0019\t)a\u0012a\u0001w\"9\u0011\u0011B$A\u0002\u00055\u0001bBA\u000b\u000f\u0002\u0007\u0011Q\u0002\u0005\b\u000339\u0005\u0019AA\u000f\u0011\u001d\t)c\u0012a\u0001\u0003SAq!a\u000eH\u0001\u0004\tY\u0004C\u0004\u0002D\u001d\u0003\r!a\u0012\t\u000f\u0005us\t1\u0001\u0002b!9\u0011\u0011N$A\u0002\u00055\u0004bBAO\u000f\u0002\u0007\u0011\u0011\r\u0005\b\u0003C;\u0005\u0019AAS\u0011\u001d\tik\u0012a\u0001\u0003CBq!!-H\u0001\u0004\t),\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0004$B!!qYBS\u0013\u0011\u00199K!3\u0003\r=\u0013'.Z2u\u0001")
public class ShortestPathSlottedPipe
extends PipeWithSource
implements Product,
Serializable {
    private final Pipe source;
    private final Slot sourceSlot;
    private final Slot targetSlot;
    private final int pathOffset;
    private final int relsOffset;
    private final RelationshipTypes types;
    private final SemanticDirection dir;
    private final TraversalPredicates predicates;
    private final Seq<Predicate> pathPredicates;
    private final boolean returnOneShortestPathOnly;
    private final FindShortestPaths.SameNodeMode sameNodeMode;
    private final boolean allowZeroLength;
    private final Option<Object> maxDepth;
    private final boolean needOnlyOnePath;
    private final SlotConfiguration slots;
    private final int id;
    private final ToLongFunction<ReadableRow> getSourceNodeFunction;
    private final ToLongFunction<ReadableRow> getTargetNodeFunction;

    public static int $lessinit$greater$default$16(Pipe source, Slot sourceSlot, Slot targetSlot, int pathOffset, int relsOffset, RelationshipTypes types, SemanticDirection dir, TraversalPredicates predicates, Seq pathPredicates, boolean returnOneShortestPathOnly, FindShortestPaths.SameNodeMode sameNodeMode, boolean allowZeroLength, Option maxDepth, boolean needOnlyOnePath, SlotConfiguration slots) {
        return ShortestPathSlottedPipe$.MODULE$.$lessinit$greater$default$16(source, sourceSlot, targetSlot, pathOffset, relsOffset, types, dir, predicates, (Seq<Predicate>)pathPredicates, returnOneShortestPathOnly, sameNodeMode, allowZeroLength, (Option<Object>)maxDepth, needOnlyOnePath, slots);
    }

    public static Option<Tuple15<Pipe, Slot, Slot, Object, Object, RelationshipTypes, SemanticDirection, TraversalPredicates, Seq<Predicate>, Object, FindShortestPaths.SameNodeMode, Object, Option<Object>, Object, SlotConfiguration>> unapply(ShortestPathSlottedPipe x$0) {
        return ShortestPathSlottedPipe$.MODULE$.unapply(x$0);
    }

    public static int apply$default$16(Pipe source, Slot sourceSlot, Slot targetSlot, int pathOffset, int relsOffset, RelationshipTypes types, SemanticDirection dir, TraversalPredicates predicates, Seq pathPredicates, boolean returnOneShortestPathOnly, FindShortestPaths.SameNodeMode sameNodeMode, boolean allowZeroLength, Option maxDepth, boolean needOnlyOnePath, SlotConfiguration slots) {
        return ShortestPathSlottedPipe$.MODULE$.apply$default$16(source, sourceSlot, targetSlot, pathOffset, relsOffset, types, dir, predicates, (Seq<Predicate>)pathPredicates, returnOneShortestPathOnly, sameNodeMode, allowZeroLength, (Option<Object>)maxDepth, needOnlyOnePath, slots);
    }

    public static ShortestPathSlottedPipe apply(Pipe source, Slot sourceSlot, Slot targetSlot, int pathOffset, int relsOffset, RelationshipTypes types, SemanticDirection dir, TraversalPredicates predicates, Seq<Predicate> pathPredicates, boolean returnOneShortestPathOnly, FindShortestPaths.SameNodeMode sameNodeMode, boolean allowZeroLength, Option<Object> maxDepth, boolean needOnlyOnePath, SlotConfiguration slots, int id) {
        return ShortestPathSlottedPipe$.MODULE$.apply(source, sourceSlot, targetSlot, pathOffset, relsOffset, types, dir, predicates, pathPredicates, returnOneShortestPathOnly, sameNodeMode, allowZeroLength, maxDepth, needOnlyOnePath, slots, id);
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public Pipe source() {
        return this.source;
    }

    public Slot sourceSlot() {
        return this.sourceSlot;
    }

    public Slot targetSlot() {
        return this.targetSlot;
    }

    public int pathOffset() {
        return this.pathOffset;
    }

    public int relsOffset() {
        return this.relsOffset;
    }

    public RelationshipTypes types() {
        return this.types;
    }

    public SemanticDirection dir() {
        return this.dir;
    }

    public TraversalPredicates predicates() {
        return this.predicates;
    }

    public Seq<Predicate> pathPredicates() {
        return this.pathPredicates;
    }

    public boolean returnOneShortestPathOnly() {
        return this.returnOneShortestPathOnly;
    }

    public FindShortestPaths.SameNodeMode sameNodeMode() {
        return this.sameNodeMode;
    }

    public boolean allowZeroLength() {
        return this.allowZeroLength;
    }

    public Option<Object> maxDepth() {
        return this.maxDepth;
    }

    public boolean needOnlyOnePath() {
        return this.needOnlyOnePath;
    }

    public SlotConfiguration slots() {
        return this.slots;
    }

    public int id() {
        return this.id;
    }

    private ToLongFunction<ReadableRow> getSourceNodeFunction() {
        return this.getSourceNodeFunction;
    }

    private ToLongFunction<ReadableRow> getTargetNodeFunction() {
        return this.getTargetNodeFunction;
    }

    public ClosingIterator<CypherRow> internalCreateResults(ClosingIterator<CypherRow> input, QueryState state) {
        MemoryTracker memoryTracker = state.memoryTrackerForOperatorProvider().memoryTrackerForOperator(this.id());
        NodeCursor nodeCursor = state.query().nodeCursor();
        state.query().resources().trace((AutoCloseablePlus)nodeCursor);
        RelationshipTraversalCursor traversalCursor = state.query().traversalCursor();
        state.query().resources().trace((AutoCloseablePlus)traversalCursor);
        BiDirectionalBFS biDirectionalBFS = BiDirectionalBFS.newEmptyBiDirectionalBFS((int[])this.types().types((ReadTokenContext)state.query()), (Direction)DirectionConverter$.MODULE$.toGraphDb(this.dir()), (int)BoxesRunTime.unboxToInt((Object)this.maxDepth().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> Integer.MAX_VALUE)), (boolean)this.returnOneShortestPathOnly(), (Read)state.query().transactionalContext().dataRead(), (NodeCursor)nodeCursor, (RelationshipTraversalCursor)traversalCursor, (MemoryTracker)memoryTracker, (boolean)this.needOnlyOnePath(), (boolean)this.allowZeroLength());
        Predicate pathPredicate = (Predicate)this.pathPredicates().foldLeft((Object)new True(), (Function2 & Serializable)(x$1, x$2) -> x$1.andWith(x$2));
        ClosingIterator output = input.flatMap((Function1 & Serializable)row -> {
            long sourceNode = this.getSourceNodeFunction().applyAsLong((ReadableRow)row);
            long targetNode = this.getTargetNodeFunction().applyAsLong((ReadableRow)row);
            if (sourceNode != -1L && targetNode != -1L && this.predicates().filterNode((ReadableRow)row, state, state.query().nodeById(sourceNode)) && this.predicates().filterNode((ReadableRow)row, state, state.query().nodeById(targetNode))) {
                if (this.sameNodeMode().shouldReturnEmptyResult(sourceNode, targetNode, this.allowZeroLength())) {
                    return ClosingIterator$.MODULE$.empty();
                }
                biDirectionalBFS.resetForNewRow(sourceNode, targetNode, this.predicates().asNodeIdPredicate((ReadableRow)row, state), this.predicates().asRelCursorPredicate((ReadableRow)row, state));
                Iterator shortestPaths = CollectionConverters$.MODULE$.IteratorHasAsScala(biDirectionalBFS.shortestPathIterator()).asScala().map((Function1 & Serializable)path -> {
                    ListValue rels = VirtualValues.list((AnyValue[])((AnyValue[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.longArrayOps(path.relationshipIds()), (Function1 & Serializable)x$1 -> ShortestPathSlottedPipe.$anonfun$internalCreateResults$5(BoxesRunTime.unboxToLong((Object)x$1)), ClassTag$.MODULE$.apply(RelationshipReference.class))));
                    SlottedRow outputRow = new SlottedRow(this.slots());
                    outputRow.copyAllFrom((ReadableRow)row);
                    outputRow.setRefAt(this.pathOffset(), (AnyValue)path);
                    outputRow.setRefAt(this.relsOffset(), (AnyValue)rels);
                    return outputRow;
                }).filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)pathPredicate.isTrue((ReadableRow)x$3, state)));
                return ClosingIterator$.MODULE$.asClosingIterator((IterableOnce)(this.returnOneShortestPathOnly() ? shortestPaths.take(1) : shortestPaths));
            }
            return ClosingIterator$.MODULE$.empty();
        });
        return output.closing((AutoCloseable)traversalCursor).closing((AutoCloseable)nodeCursor).closing((AutoCloseable)biDirectionalBFS);
    }

    public ShortestPathSlottedPipe copy(Pipe source, Slot sourceSlot, Slot targetSlot, int pathOffset, int relsOffset, RelationshipTypes types, SemanticDirection dir, TraversalPredicates predicates, Seq<Predicate> pathPredicates, boolean returnOneShortestPathOnly, FindShortestPaths.SameNodeMode sameNodeMode, boolean allowZeroLength, Option<Object> maxDepth, boolean needOnlyOnePath, SlotConfiguration slots, int id) {
        return new ShortestPathSlottedPipe(source, sourceSlot, targetSlot, pathOffset, relsOffset, types, dir, predicates, pathPredicates, returnOneShortestPathOnly, sameNodeMode, allowZeroLength, maxDepth, needOnlyOnePath, slots, id);
    }

    public Pipe copy$default$1() {
        return this.source();
    }

    public boolean copy$default$10() {
        return this.returnOneShortestPathOnly();
    }

    public FindShortestPaths.SameNodeMode copy$default$11() {
        return this.sameNodeMode();
    }

    public boolean copy$default$12() {
        return this.allowZeroLength();
    }

    public Option<Object> copy$default$13() {
        return this.maxDepth();
    }

    public boolean copy$default$14() {
        return this.needOnlyOnePath();
    }

    public SlotConfiguration copy$default$15() {
        return this.slots();
    }

    public Slot copy$default$2() {
        return this.sourceSlot();
    }

    public Slot copy$default$3() {
        return this.targetSlot();
    }

    public int copy$default$4() {
        return this.pathOffset();
    }

    public int copy$default$5() {
        return this.relsOffset();
    }

    public RelationshipTypes copy$default$6() {
        return this.types();
    }

    public SemanticDirection copy$default$7() {
        return this.dir();
    }

    public TraversalPredicates copy$default$8() {
        return this.predicates();
    }

    public Seq<Predicate> copy$default$9() {
        return this.pathPredicates();
    }

    public String productPrefix() {
        return "ShortestPathSlottedPipe";
    }

    public int productArity() {
        return 15;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.source();
            }
            case 1: {
                return this.sourceSlot();
            }
            case 2: {
                return this.targetSlot();
            }
            case 3: {
                return BoxesRunTime.boxToInteger((int)this.pathOffset());
            }
            case 4: {
                return BoxesRunTime.boxToInteger((int)this.relsOffset());
            }
            case 5: {
                return this.types();
            }
            case 6: {
                return this.dir();
            }
            case 7: {
                return this.predicates();
            }
            case 8: {
                return this.pathPredicates();
            }
            case 9: {
                return BoxesRunTime.boxToBoolean((boolean)this.returnOneShortestPathOnly());
            }
            case 10: {
                return this.sameNodeMode();
            }
            case 11: {
                return BoxesRunTime.boxToBoolean((boolean)this.allowZeroLength());
            }
            case 12: {
                return this.maxDepth();
            }
            case 13: {
                return BoxesRunTime.boxToBoolean((boolean)this.needOnlyOnePath());
            }
            case 14: {
                return this.slots();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ShortestPathSlottedPipe;
    }

    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "source";
            }
            case 1: {
                return "sourceSlot";
            }
            case 2: {
                return "targetSlot";
            }
            case 3: {
                return "pathOffset";
            }
            case 4: {
                return "relsOffset";
            }
            case 5: {
                return "types";
            }
            case 6: {
                return "dir";
            }
            case 7: {
                return "predicates";
            }
            case 8: {
                return "pathPredicates";
            }
            case 9: {
                return "returnOneShortestPathOnly";
            }
            case 10: {
                return "sameNodeMode";
            }
            case 11: {
                return "allowZeroLength";
            }
            case 12: {
                return "maxDepth";
            }
            case 13: {
                return "needOnlyOnePath";
            }
            case 14: {
                return "slots";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.source()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.sourceSlot()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.targetSlot()));
        n = Statics.mix((int)n, (int)this.pathOffset());
        n = Statics.mix((int)n, (int)this.relsOffset());
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.types()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.dir()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.predicates()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.pathPredicates()));
        n = Statics.mix((int)n, (int)(this.returnOneShortestPathOnly() ? 1231 : 1237));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.sameNodeMode()));
        n = Statics.mix((int)n, (int)(this.allowZeroLength() ? 1231 : 1237));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.maxDepth()));
        n = Statics.mix((int)n, (int)(this.needOnlyOnePath() ? 1231 : 1237));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.slots()));
        return Statics.finalizeHash((int)n, (int)15);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ShortestPathSlottedPipe)) return false;
        boolean bl = true;
        if (!bl) return false;
        ShortestPathSlottedPipe shortestPathSlottedPipe = (ShortestPathSlottedPipe)x$1;
        if (this.pathOffset() != shortestPathSlottedPipe.pathOffset()) return false;
        if (this.relsOffset() != shortestPathSlottedPipe.relsOffset()) return false;
        if (this.returnOneShortestPathOnly() != shortestPathSlottedPipe.returnOneShortestPathOnly()) return false;
        if (this.allowZeroLength() != shortestPathSlottedPipe.allowZeroLength()) return false;
        if (this.needOnlyOnePath() != shortestPathSlottedPipe.needOnlyOnePath()) return false;
        Pipe pipe = this.source();
        Pipe pipe2 = shortestPathSlottedPipe.source();
        if (pipe == null) {
            if (pipe2 != null) {
                return false;
            }
        } else if (!pipe.equals(pipe2)) return false;
        Slot slot = this.sourceSlot();
        Slot slot2 = shortestPathSlottedPipe.sourceSlot();
        if (slot == null) {
            if (slot2 != null) {
                return false;
            }
        } else if (!slot.equals(slot2)) return false;
        Slot slot3 = this.targetSlot();
        Slot slot4 = shortestPathSlottedPipe.targetSlot();
        if (slot3 == null) {
            if (slot4 != null) {
                return false;
            }
        } else if (!slot3.equals(slot4)) return false;
        RelationshipTypes relationshipTypes = this.types();
        RelationshipTypes relationshipTypes2 = shortestPathSlottedPipe.types();
        if (relationshipTypes == null) {
            if (relationshipTypes2 != null) {
                return false;
            }
        } else if (!relationshipTypes.equals(relationshipTypes2)) return false;
        SemanticDirection semanticDirection = this.dir();
        SemanticDirection semanticDirection2 = shortestPathSlottedPipe.dir();
        if (semanticDirection == null) {
            if (semanticDirection2 != null) {
                return false;
            }
        } else if (!semanticDirection.equals(semanticDirection2)) return false;
        TraversalPredicates traversalPredicates = this.predicates();
        TraversalPredicates traversalPredicates2 = shortestPathSlottedPipe.predicates();
        if (traversalPredicates == null) {
            if (traversalPredicates2 != null) {
                return false;
            }
        } else if (!traversalPredicates.equals(traversalPredicates2)) return false;
        Seq<Predicate> seq = this.pathPredicates();
        Seq<Predicate> seq2 = shortestPathSlottedPipe.pathPredicates();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        FindShortestPaths.SameNodeMode sameNodeMode = this.sameNodeMode();
        FindShortestPaths.SameNodeMode sameNodeMode2 = shortestPathSlottedPipe.sameNodeMode();
        if (sameNodeMode == null) {
            if (sameNodeMode2 != null) {
                return false;
            }
        } else if (!sameNodeMode.equals(sameNodeMode2)) return false;
        Option<Object> option = this.maxDepth();
        Option<Object> option2 = shortestPathSlottedPipe.maxDepth();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        SlotConfiguration slotConfiguration = this.slots();
        SlotConfiguration slotConfiguration2 = shortestPathSlottedPipe.slots();
        if (slotConfiguration == null) {
            if (slotConfiguration2 != null) {
                return false;
            }
        } else if (!slotConfiguration.equals(slotConfiguration2)) return false;
        if (!shortestPathSlottedPipe.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ RelationshipReference $anonfun$internalCreateResults$5(long x$1) {
        return VirtualValues.relationship((long)x$1);
    }

    public ShortestPathSlottedPipe(Pipe source, Slot sourceSlot, Slot targetSlot, int pathOffset, int relsOffset, RelationshipTypes types, SemanticDirection dir, TraversalPredicates predicates, Seq<Predicate> pathPredicates, boolean returnOneShortestPathOnly, FindShortestPaths.SameNodeMode sameNodeMode, boolean allowZeroLength, Option<Object> maxDepth, boolean needOnlyOnePath, SlotConfiguration slots, int id) {
        this.source = source;
        this.sourceSlot = sourceSlot;
        this.targetSlot = targetSlot;
        this.pathOffset = pathOffset;
        this.relsOffset = relsOffset;
        this.types = types;
        this.dir = dir;
        this.predicates = predicates;
        this.pathPredicates = pathPredicates;
        this.returnOneShortestPathOnly = returnOneShortestPathOnly;
        this.sameNodeMode = sameNodeMode;
        this.allowZeroLength = allowZeroLength;
        this.maxDepth = maxDepth;
        this.needOnlyOnePath = needOnlyOnePath;
        this.slots = slots;
        this.id = id;
        super(source);
        Product.$init$((Product)this);
        this.getSourceNodeFunction = SlotConfigurationUtils$.MODULE$.makeGetPrimitiveNodeFromSlotFunctionFor(sourceSlot, false);
        this.getTargetNodeFunction = SlotConfigurationUtils$.MODULE$.makeGetPrimitiveNodeFromSlotFunctionFor(targetSlot, false);
    }
}

