/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.RemovalListener;
import java.io.Serializable;
import java.util.Map;
import org.neo4j.cypher.internal.CacheabilityInfo;
import org.neo4j.cypher.internal.CompilerWithExpressionCodeGenOption;
import org.neo4j.cypher.internal.ExecutableQuery;
import org.neo4j.cypher.internal.ExecutingQueryTracer;
import org.neo4j.cypher.internal.NotStale$;
import org.neo4j.cypher.internal.PlanStalenessCaller;
import org.neo4j.cypher.internal.QueryCache$;
import org.neo4j.cypher.internal.Stale;
import org.neo4j.cypher.internal.Staleness;
import org.neo4j.cypher.internal.cache.CacheSize;
import org.neo4j.cypher.internal.cache.CacheTracer;
import org.neo4j.cypher.internal.cache.CaffeineCacheFactory;
import org.neo4j.cypher.internal.compiler.MissingLabelNotification;
import org.neo4j.cypher.internal.compiler.MissingPropertyNameNotification;
import org.neo4j.cypher.internal.compiler.MissingRelTypeNotification;
import org.neo4j.cypher.internal.options.CypherReplanOption;
import org.neo4j.cypher.internal.util.InternalNotification;
import org.neo4j.cypher.internal.util.symbols.ParameterTypeInfo;
import org.neo4j.kernel.api.query.ExecutingQuery;
import org.neo4j.kernel.impl.query.TransactionalContext;
import org.neo4j.values.virtual.MapValue;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0005\u0011mc\u0001\u0002/^\u0001\u0019D\u0001B\u001c\u0001\u0003\u0006\u0004%\ta\u001c\u0005\tm\u0002\u0011\t\u0011)A\u0005a\"Aq\u000f\u0001BC\u0002\u0013\u0005\u0001\u0010\u0003\u0005}\u0001\t\u0005\t\u0015!\u0003z\u0011!i\bA!b\u0001\n\u0003q\b\"CA\u000f\u0001\t\u0005\t\u0015!\u0003\u0000\u0011)\ty\u0002\u0001BC\u0002\u0013\u0005\u0011\u0011\u0005\u0005\u000b\u0003c\u0001!\u0011!Q\u0001\n\u0005\r\u0002BCA\u001a\u0001\t\u0015\r\u0011\"\u0001\u00026!Q\u0011Q\b\u0001\u0003\u0002\u0003\u0006I!a\u000e\t\u000f\u0005}\u0002\u0001\"\u0001\u0002B!I\u0011q\n\u0001C\u0002\u0013\u0005\u0011\u0011\u000b\u0005\t\u0003\u001b\u0004\u0001\u0015!\u0003\u0002T!I\u0011q\u001a\u0001C\u0002\u0013%\u0011\u0011\u001b\u0005\t\u00033\u0004\u0001\u0015!\u0003\u0002T\"9\u00111\u001c\u0001\u0005\u0012\u0005u\u0007bBAv\u0001\u0011\u0005\u0011Q\u001e\u0004\u0007\u0003c\u0002\u0001!a\u001d\t\u0015\u0005U$C!b\u0001\n\u0003\t9\b\u0003\u0006\u0002zI\u0011\t\u0011)A\u0005\u0003\u000fA!\"a\u001f\u0013\u0005\u000b\u0007I\u0011AA?\u0011)\t)I\u0005B\u0001B\u0003%\u0011q\u0010\u0005\b\u0003\u007f\u0011B\u0011AAD\u0011%\tiI\u0005a\u0001\n\u0013\ty\tC\u0005\u0002\u0018J\u0001\r\u0011\"\u0003\u0002\u001a\"A\u0011Q\u0015\n!B\u0013\t\t\nC\u0004\u00020J!\t!!-\t\u000f\u0005M&\u0003\"\u0001\u0002\u0010\"9\u0011Q\u0017\n\u0005\u0002\u0005]\u0006bBAb%\u0011\u0005\u0013Q\u0019\u0005\b\u0003\u0013\u0014B\u0011IAf\u0011\u001d\t)\u0010\u0001C\u0001\u0003oD\u0011B!\u0013\u0001#\u0003%\tAa\u0013\t\u000f\t\u0005\u0004\u0001\"\u0003\u0003d!9!1\u000e\u0001\u0005\n\t5\u0004b\u0002BA\u0001\u0011%!1\u0011\u0005\b\u0005?\u0003A\u0011\u0002BQ\u0011%\u0011y\u000bAI\u0001\n\u0013\u0011\t\fC\u0004\u00036\u0002!IAa.\t\u0013\t\r\u0007!%A\u0005\n\tE\u0006b\u0002Bc\u0001\u0011%!q\u0019\u0005\b\u00057\u0004A\u0011\u0002Bo\u0011\u001d\u0011I\u000f\u0001C\u0005\u0005WDqAa>\u0001\t\u0003\tioB\u0004\u0003zvC\tAa?\u0007\rqk\u0006\u0012\u0001B\u007f\u0011\u001d\tyD\fC\u0001\u0005\u007f4aa!\u0001/\u0005\u000e\r\u0001BCB\u0010a\tU\r\u0011\"\u0001\u0004\"!Q11\u0006\u0019\u0003\u0012\u0003\u0006Iaa\t\t\u0015\r5\u0002G!f\u0001\n\u0003\u0019y\u0003\u0003\u0006\u0004lA\u0012\t\u0012)A\u0005\u0007cA!b!\u001c1\u0005+\u0007I\u0011AA?\u0011)\u0019y\u0007\rB\tB\u0003%\u0011q\u0010\u0005\b\u0003\u007f\u0001D\u0011AB9\u0011%\u0019Y\bMA\u0001\n\u0003\u0019i\bC\u0005\u0004\u000eB\n\n\u0011\"\u0001\u0004\u0010\"I1q\u0013\u0019\u0012\u0002\u0013\u00051\u0011\u0014\u0005\n\u0007C\u0003\u0014\u0013!C\u0001\u0007GC\u0011ba*1\u0003\u0003%\te!+\t\u0013\rU\u0006'!A\u0005\u0002\u0005=\u0005\"CB\\a\u0005\u0005I\u0011AB]\u0011%\u0019i\fMA\u0001\n\u0003\u001ay\fC\u0005\u00026B\n\t\u0011\"\u0001\u0004N\"I1\u0011\u001b\u0019\u0002\u0002\u0013\u000531\u001b\u0005\n\u0003\u0013\u0004\u0014\u0011!C!\u0003\u0017D\u0011ba\u001a1\u0003\u0003%\tea6\t\u0013\u0005\r\u0007'!A\u0005B\rew!CBo]\u0005\u0005\t\u0012ABp\r%\u0019\tALA\u0001\u0012\u0003\u0019\t\u000fC\u0004\u0002@\u0019#\ta!<\t\u0013\r\u001dd)!A\u0005F\r]\u0007\"CBx\r\u0006\u0005I\u0011QBy\u0011%!\tARA\u0001\n\u0003#\u0019\u0001C\u0005\u0005\u001e\u0019\u000b\t\u0011\"\u0003\u0005 !IAq\u0005\u0018C\u0002\u0013\u0005A\u0011\u0006\u0005\t\tcq\u0003\u0015!\u0003\u0005,\u001911Q\u0007\u0018\u0001\u0007oA!b!\u000fO\u0005\u000b\u0007I\u0011BB\u001e\u0011)\u00199F\u0014B\u0001B\u0003%1Q\b\u0005\u000b\u00073r%\u0011!Q\u0001\n\u0005E\u0005\u0002CA \u001d\u0012\u0005afa\u0017\t\u000f\u0005%g\n\"\u0011\u0002L\"9\u00111\u0019(\u0005B\r\u0005\u0004bBB4\u001d\u0012\u00053\u0011N\u0004\b\tgq\u0003\u0012\u0001C\u001b\r\u001d\u0019)D\fE\u0001\toAq!a\u0010X\t\u0003!I\u0004C\u0005\u0005<]\u0013\r\u0011\"\u0002\u00040!AAQH,!\u0002\u001b\u0019\t\u0004C\u0004\u0005@9\"\t\u0001\"\u0011\u0003\u0015E+XM]=DC\u000eDWM\u0003\u0002_?\u0006A\u0011N\u001c;fe:\fGN\u0003\u0002aC\u000611-\u001f9iKJT!AY2\u0002\u000b9,w\u000e\u000e6\u000b\u0003\u0011\f1a\u001c:h\u0007\u0001)RaZA\u0016\u0003\u0017\u0019\"\u0001\u00015\u0011\u0005%dW\"\u00016\u000b\u0003-\fQa]2bY\u0006L!!\u001c6\u0003\r\u0005s\u0017PU3g\u00031\u0019\u0017m\u00195f\r\u0006\u001cGo\u001c:z+\u0005\u0001\bCA9u\u001b\u0005\u0011(BA:^\u0003\u0015\u0019\u0017m\u00195f\u0013\t)(O\u0001\u000bDC\u001a4W-\u001b8f\u0007\u0006\u001c\u0007.\u001a$bGR|'/_\u0001\u000eG\u0006\u001c\u0007.\u001a$bGR|'/\u001f\u0011\u0002\u00175\f\u00070[7v[NK'0Z\u000b\u0002sB\u0011\u0011O_\u0005\u0003wJ\u0014\u0011bQ1dQ\u0016\u001c\u0016N_3\u0002\u00195\f\u00070[7v[NK'0\u001a\u0011\u0002\u001fM$\u0018\r\\3oKN\u001c8)\u00197mKJ,\u0012a \t\u0007\u0003\u0003\t\u0019!a\u0002\u000e\u0003uK1!!\u0002^\u0005M\u0001F.\u00198Ti\u0006dWM\\3tg\u000e\u000bG\u000e\\3s!\u0011\tI!a\u0003\r\u0001\u00119\u0011Q\u0002\u0001C\u0002\u0005=!\u0001E#Y\u000b\u000e+F+\u0011\"M\u000b~\u000bV+\u0012*Z#\u0011\t\t\"a\u0006\u0011\u0007%\f\u0019\"C\u0002\u0002\u0016)\u0014qAT8uQ&tw\r\u0005\u0003\u0002\u0002\u0005e\u0011bAA\u000e;\n\u00012)Y2iK\u0006\u0014\u0017\u000e\\5us&sgm\\\u0001\u0011gR\fG.\u001a8fgN\u001c\u0015\r\u001c7fe\u0002\na\u0001\u001e:bG\u0016\u0014XCAA\u0012!\u0015\t\u0018QEA\u0015\u0013\r\t9C\u001d\u0002\f\u0007\u0006\u001c\u0007.\u001a+sC\u000e,'\u000f\u0005\u0003\u0002\n\u0005-BaBA\u0017\u0001\t\u0007\u0011q\u0006\u0002\n#V+%+W0L\u000bf\u000b2!!\u0005i\u0003\u001d!(/Y2fe\u0002\nA#\u001a=fGV$\u0018N\\4Rk\u0016\u0014\u0018\u0010\u0016:bG\u0016\u0014XCAA\u001c!\u0011\t\t!!\u000f\n\u0007\u0005mRL\u0001\u000bFq\u0016\u001cW\u000f^5oOF+XM]=Ue\u0006\u001cWM]\u0001\u0016Kb,7-\u001e;j]\u001e\fV/\u001a:z)J\f7-\u001a:!\u0003\u0019a\u0014N\\5u}Qa\u00111IA#\u0003\u000f\nI%a\u0013\u0002NA9\u0011\u0011\u0001\u0001\u0002*\u0005\u001d\u0001\"\u00028\f\u0001\u0004\u0001\b\"B<\f\u0001\u0004I\b\"B?\f\u0001\u0004y\bbBA\u0010\u0017\u0001\u0007\u00111\u0005\u0005\b\u0003gY\u0001\u0019AA\u001c\u0003=\u0011X-\\8wC2d\u0015n\u001d;f]\u0016\u0014XCAA*!!\t)&!\u001b\u0002*\u00055TBAA,\u0015\r\u0019\u0018\u0011\f\u0006\u0005\u00037\ni&\u0001\u0005dC\u001a4W-\u001b8f\u0015\u0011\ty&!\u0019\u0002\u0011\t,g.\\1oKNTA!a\u0019\u0002f\u00051q-\u001b;ik\nT!!a\u001a\u0002\u0007\r|W.\u0003\u0003\u0002l\u0005]#a\u0004*f[>4\u0018\r\u001c'jgR,g.\u001a:\u0011\u0007\u0005=$#D\u0001\u0001\u0005-\u0019\u0015m\u00195fIZ\u000bG.^3\u0014\u0005IA\u0017!\u0002<bYV,WCAA\u0004\u0003\u00191\u0018\r\\;fA\u0005y\"/Z2p[BLG.\u001a3XSRDW\t\u001f9sKN\u001c\u0018n\u001c8D_\u0012,w)\u001a8\u0016\u0005\u0005}\u0004cA5\u0002\u0002&\u0019\u00111\u00116\u0003\u000f\t{w\u000e\\3b]\u0006\u0001#/Z2p[BLG.\u001a3XSRDW\t\u001f9sKN\u001c\u0018n\u001c8D_\u0012,w)\u001a8!)\u0019\ti'!#\u0002\f\"9\u0011QO\fA\u0002\u0005\u001d\u0001bBA>/\u0001\u0007\u0011qP\u0001\u000e?:,XNY3s\u001f\u001aD\u0015\u000e^:\u0016\u0005\u0005E\u0005cA5\u0002\u0014&\u0019\u0011Q\u00136\u0003\u0007%sG/A\t`]Vl'-\u001a:PM\"KGo]0%KF$B!a'\u0002\"B\u0019\u0011.!(\n\u0007\u0005}%N\u0001\u0003V]&$\b\"CAR3\u0005\u0005\t\u0019AAI\u0003\rAH%M\u0001\u000f?:,XNY3s\u001f\u001aD\u0015\u000e^:!Q\rQ\u0012\u0011\u0016\t\u0004S\u0006-\u0016bAAWU\nAao\u001c7bi&dW-A\u0004nCJ\\\u0007*\u001b;\u0015\u0005\u0005m\u0015\u0001\u00048v[\n,'o\u00144ISR\u001c\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005}\u0014\u0011\u0018\u0005\b\u0003wk\u0002\u0019AA_\u0003\u0015yG\u000f[3s!\rI\u0017qX\u0005\u0004\u0003\u0003T'aA!os\u00061Q-];bYN$B!a \u0002H\"9\u00111\u0018\u0010A\u0002\u0005u\u0016\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u0005E\u0015\u0001\u0005:f[>4\u0018\r\u001c'jgR,g.\u001a:!\u0003\u0015IgN\\3s+\t\t\u0019\u000e\u0005\u0005\u0002V\u0005U\u0017\u0011FA7\u0013\u0011\t9.a\u0016\u0003\u000b\r\u000b7\r[3\u0002\r%tg.\u001a:!\u0003-\u0019'/Z1uK&sg.\u001a:\u0015\u0011\u0005M\u0017q\\Ar\u0003ODa!!9\u0011\u0001\u0004\u0001\u0018\u0001D5o]\u0016\u0014h)Y2u_JL\bBBAs!\u0001\u0007\u00110\u0001\u0003tSj,\u0007bBAu!\u0001\u0007\u00111K\u0001\tY&\u001cH/\u001a8fe\u0006iQm\u001d;j[\u0006$X\rZ*ju\u0016$\"!a<\u0011\u0007%\f\t0C\u0002\u0002t*\u0014A\u0001T8oO\u000612m\\7qkR,\u0017JZ!cg\u0016tGo\u0014:Ti\u0006dW\r\u0006\u0007\u0002\b\u0005e\u0018Q B\u000b\u0005?\u0011y\u0003C\u0004\u0002|\u0002\u0002\r!!\u000b\u0002\u0011E,XM]=LKfDq!a@!\u0001\u0004\u0011\t!\u0001\u0002uGB!!1\u0001B\t\u001b\t\u0011)A\u0003\u0003\u0003\b\t%\u0011!B9vKJL(\u0002\u0002B\u0006\u0005\u001b\tA![7qY*\u0019!qB1\u0002\r-,'O\\3m\u0013\u0011\u0011\u0019B!\u0002\u0003)Q\u0013\u0018M\\:bGRLwN\\1m\u0007>tG/\u001a=u\u0011\u001d\u00119\u0002\ta\u0001\u00053\t\u0001bY8na&dWM\u001d\t\u0007\u0003\u0003\u0011Y\"a\u0002\n\u0007\tuQLA\u0012D_6\u0004\u0018\u000e\\3s/&$\b.\u0012=qe\u0016\u001c8/[8o\u0007>$WmR3o\u001fB$\u0018n\u001c8\t\u000f\t\u0005\u0002\u00051\u0001\u0003$\u0005q!/\u001a9mC:\u001cFO]1uK\u001eL\b\u0003\u0002B\u0013\u0005Wi!Aa\n\u000b\u0007\t%R,A\u0004paRLwN\\:\n\t\t5\"q\u0005\u0002\u0013\u0007f\u0004\b.\u001a:SKBd\u0017M\\(qi&|g\u000eC\u0005\u00032\u0001\u0002\n\u00111\u0001\u00034\u0005AQ.\u001a;b\t\u0006$\u0018\r\u0005\u0003\u00036\t\rc\u0002\u0002B\u001c\u0005\u007f\u00012A!\u000fk\u001b\t\u0011YDC\u0002\u0003>\u0015\fa\u0001\u0010:p_Rt\u0014b\u0001B!U\u00061\u0001K]3eK\u001aLAA!\u0012\u0003H\t11\u000b\u001e:j]\u001eT1A!\u0011k\u0003\u0001\u001aw.\u001c9vi\u0016Le-\u00112tK:$xJ]*uC2,G\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\t5#\u0006\u0002B\u001a\u0005\u001fZ#A!\u0015\u0011\t\tM#QL\u0007\u0003\u0005+RAAa\u0016\u0003Z\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u00057R\u0017AC1o]>$\u0018\r^5p]&!!q\fB+\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u001cS:4\u0018\r\\5e\u001d>$\u0018NZ5dCRLwN\\#ySN$\u0018N\\4\u0015\r\u0005}$Q\rB5\u0011\u001d\u00119G\ta\u0001\u0003[\n1bY1dQ\u0016$g+\u00197vK\"9\u0011q \u0012A\u0002\t\u0005\u0011!F5t\u0013:4\u0018\r\\5e\u001d>$\u0018NZ5dCRLwN\u001c\u000b\u0007\u0003\u007f\u0012yGa \t\u000f\tE4\u00051\u0001\u0003t\u0005aan\u001c;jM&\u001c\u0017\r^5p]B!!Q\u000fB>\u001b\t\u00119HC\u0002\u0003zu\u000bA!\u001e;jY&!!Q\u0010B<\u0005QIe\u000e^3s]\u0006dgj\u001c;jM&\u001c\u0017\r^5p]\"9\u0011q`\u0012A\u0002\t\u0005\u0011A\u0004:fG>l\u0007/\u001b7f\u001fJ<U\r\u001e\u000b\r\u0003\u000f\u0011)Ia&\u0003\u001a\nm%Q\u0014\u0005\b\u0005\u000f#\u0003\u0019\u0001BE\u00039)\u00070Z2vi&tw-U;fef\u0004BAa#\u0003\u00146\u0011!Q\u0012\u0006\u0005\u0005\u000f\u0011yI\u0003\u0003\u0003\u0012\n5\u0011aA1qS&!!Q\u0013BG\u00059)\u00050Z2vi&tw-U;fefDqAa\u001a%\u0001\u0004\ti\u0007C\u0004\u0003\u0018\u0011\u0002\rA!\u0007\t\u000f\u0005mH\u00051\u0001\u0002*!9!\u0011\u0007\u0013A\u0002\tM\u0012aD2p[BLG.Z!oI\u000e\u000b7\r[3\u0015\u0019\u0005\u001d!1\u0015BS\u0005O\u0013IKa+\t\u000f\t\u001dU\u00051\u0001\u0003\n\"9\u00111`\u0013A\u0002\u0005%\u0002b\u0002B\fK\u0001\u0007!\u0011\u0004\u0005\b\u0005c)\u0003\u0019\u0001B\u001a\u0011%\u0011i+\nI\u0001\u0002\u0004\ty(\u0001\u0005iSR\u001c\u0015m\u00195f\u0003e\u0019w.\u001c9jY\u0016\fe\u000eZ\"bG\",G\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\tM&\u0006BA@\u0005\u001f\nAeY8na&dWmV5uQ\u0016C\bO]3tg&|gnQ8eK\u001e+g.\u00118e\u0007\u0006\u001c\u0007.\u001a\u000b\r\u0003\u000f\u0011ILa/\u0003>\n}&\u0011\u0019\u0005\b\u0005\u000f;\u0003\u0019\u0001BE\u0011\u001d\tYp\na\u0001\u0003SAqAa\u0006(\u0001\u0004\u0011I\u0002C\u0004\u00032\u001d\u0002\rAa\r\t\u0013\t5v\u0005%AA\u0002\u0005}\u0014AL2p[BLG.Z,ji\",\u0005\u0010\u001d:fgNLwN\\\"pI\u0016<UM\\!oI\u000e\u000b7\r[3%I\u00164\u0017-\u001e7uIU\nQfY8na&dWm\u0014:D_6\u0004\u0018\u000e\\3XSRDW\t\u001f9sKN\u001c\u0018n\u001c8D_\u0012,w)\u001a8B]\u0012\u001c\u0015m\u00195f)1\t9A!3\u0003L\n5'q\u001bBm\u0011\u001d\u00119)\u000ba\u0001\u0005\u0013Cq!a?*\u0001\u0004\tI\u0003C\u0004\u0003P&\u0002\rA!5\u0002\u000f\r|W\u000e]5mKB)\u0011Na5\u0002\b%\u0019!Q\u001b6\u0003\u0013\u0019+hn\u0019;j_:\u0004\u0004b\u0002B\u0019S\u0001\u0007!1\u0007\u0005\b\u0005[K\u0003\u0019AA@\u0003\rA\u0017\u000e\u001e\u000b\u000b\u0003\u000f\u0011yN!9\u0003d\n\u001d\bb\u0002BDU\u0001\u0007!\u0011\u0012\u0005\b\u0003wT\u0003\u0019AA\u0015\u0011\u001d\u0011)O\u000ba\u0001\u0003[\nq\"\u001a=fGV$\u0018M\u00197f#V,'/\u001f\u0005\b\u0005cQ\u0003\u0019\u0001B\u001a\u0003\u0011i\u0017n]:\u0015\u0015\u0005\u001d!Q\u001eBx\u0005c\u0014)\u0010C\u0004\u0003\b.\u0002\rA!#\t\u000f\u0005m8\u00061\u0001\u0002*!9!1_\u0016A\u0002\u0005\u001d\u0011A\u00058fo\u0016CXmY;uC\ndW-U;fefDqA!\r,\u0001\u0004\u0011\u0019$A\u0003dY\u0016\f'/\u0001\u0006Rk\u0016\u0014\u0018pQ1dQ\u0016\u00042!!\u0001/'\tq\u0003\u000e\u0006\u0002\u0003|\nA1)Y2iK.+\u00170\u0006\u0003\u0004\u0006\r\u00152C\u0002\u0019i\u0007\u000f\u0019i\u0001E\u0002j\u0007\u0013I1aa\u0003k\u0005\u001d\u0001&o\u001c3vGR\u0004Baa\u0004\u0004\u001a9!1\u0011CB\u000b\u001d\u0011\u0011Ida\u0005\n\u0003-L1aa\u0006k\u0003\u001d\u0001\u0018mY6bO\u0016LAaa\u0007\u0004\u001e\ta1+\u001a:jC2L'0\u00192mK*\u00191q\u00036\u0002\u0011E,XM]=SKB,\"aa\t\u0011\t\u0005%1Q\u0005\u0003\b\u0007O\u0001$\u0019AB\u0015\u0005%\tV+\u0012*Z?J+\u0005+\u0005\u0003\u0002\u0012\u0005u\u0016!C9vKJL(+\u001a9!\u0003A\u0001\u0018M]1nKR,'\u000fV=qK6\u000b\u0007/\u0006\u0002\u00042A\u001911\u0007(\u000e\u00039\u0012\u0001\u0003U1sC6,G/\u001a:UsB,W*\u00199\u0014\u00059C\u0017!\u0003:fgVdG/T1q+\t\u0019i\u0004\u0005\u0005\u0004@\r\u001d#1GB&\u001b\t\u0019\tE\u0003\u0003\u0003z\r\r#BAB#\u0003\u0011Q\u0017M^1\n\t\r%3\u0011\t\u0002\u0004\u001b\u0006\u0004\b\u0003BB'\u0007'j!aa\u0014\u000b\t\rE#qO\u0001\bgfl'm\u001c7t\u0013\u0011\u0019)fa\u0014\u0003#A\u000b'/Y7fi\u0016\u0014H+\u001f9f\u0013:4w.\u0001\u0006sKN,H\u000e^'ba\u0002\n\u0011b\u00185bg\"\u001cu\u000eZ3\u0015\r\rE2QLB0\u0011\u001d\u0019ID\u0015a\u0001\u0007{Aqa!\u0017S\u0001\u0004\t\t\n\u0006\u0003\u0002\u0000\r\r\u0004bBB3)\u0002\u0007\u0011QX\u0001\u0004_\nT\u0017\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\tM\u0012!\u00059be\u0006lW\r^3s)f\u0004X-T1qA\u0005\tB\u000f_*uCR,\u0007*Y:DQ\u0006tw-Z:\u0002%QD8\u000b^1uK\"\u000b7o\u00115b]\u001e,7\u000f\t\u000b\t\u0007g\u001a)ha\u001e\u0004zA)11\u0007\u0019\u0004$!91qD\u001cA\u0002\r\r\u0002bBB\u0017o\u0001\u00071\u0011\u0007\u0005\b\u0007[:\u0004\u0019AA@\u0003\u0011\u0019w\u000e]=\u0016\t\r}4Q\u0011\u000b\t\u0007\u0003\u001b9i!#\u0004\fB)11\u0007\u0019\u0004\u0004B!\u0011\u0011BBC\t\u001d\u00199\u0003\u000fb\u0001\u0007SA\u0011ba\b9!\u0003\u0005\raa!\t\u0013\r5\u0002\b%AA\u0002\rE\u0002\"CB7qA\u0005\t\u0019AA@\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*Ba!%\u0004\u0016V\u001111\u0013\u0016\u0005\u0007G\u0011y\u0005B\u0004\u0004(e\u0012\ra!\u000b\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU!11TBP+\t\u0019iJ\u000b\u0003\u00042\t=CaBB\u0014u\t\u00071\u0011F\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134+\u0011\u0011\tl!*\u0005\u000f\r\u001d2H1\u0001\u0004*\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"aa+\u0011\t\r561W\u0007\u0003\u0007_SAa!-\u0004D\u0005!A.\u00198h\u0013\u0011\u0011)ea,\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011QXB^\u0011%\t\u0019KPA\u0001\u0002\u0004\t\t*A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0019\t\r\u0005\u0004\u0004D\u000e%\u0017QX\u0007\u0003\u0007\u000bT1aa2k\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0007\u0017\u001c)M\u0001\u0005Ji\u0016\u0014\u0018\r^8s)\u0011\tyha4\t\u0013\u0005\r\u0006)!AA\u0002\u0005u\u0016A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$Baa+\u0004V\"I\u00111U!\u0002\u0002\u0003\u0007\u0011\u0011\u0013\u000b\u0003\u0007W#B!a \u0004\\\"I\u00111\u0015#\u0002\u0002\u0003\u0007\u0011QX\u0001\t\u0007\u0006\u001c\u0007.Z&fsB\u001911\u0007$\u0014\t\u0019C71\u001d\t\u0005\u0007K\u001cY/\u0004\u0002\u0004h*!1\u0011^B\"\u0003\tIw.\u0003\u0003\u0004\u001c\r\u001dHCABp\u0003\u0015\t\u0007\u000f\u001d7z+\u0011\u0019\u0019p!?\u0015\u0011\rU81`B\u007f\u0007\u007f\u0004Raa\r1\u0007o\u0004B!!\u0003\u0004z\u001291qE%C\u0002\r%\u0002bBB\u0010\u0013\u0002\u00071q\u001f\u0005\b\u0007[I\u0005\u0019AB\u0019\u0011\u001d\u0019i'\u0013a\u0001\u0003\u007f\nq!\u001e8baBd\u00170\u0006\u0003\u0005\u0006\u0011UA\u0003\u0002C\u0004\t/\u0001R!\u001bC\u0005\t\u001bI1\u0001b\u0003k\u0005\u0019y\u0005\u000f^5p]BI\u0011\u000eb\u0004\u0005\u0014\rE\u0012qP\u0005\u0004\t#Q'A\u0002+va2,7\u0007\u0005\u0003\u0002\n\u0011UAaBB\u0014\u0015\n\u00071\u0011\u0006\u0005\n\t3Q\u0015\u0011!a\u0001\t7\t1\u0001\u001f\u00131!\u0015\u0019\u0019\u0004\rC\n\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t!\t\u0003\u0005\u0003\u0004.\u0012\r\u0012\u0002\u0002C\u0013\u0007_\u0013aa\u00142kK\u000e$\u0018a\u0003(P)~\u0003&+R*F\u001dR+\"\u0001b\u000b\u0011\t\u0005\u0005AQF\u0005\u0004\t_i&aD#yK\u000e,H/\u00192mKF+XM]=\u0002\u00199{Ek\u0018)S\u000bN+e\n\u0016\u0011\u0002!A\u000b'/Y7fi\u0016\u0014H+\u001f9f\u001b\u0006\u0004\bcAB\u001a/N\u0011q\u000b\u001b\u000b\u0003\tk\tQ!Z7qif\fa!Z7qif\u0004\u0013aF3yiJ\f7\r\u001e)be\u0006lW\r^3s)f\u0004X-T1q)\u0019\u0019\t\u0004b\u0011\u0005X!9AQI.A\u0002\u0011\u001d\u0013\u0001C7baZ\u000bG.^3\u0011\t\u0011%C1K\u0007\u0003\t\u0017RA\u0001\"\u0014\u0005P\u00059a/\u001b:uk\u0006d'b\u0001C)C\u00061a/\u00197vKNLA\u0001\"\u0016\u0005L\tAQ*\u00199WC2,X\rC\u0004\u0005Zm\u0003\r!a \u0002\u0017U\u001cXmU5{K\"Kg\u000e\u001e")
public class QueryCache<QUERY_KEY, EXECUTABLE_QUERY extends CacheabilityInfo> {
    private final CaffeineCacheFactory cacheFactory;
    private final CacheSize maximumSize;
    private final PlanStalenessCaller<EXECUTABLE_QUERY> stalenessCaller;
    private final CacheTracer<QUERY_KEY> tracer;
    private final ExecutingQueryTracer executingQueryTracer;
    private final RemovalListener<QUERY_KEY, CachedValue> removalListener;
    private final Cache<QUERY_KEY, CachedValue> inner;

    public static ParameterTypeMap extractParameterTypeMap(MapValue mapValue, boolean useSizeHint) {
        return QueryCache$.MODULE$.extractParameterTypeMap(mapValue, useSizeHint);
    }

    public static ExecutableQuery NOT_PRESENT() {
        return QueryCache$.MODULE$.NOT_PRESENT();
    }

    public CaffeineCacheFactory cacheFactory() {
        return this.cacheFactory;
    }

    public CacheSize maximumSize() {
        return this.maximumSize;
    }

    public PlanStalenessCaller<EXECUTABLE_QUERY> stalenessCaller() {
        return this.stalenessCaller;
    }

    public CacheTracer<QUERY_KEY> tracer() {
        return this.tracer;
    }

    public ExecutingQueryTracer executingQueryTracer() {
        return this.executingQueryTracer;
    }

    public RemovalListener<QUERY_KEY, CachedValue> removalListener() {
        return this.removalListener;
    }

    private Cache<QUERY_KEY, CachedValue> inner() {
        return this.inner;
    }

    public Cache<QUERY_KEY, CachedValue> createInner(CaffeineCacheFactory innerFactory, CacheSize size, RemovalListener<QUERY_KEY, CachedValue> listener) {
        return innerFactory.createCache(size, listener);
    }

    public long estimatedSize() {
        return this.inner().estimatedSize();
    }

    public EXECUTABLE_QUERY computeIfAbsentOrStale(QUERY_KEY queryKey, TransactionalContext tc, CompilerWithExpressionCodeGenOption<EXECUTABLE_QUERY> compiler, CypherReplanOption replanStrategy, String metaData) {
        LazyRef executingQuery$lzy = new LazyRef();
        if (this.maximumSize().currentValue() == 0) {
            CacheabilityInfo result = (CacheabilityInfo)compiler.compile();
            this.tracer().compute(queryKey, metaData);
            return (EXECUTABLE_QUERY)result;
        }
        CachedValue cachedValue = (CachedValue)this.inner().getIfPresent(queryKey);
        ExecutableQuery executableQuery = QueryCache$.MODULE$.NOT_PRESENT();
        CachedValue cachedValue2 = cachedValue;
        if (!(executableQuery != null ? !executableQuery.equals(cachedValue2) : cachedValue2 != null)) {
            CypherReplanOption cypherReplanOption = replanStrategy;
            CypherReplanOption.force$ force$2 = CypherReplanOption.force$.MODULE$;
            if (!(cypherReplanOption != null ? !cypherReplanOption.equals(force$2) : force$2 != null)) {
                return this.compileWithExpressionCodeGenAndCache(QueryCache.executingQuery$1(executingQuery$lzy, tc), queryKey, compiler, metaData, this.compileWithExpressionCodeGenAndCache$default$5());
            }
            return this.compileAndCache(QueryCache.executingQuery$1(executingQuery$lzy, tc), queryKey, compiler, metaData, this.compileAndCache$default$5());
        }
        cachedValue.markHit();
        CypherReplanOption cypherReplanOption = replanStrategy;
        if (CypherReplanOption.force$.MODULE$.equals(cypherReplanOption)) {
            return this.compileWithExpressionCodeGenAndCache(QueryCache.executingQuery$1(executingQuery$lzy, tc), queryKey, compiler, metaData, true);
        }
        if (CypherReplanOption.skip$.MODULE$.equals(cypherReplanOption)) {
            return this.hit(QueryCache.executingQuery$1(executingQuery$lzy, tc), queryKey, cachedValue, metaData);
        }
        if (CypherReplanOption.default$.MODULE$.equals(cypherReplanOption)) {
            Staleness staleness = this.stalenessCaller().staleness(tc, cachedValue.value());
            if (NotStale$.MODULE$.equals(staleness)) {
                if (this.invalidNotificationExisting(cachedValue, tc)) {
                    return this.compileAndCache(QueryCache.executingQuery$1(executingQuery$lzy, tc), queryKey, compiler, metaData, true);
                }
                return this.recompileOrGet(QueryCache.executingQuery$1(executingQuery$lzy, tc), cachedValue, compiler, queryKey, metaData);
            }
            if (staleness instanceof Stale) {
                Stale stale = (Stale)staleness;
                int secondsSincePlan = stale.secondsSincePlan();
                Option<String> maybeReason = stale.maybeReason();
                this.tracer().cacheStale(queryKey, secondsSincePlan, metaData, maybeReason);
                if (cachedValue.recompiledWithExpressionCodeGen()) {
                    return this.compileWithExpressionCodeGenAndCache(QueryCache.executingQuery$1(executingQuery$lzy, tc), queryKey, compiler, metaData, true);
                }
                return this.compileAndCache(QueryCache.executingQuery$1(executingQuery$lzy, tc), queryKey, compiler, metaData, true);
            }
            throw new MatchError((Object)staleness);
        }
        throw new MatchError((Object)cypherReplanOption);
    }

    public String computeIfAbsentOrStale$default$5() {
        return "";
    }

    private boolean invalidNotificationExisting(CachedValue cachedValue, TransactionalContext tc) {
        IndexedSeq<InternalNotification> notifications = cachedValue.value().notifications();
        for (int i = 0; i < notifications.length(); ++i) {
            if (!this.isInvalidNotification((InternalNotification)notifications.apply(i), tc)) continue;
            return true;
        }
        return false;
    }

    private boolean isInvalidNotification(InternalNotification notification, TransactionalContext tc) {
        InternalNotification internalNotification = notification;
        if (internalNotification instanceof MissingLabelNotification) {
            MissingLabelNotification missingLabelNotification = (MissingLabelNotification)internalNotification;
            return tc.kernelTransaction().tokenRead().nodeLabel(missingLabelNotification.label()) != -1;
        }
        if (internalNotification instanceof MissingRelTypeNotification) {
            MissingRelTypeNotification missingRelTypeNotification = (MissingRelTypeNotification)internalNotification;
            return tc.kernelTransaction().tokenRead().relationshipType(missingRelTypeNotification.relType()) != -1;
        }
        if (internalNotification instanceof MissingPropertyNameNotification) {
            MissingPropertyNameNotification missingPropertyNameNotification = (MissingPropertyNameNotification)internalNotification;
            return tc.kernelTransaction().tokenRead().propertyKey(missingPropertyNameNotification.name()) != -1;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private EXECUTABLE_QUERY recompileOrGet(ExecutingQuery executingQuery, CachedValue cachedValue, CompilerWithExpressionCodeGenOption<EXECUTABLE_QUERY> compiler, QUERY_KEY queryKey, String metaData) {
        CachedValue cachedValue2;
        this.tracer().cacheHit(queryKey, metaData);
        this.executingQueryTracer().cacheHit(executingQuery);
        if (!cachedValue.recompiledWithExpressionCodeGen()) {
            Option<EXECUTABLE_QUERY> option = compiler.maybeCompileWithExpressionCodeGen(cachedValue.numberOfHits());
            if (option instanceof Some) {
                Some some = (Some)option;
                CacheabilityInfo recompiledQuery = (CacheabilityInfo)some.value();
                this.tracer().computeWithExpressionCodeGen(queryKey, metaData);
                CachedValue recompiled = new CachedValue(this, recompiledQuery, true);
                this.inner().put(queryKey, (Object)recompiled);
                cachedValue2 = recompiled;
            } else {
                if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                cachedValue2 = cachedValue;
            }
        } else {
            cachedValue2 = cachedValue;
        }
        CachedValue newCachedValue = cachedValue2;
        return newCachedValue.value();
    }

    private EXECUTABLE_QUERY compileAndCache(ExecutingQuery executingQuery, QUERY_KEY queryKey, CompilerWithExpressionCodeGenOption<EXECUTABLE_QUERY> compiler, String metaData, boolean hitCache) {
        EXECUTABLE_QUERY result = this.compileOrCompileWithExpressionCodeGenAndCache(executingQuery, queryKey, (Function0 & Serializable)() -> (CacheabilityInfo)compiler.compile(), metaData, hitCache);
        this.tracer().compute(queryKey, metaData);
        return result;
    }

    private boolean compileAndCache$default$5() {
        return false;
    }

    private EXECUTABLE_QUERY compileWithExpressionCodeGenAndCache(ExecutingQuery executingQuery, QUERY_KEY queryKey, CompilerWithExpressionCodeGenOption<EXECUTABLE_QUERY> compiler, String metaData, boolean hitCache) {
        EXECUTABLE_QUERY result = this.compileOrCompileWithExpressionCodeGenAndCache(executingQuery, queryKey, (Function0 & Serializable)() -> (CacheabilityInfo)compiler.compileWithExpressionCodeGen(), metaData, hitCache);
        this.tracer().computeWithExpressionCodeGen(queryKey, metaData);
        return result;
    }

    private boolean compileWithExpressionCodeGenAndCache$default$5() {
        return false;
    }

    private EXECUTABLE_QUERY compileOrCompileWithExpressionCodeGenAndCache(ExecutingQuery executingQuery, QUERY_KEY queryKey, Function0<EXECUTABLE_QUERY> compile, String metaData, boolean hitCache) {
        CacheabilityInfo newExecutableQuery = (CacheabilityInfo)compile.apply();
        if (newExecutableQuery.shouldBeCached()) {
            CachedValue cachedValue = new CachedValue(this, newExecutableQuery, false);
            this.inner().put(queryKey, (Object)cachedValue);
            if (hitCache) {
                return this.hit(executingQuery, queryKey, cachedValue, metaData);
            }
            return (EXECUTABLE_QUERY)this.miss(executingQuery, queryKey, newExecutableQuery, metaData);
        }
        return (EXECUTABLE_QUERY)this.miss(executingQuery, queryKey, newExecutableQuery, metaData);
    }

    private EXECUTABLE_QUERY hit(ExecutingQuery executingQuery, QUERY_KEY queryKey, CachedValue executableQuery, String metaData) {
        this.tracer().cacheHit(queryKey, metaData);
        this.executingQueryTracer().cacheHit(executingQuery);
        return executableQuery.value();
    }

    private EXECUTABLE_QUERY miss(ExecutingQuery executingQuery, QUERY_KEY queryKey, EXECUTABLE_QUERY newExecutableQuery, String metaData) {
        this.tracer().cacheMiss(queryKey, metaData);
        this.executingQueryTracer().cacheMiss(executingQuery);
        return newExecutableQuery;
    }

    public long clear() {
        long priorSize = this.inner().estimatedSize();
        this.inner().invalidateAll();
        this.inner().cleanUp();
        this.tracer().cacheFlush(priorSize);
        return priorSize;
    }

    private static final /* synthetic */ ExecutingQuery executingQuery$lzycompute$1(LazyRef executingQuery$lzy$1, TransactionalContext tc$1) {
        ExecutingQuery executingQuery;
        LazyRef lazyRef = executingQuery$lzy$1;
        synchronized (lazyRef) {
            executingQuery = executingQuery$lzy$1.initialized() ? (ExecutingQuery)executingQuery$lzy$1.value() : (ExecutingQuery)executingQuery$lzy$1.initialize((Object)tc$1.executingQuery());
        }
        return executingQuery;
    }

    private static final ExecutingQuery executingQuery$1(LazyRef executingQuery$lzy$1, TransactionalContext tc$1) {
        if (executingQuery$lzy$1.initialized()) {
            return (ExecutingQuery)executingQuery$lzy$1.value();
        }
        return QueryCache.executingQuery$lzycompute$1(executingQuery$lzy$1, tc$1);
    }

    public QueryCache(CaffeineCacheFactory cacheFactory, CacheSize maximumSize, PlanStalenessCaller<EXECUTABLE_QUERY> stalenessCaller, CacheTracer<QUERY_KEY> tracer, ExecutingQueryTracer executingQueryTracer) {
        this.cacheFactory = cacheFactory;
        this.maximumSize = maximumSize;
        this.stalenessCaller = stalenessCaller;
        this.tracer = tracer;
        this.executingQueryTracer = executingQueryTracer;
        this.removalListener = (key, value, cause) -> this.tracer().discard(key, "");
        this.inner = this.createInner(cacheFactory, maximumSize, this.removalListener());
    }

    public static final class CacheKey<QUERY_REP>
    implements Product,
    Serializable {
        private final QUERY_REP queryRep;
        private final ParameterTypeMap parameterTypeMap;
        private final boolean txStateHasChanges;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public QUERY_REP queryRep() {
            return this.queryRep;
        }

        public ParameterTypeMap parameterTypeMap() {
            return this.parameterTypeMap;
        }

        public boolean txStateHasChanges() {
            return this.txStateHasChanges;
        }

        public <QUERY_REP> CacheKey<QUERY_REP> copy(QUERY_REP queryRep, ParameterTypeMap parameterTypeMap, boolean txStateHasChanges) {
            return new CacheKey<QUERY_REP>(queryRep, parameterTypeMap, txStateHasChanges);
        }

        public <QUERY_REP> QUERY_REP copy$default$1() {
            return this.queryRep();
        }

        public <QUERY_REP> ParameterTypeMap copy$default$2() {
            return this.parameterTypeMap();
        }

        public <QUERY_REP> boolean copy$default$3() {
            return this.txStateHasChanges();
        }

        public String productPrefix() {
            return "CacheKey";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.queryRep();
                }
                case 1: {
                    return this.parameterTypeMap();
                }
                case 2: {
                    return BoxesRunTime.boxToBoolean((boolean)this.txStateHasChanges());
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof CacheKey;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "queryRep";
                }
                case 1: {
                    return "parameterTypeMap";
                }
                case 2: {
                    return "txStateHasChanges";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash(this.queryRep()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.parameterTypeMap()));
            n = Statics.mix((int)n, (int)(this.txStateHasChanges() ? 1231 : 1237));
            return Statics.finalizeHash((int)n, (int)3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof CacheKey)) return false;
            boolean bl = true;
            if (!bl) return false;
            CacheKey cacheKey = (CacheKey)x$1;
            if (this.txStateHasChanges() != cacheKey.txStateHasChanges()) return false;
            if (!BoxesRunTime.equals(this.queryRep(), cacheKey.queryRep())) return false;
            ParameterTypeMap parameterTypeMap = this.parameterTypeMap();
            ParameterTypeMap parameterTypeMap2 = cacheKey.parameterTypeMap();
            if (parameterTypeMap != null) {
                if (!((Object)parameterTypeMap).equals(parameterTypeMap2)) return false;
                return true;
            }
            if (parameterTypeMap2 == null) return true;
            return false;
        }

        public CacheKey(QUERY_REP queryRep, ParameterTypeMap parameterTypeMap, boolean txStateHasChanges) {
            this.queryRep = queryRep;
            this.parameterTypeMap = parameterTypeMap;
            this.txStateHasChanges = txStateHasChanges;
            Product.$init$((Product)this);
        }
    }

    public class CachedValue {
        private final EXECUTABLE_QUERY value;
        private final boolean recompiledWithExpressionCodeGen;
        private volatile int _numberOfHits;
        public final /* synthetic */ QueryCache $outer;

        public EXECUTABLE_QUERY value() {
            return this.value;
        }

        public boolean recompiledWithExpressionCodeGen() {
            return this.recompiledWithExpressionCodeGen;
        }

        private int _numberOfHits() {
            return this._numberOfHits;
        }

        private void _numberOfHits_$eq(int x$1) {
            this._numberOfHits = x$1;
        }

        public void markHit() {
            if (!this.recompiledWithExpressionCodeGen()) {
                this._numberOfHits_$eq(this._numberOfHits() + 1);
                return;
            }
        }

        public int numberOfHits() {
            return this._numberOfHits();
        }

        public boolean canEqual(Object other) {
            return other instanceof CachedValue;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object other) {
            Object object = other;
            if (!(object instanceof CachedValue)) return false;
            if (((CachedValue)object).org$neo4j$cypher$internal$QueryCache$CachedValue$$$outer() != this.org$neo4j$cypher$internal$QueryCache$CachedValue$$$outer()) return false;
            CachedValue cachedValue = (CachedValue)object;
            if (!cachedValue.canEqual(this)) return false;
            Object EXECUTABLE_QUERY = this.value();
            Object EXECUTABLE_QUERY2 = cachedValue.value();
            if (EXECUTABLE_QUERY != null) {
                if (!EXECUTABLE_QUERY.equals(EXECUTABLE_QUERY2)) return false;
                return true;
            }
            if (EXECUTABLE_QUERY2 == null) return true;
            return false;
        }

        public int hashCode() {
            .colon.colon state = new .colon.colon(this.value(), (List)Nil$.MODULE$);
            return BoxesRunTime.unboxToInt((Object)((IterableOnceOps)state.map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.hashCode()))).foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)(JFunction2.mcIII.sp & Serializable)(a, b) -> 31 * a + b));
        }

        public /* synthetic */ QueryCache org$neo4j$cypher$internal$QueryCache$CachedValue$$$outer() {
            return this.$outer;
        }

        /*
         * WARNING - Possible parameter corruption
         */
        public CachedValue(EXECUTABLE_QUERY value, boolean recompiledWithExpressionCodeGen) {
            this.value = value;
            this.recompiledWithExpressionCodeGen = recompiledWithExpressionCodeGen;
            if ($outer == null) {
                throw null;
            }
            this.$outer = (QueryCache)$outer;
            this._numberOfHits = 0;
        }
    }

    public static class ParameterTypeMap {
        private final Map<String, ParameterTypeInfo> resultMap;
        private final int _hashCode;

        private Map<String, ParameterTypeInfo> resultMap() {
            return this.resultMap;
        }

        public int hashCode() {
            return this._hashCode;
        }

        public boolean equals(Object obj) {
            Object object = obj;
            if (object instanceof ParameterTypeMap) {
                ParameterTypeMap parameterTypeMap = (ParameterTypeMap)object;
                if (this.resultMap().size() == parameterTypeMap.resultMap().size()) {
                    Map<String, ParameterTypeInfo> otherMap = parameterTypeMap.resultMap();
                    java.util.Iterator<Map.Entry<String, ParameterTypeInfo>> entries = otherMap.entrySet().iterator();
                    boolean stillEqual = true;
                    while (entries.hasNext() && stillEqual) {
                        Map.Entry<String, ParameterTypeInfo> entry = entries.next();
                        String otherKey = entry.getKey();
                        ParameterTypeInfo otherValue = entry.getValue();
                        ParameterTypeInfo value = this.resultMap().get(otherKey);
                        stillEqual = otherValue.equals((Object)value);
                    }
                    return stillEqual;
                }
            }
            return false;
        }

        public String toString() {
            return CollectionConverters$.MODULE$.MapHasAsScala(this.resultMap()).asScala().toString();
        }

        public ParameterTypeMap(Map<String, ParameterTypeInfo> resultMap, int _hashCode) {
            this.resultMap = resultMap;
            this._hashCode = _hashCode;
        }
    }
}

