/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.diagnostics.jmx;

import com.sun.management.HotSpotDiagnosticMXBean;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import jdk.jfr.Configuration;
import jdk.management.jfr.FlightRecorderMXBean;
import org.neo4j.internal.utils.DumpUtils;
import org.neo4j.kernel.diagnostics.DiagnosticsReportSource;
import org.neo4j.kernel.diagnostics.DiagnosticsReportSources;

public class JmxDump
implements AutoCloseable {
    private static final String HOTSPOT_BEAN_NAME = "com.sun.management:type=HotSpotDiagnostic";
    private final JMXConnector connector;
    private final MBeanServerConnection mBeanServer;
    private final long pid;
    private Properties systemProperties;
    public static final String THREAD_DUMP_FAILURE = "ERROR: Unable to produce any thread dump";
    public static final String VM_ARGS_FAILURE = "ERROR: Unable to produce any thread dump";

    private JmxDump(JMXConnector connector, MBeanServerConnection mBeanServer, long pid) {
        this.connector = connector;
        this.mBeanServer = mBeanServer;
        this.pid = pid;
    }

    public static JmxDump connectTo(String jmxAddress, long pid) throws IOException {
        JMXServiceURL url = new JMXServiceURL(jmxAddress);
        JMXConnector connect = JMXConnectorFactory.connect(url);
        return new JmxDump(connect, connect.getMBeanServerConnection(), pid);
    }

    public void attachSystemProperties(Properties systemProperties) {
        this.systemProperties = systemProperties;
    }

    public DiagnosticsReportSource legacyThreadDumpSource() {
        return DiagnosticsReportSources.newDiagnosticsString((String)"threaddump.txt", this::legacyThreadDump);
    }

    public DiagnosticsReportSource jsonThreadDumpSource() {
        return DiagnosticsReportSources.newDiagnosticsString((String)"threaddump.json", this::jsonThreadDump);
    }

    private String jsonThreadDump() {
        try {
            HotSpotDiagnosticMXBean hotspotBean = ManagementFactory.newPlatformMXBeanProxy(this.mBeanServer, HOTSPOT_BEAN_NAME, HotSpotDiagnosticMXBean.class);
            return DumpUtils.threadDump((HotSpotDiagnosticMXBean)hotspotBean);
        }
        catch (IOException e) {
            return "ERROR: Unable to produce any thread dump";
        }
    }

    public String legacyThreadDump() {
        String result;
        try {
            result = (String)this.mBeanServer.invoke(new ObjectName("com.sun.management:type=DiagnosticCommand"), "threadPrint", new Object[]{null}, new String[]{String[].class.getName()});
        }
        catch (IOException | InstanceNotFoundException | MBeanException | MalformedObjectNameException | ReflectionException exception) {
            result = this.getMXThreadDump();
        }
        return result;
    }

    private String getMXThreadDump() {
        ThreadMXBean threadMxBean;
        try {
            threadMxBean = ManagementFactory.getPlatformMXBean(this.mBeanServer, ThreadMXBean.class);
        }
        catch (IOException e) {
            return "ERROR: Unable to produce any thread dump";
        }
        return DumpUtils.legacyThreadDump((ThreadMXBean)threadMxBean, (Properties)this.systemProperties);
    }

    public String vmArguments() {
        RuntimeMXBean runtimeMxBean;
        try {
            runtimeMxBean = ManagementFactory.getPlatformMXBean(this.mBeanServer, RuntimeMXBean.class);
        }
        catch (IOException e) {
            return "ERROR: Unable to produce any thread dump";
        }
        return String.join((CharSequence)" ", runtimeMxBean.getInputArguments());
    }

    public DiagnosticsReportSource heapDump() {
        return new DiagnosticsReportSource(){

            public String destinationPath() {
                return "heapdump.hprof";
            }

            public InputStream newInputStream() throws IOException {
                final Path heapdumpFile = Files.createTempFile("neo4j-heapdump", ".hprof", new FileAttribute[0]).toAbsolutePath();
                Files.deleteIfExists(heapdumpFile);
                JmxDump.this.heapDump(heapdumpFile.toString());
                return new FileInputStream(this, heapdumpFile.toFile()){

                    @Override
                    public void close() throws IOException {
                        super.close();
                        Files.deleteIfExists(heapdumpFile);
                    }
                };
            }

            public long estimatedSize() {
                try {
                    MemoryMXBean bean = ManagementFactory.getPlatformMXBean(JmxDump.this.mBeanServer, MemoryMXBean.class);
                    long totalMemory = bean.getHeapMemoryUsage().getCommitted() + bean.getNonHeapMemoryUsage().getCommitted();
                    return (long)((double)totalMemory * 1.2);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        };
    }

    private void heapDump(String destination) throws IOException {
        HotSpotDiagnosticMXBean hotSpotDiagnosticMXBean = ManagementFactory.getPlatformMXBean(this.mBeanServer, HotSpotDiagnosticMXBean.class);
        hotSpotDiagnosticMXBean.dumpHeap(destination, false);
    }

    public DiagnosticsReportSource systemProperties() {
        return new DiagnosticsReportSource(){

            public String destinationPath() {
                return "vm.prop";
            }

            public InputStream newInputStream() {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                JmxDump.this.systemProperties.list(new PrintStream(out, true));
                return new ByteArrayInputStream(out.toByteArray());
            }

            public long estimatedSize() {
                return 0L;
            }
        };
    }

    public JfrProfileConnection jfrConnection() throws IOException {
        FlightRecorderMXBean bean = ManagementFactory.getPlatformMXBean(this.mBeanServer, FlightRecorderMXBean.class);
        return new JfrProfileConnection(bean);
    }

    @Override
    public void close() {
        try {
            this.connector.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public long getPid() {
        return this.pid;
    }

    public static class JfrProfileConnection {
        private final FlightRecorderMXBean bean;
        private final Map<String, String> settings;
        private boolean hasRecording;
        private long recordingId;
        private static final Set<String> RUNNING_STATES = Set.of("STARTING", "RUNNING", "STOPPING");

        private JfrProfileConnection(FlightRecorderMXBean bean) {
            this.bean = bean;
            try {
                this.settings = Configuration.getConfiguration("profile").getSettings();
            }
            catch (Exception e) {
                throw new RuntimeException("No configuration found for JFR");
            }
        }

        public void start(String name, Duration maxDuration, Path path) {
            if (this.hasRecording) {
                throw new IllegalStateException("Already has a running recording, needs to be stopped first");
            }
            this.recordingId = this.bean.newRecording();
            Map<String, String> config = Map.of("name", name, "duration", maxDuration.getSeconds() + "s", "destination", path.toAbsolutePath().toString(), "disk", "true", "maxAge", "0s", "maxSize", "0", "dumpOnExit", "true");
            this.bean.setRecordingOptions(this.recordingId, config);
            this.bean.setRecordingSettings(this.recordingId, this.settings);
            this.bean.startRecording(this.recordingId);
            this.hasRecording = true;
        }

        public void stop() {
            if (this.hasRecording) {
                try {
                    this.bean.closeRecording(this.recordingId);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
                finally {
                    this.hasRecording = false;
                }
            }
        }

        public boolean isRunning() {
            if (this.hasRecording) {
                try {
                    return this.bean.getRecordings().stream().anyMatch(info -> info.getId() == this.recordingId && RUNNING_STATES.contains(info.getState()));
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
            return false;
        }
    }
}

