/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.diagnostics.profile;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.time.Duration;
import org.neo4j.configuration.BootloaderSettings;
import org.neo4j.dbms.diagnostics.jmx.JmxDump;
import org.neo4j.dbms.diagnostics.profile.PeriodicProfiler;
import org.neo4j.internal.helpers.ProcessUtils;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.time.SystemNanoClock;

class NmtProfiler
extends PeriodicProfiler {
    private final JmxDump dump;
    private final FileSystemAbstraction fs;
    private final Path dir;
    private final String jcmd;
    private volatile boolean detailed;

    NmtProfiler(JmxDump dump, FileSystemAbstraction fs, Path dir, Duration interval, SystemNanoClock clock) {
        super(interval, clock);
        this.dump = dump;
        this.fs = fs;
        this.dir = dir;
        try {
            fs.mkdirs(dir);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        this.jcmd = ProcessUtils.getJavaExecutable().getParent().resolve("jcmd").toAbsolutePath().toString();
    }

    @Override
    protected void start() {
        this.checkDetailed();
        this.setBaseline();
        this.writeReport("full", this.getFullReport());
        super.start();
    }

    @Override
    protected void stop() {
        this.writeReport("full", this.getFullReport());
        super.stop();
    }

    @Override
    protected void tick() {
        this.writeReport("diff", this.getDiffReport());
    }

    @Override
    protected boolean available() {
        String vmArgs = this.dump.vmArguments();
        if (vmArgs.contains("-XX:NativeMemoryTracking") && !vmArgs.contains("-XX:NativeMemoryTracking=off")) {
            try {
                NmtProfiler.executeCommand(this.jcmd);
                return true;
            }
            catch (RuntimeException ignored) {
                this.setFailure(new RuntimeException("'jcmd' tool not found. Make sure it is installed"));
            }
        } else {
            this.setFailure(new RuntimeException("Java NMT not enabled on the server. Temporarily add " + BootloaderSettings.additional_jvm.name() + "=-XX:NativeMemoryTracking=summary to neo4j.conf and restart the server to enable. Please note that this has a performance impact."));
        }
        return false;
    }

    private void checkDetailed() {
        String vmArgs = this.dump.vmArguments();
        this.detailed = vmArgs.contains("-XX:NativeMemoryTracking=detail");
    }

    private void writeReport(String type, String report) {
        String name = String.format("nmt-%s-%s-%s.txt", type, this.detailed ? "detail" : "summary", this.clock.instant().toString());
        try (OutputStream os = this.fs.openAsOutputStream(this.dir.resolve(name), false);){
            os.write(report.getBytes());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void setBaseline() {
        this.executeNmt("baseline");
    }

    private String getFullReport() {
        return this.executeNmt(this.detailed ? "detail" : "summary");
    }

    private String getDiffReport() {
        return this.executeNmt(this.detailed ? "detail.diff" : "summary.diff");
    }

    private String executeNmt(String arg) {
        return NmtProfiler.executeCommand(this.jcmd, Long.toString(this.dump.getPid()), "VM.native_memory", arg);
    }

    static String executeCommand(String ... commands) {
        return ProcessUtils.executeCommandWithOutput((String[])commands, (Duration)Duration.ofMinutes(1L));
    }
}

