/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.dbms;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.neo4j.commandline.dbms.CannotWriteException;
import org.neo4j.io.IOUtils;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.internal.StoreLocker;

class StoreLockChecker
implements Closeable {
    private final FileSystemAbstraction fileSystem;
    private final StoreLocker storeLocker;

    private StoreLockChecker(FileSystemAbstraction fileSystem) {
        this.fileSystem = fileSystem;
        this.storeLocker = new StoreLocker(fileSystem);
    }

    static Closeable check(Path databaseDirectory) throws CannotWriteException {
        Path lockFile = databaseDirectory.resolve("store_lock");
        if (Files.exists(lockFile, new LinkOption[0])) {
            if (Files.isWritable(lockFile)) {
                StoreLockChecker storeLocker = new StoreLockChecker((FileSystemAbstraction)new DefaultFileSystemAbstraction());
                storeLocker.checkLock(databaseDirectory.toFile());
                return storeLocker;
            }
            throw new CannotWriteException(lockFile);
        }
        return () -> {};
    }

    private void checkLock(File file) {
        this.storeLocker.checkLock(file);
    }

    @Override
    public void close() throws IOException {
        IOUtils.closeAll((AutoCloseable[])new Closeable[]{this.storeLocker, this.fileSystem});
    }
}

