/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.routing;

import java.util.List;
import java.util.Objects;
import org.neo4j.configuration.helpers.SocketAddress;

public class RoutingResult {
    private final List<SocketAddress> routeEndpoints;
    private final List<SocketAddress> writeEndpoints;
    private final List<SocketAddress> readEndpoints;
    private final long timeToLiveMillis;

    public RoutingResult(List<SocketAddress> routeEndpoints, List<SocketAddress> writeEndpoints, List<SocketAddress> readEndpoints, long timeToLiveMillis) {
        this.routeEndpoints = routeEndpoints;
        this.writeEndpoints = writeEndpoints;
        this.readEndpoints = readEndpoints;
        this.timeToLiveMillis = timeToLiveMillis;
    }

    public long ttlMillis() {
        return this.timeToLiveMillis;
    }

    public List<SocketAddress> routeEndpoints() {
        return this.routeEndpoints;
    }

    public List<SocketAddress> writeEndpoints() {
        return this.writeEndpoints;
    }

    public List<SocketAddress> readEndpoints() {
        return this.readEndpoints;
    }

    public boolean containsNoEndpoints() {
        return this.routeEndpoints.isEmpty() && this.writeEndpoints.isEmpty() && this.readEndpoints.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RoutingResult that = (RoutingResult)o;
        return this.timeToLiveMillis == that.timeToLiveMillis && Objects.equals(this.routeEndpoints, that.routeEndpoints) && Objects.equals(this.writeEndpoints, that.writeEndpoints) && Objects.equals(this.readEndpoints, that.readEndpoints);
    }

    public int hashCode() {
        return Objects.hash(this.routeEndpoints, this.writeEndpoints, this.readEndpoints, this.timeToLiveMillis);
    }

    public String toString() {
        return "RoutingResult{routeEndpoints=" + String.valueOf(this.routeEndpoints) + ", writeEndpoints=" + String.valueOf(this.writeEndpoints) + ", readEndpoints=" + String.valueOf(this.readEndpoints) + ", timeToLiveMillis=" + this.timeToLiveMillis + "}";
    }
}

