/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.fabric.transaction;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.neo4j.fabric.eval.Catalog;
import org.neo4j.fabric.eval.CatalogManager;
import org.neo4j.fabric.executor.Location;
import org.neo4j.fabric.transaction.FabricTransactionInfo;

public class LocationCache {
    private final CatalogManager catalogManager;
    private final FabricTransactionInfo transactionInfo;
    private final Map<Catalog.Graph, Location> locationMap = new ConcurrentHashMap<Catalog.Graph, Location>();

    public LocationCache(CatalogManager catalogManager, FabricTransactionInfo transactionInfo) {
        this.catalogManager = catalogManager;
        this.transactionInfo = transactionInfo;
    }

    public Location locationOf(Catalog.Graph graph, Boolean requireWritable) {
        return this.locationMap.computeIfAbsent(graph, k -> this.catalogManager.locationOf(this.transactionInfo.getSessionDatabaseReference(), graph, requireWritable, this.transactionInfo.getRoutingContext()));
    }

    public int size() {
        return this.locationMap.size();
    }
}

