/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.fulltext;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.neo4j.internal.kernel.api.IndexReference;
import org.neo4j.io.IOUtils;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndexProvider;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndexReader;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndexTransactionState;
import org.neo4j.kernel.api.txstate.auxiliary.AuxiliaryTransactionState;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.logging.Log;
import org.neo4j.storageengine.api.StorageCommand;

class FulltextAuxiliaryTransactionState
implements AuxiliaryTransactionState,
Function<IndexReference, FulltextIndexTransactionState> {
    private final FulltextIndexProvider provider;
    private final Log log;
    private final Map<IndexReference, FulltextIndexTransactionState> indexStates;

    FulltextAuxiliaryTransactionState(FulltextIndexProvider provider, Log log) {
        this.provider = provider;
        this.log = log;
        this.indexStates = new HashMap<IndexReference, FulltextIndexTransactionState>();
    }

    public void close() throws Exception {
        IOUtils.closeAll(this.indexStates.values());
    }

    public boolean hasChanges() {
        return false;
    }

    public void extractCommands(Collection<StorageCommand> target) {
    }

    FulltextIndexReader indexReader(IndexReference indexReference, KernelTransactionImplementation kti) {
        FulltextIndexTransactionState state = this.indexStates.computeIfAbsent(indexReference, this);
        return state.getIndexReader(kti);
    }

    @Override
    public FulltextIndexTransactionState apply(IndexReference indexReference) {
        return new FulltextIndexTransactionState(this.provider, this.log, indexReference);
    }
}

