/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.fulltext;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import org.apache.lucene.document.Document;
import org.neo4j.function.ThrowingAction;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndexDescriptor;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndexReader;
import org.neo4j.kernel.api.impl.fulltext.LuceneFulltextDocumentStructure;
import org.neo4j.kernel.api.impl.index.DatabaseIndex;
import org.neo4j.kernel.api.impl.schema.populator.LuceneIndexPopulator;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.NodePropertyAccessor;
import org.neo4j.logging.Log;
import org.neo4j.logging.NullLog;
import org.neo4j.storageengine.api.schema.IndexSample;

public class FulltextIndexPopulator
extends LuceneIndexPopulator<DatabaseIndex<FulltextIndexReader>> {
    static Log TRACE_LOG = NullLog.getInstance();
    private final FulltextIndexDescriptor descriptor;
    private final ThrowingAction<IOException> descriptorCreateAction;

    public FulltextIndexPopulator(FulltextIndexDescriptor descriptor, DatabaseIndex<FulltextIndexReader> luceneFulltext, ThrowingAction<IOException> descriptorCreateAction) {
        super(luceneFulltext);
        this.descriptor = descriptor;
        this.descriptorCreateAction = descriptorCreateAction;
    }

    public void create() {
        super.create();
        try {
            this.descriptorCreateAction.apply();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void add(Collection<? extends IndexEntryUpdate<?>> updates) {
        try {
            for (IndexEntryUpdate<?> update : updates) {
                TRACE_LOG.debug("populator add: %s", new Object[]{update});
                this.writer.updateDocument(LuceneFulltextDocumentStructure.newTermForChangeOrRemove(update.getEntityId()), this.updateAsDocument(update));
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void verifyDeferredConstraints(NodePropertyAccessor propertyAccessor) {
    }

    public IndexUpdater newPopulatingUpdater(NodePropertyAccessor accessor) {
        return new PopulatingFulltextIndexUpdater();
    }

    public void includeSample(IndexEntryUpdate<?> update) {
    }

    public IndexSample sampleResult() {
        return new IndexSample();
    }

    private Document updateAsDocument(IndexEntryUpdate<?> update) {
        return LuceneFulltextDocumentStructure.documentRepresentingProperties(update.getEntityId(), this.descriptor.propertyNames(), update.values());
    }

    private class PopulatingFulltextIndexUpdater
    implements IndexUpdater {
        private PopulatingFulltextIndexUpdater() {
        }

        public void process(IndexEntryUpdate<?> update) {
            TRACE_LOG.debug("populating updater process: %s", new Object[]{update});
            assert (update.indexKey().schema().equals(FulltextIndexPopulator.this.descriptor.schema()));
            try {
                switch (update.updateMode()) {
                    case ADDED: {
                        long nodeId = update.getEntityId();
                        FulltextIndexPopulator.this.luceneIndex.getIndexWriter().updateDocument(LuceneFulltextDocumentStructure.newTermForChangeOrRemove(nodeId), LuceneFulltextDocumentStructure.documentRepresentingProperties(nodeId, FulltextIndexPopulator.this.descriptor.propertyNames(), update.values()));
                    }
                    case CHANGED: {
                        long nodeId1 = update.getEntityId();
                        FulltextIndexPopulator.this.luceneIndex.getIndexWriter().updateDocument(LuceneFulltextDocumentStructure.newTermForChangeOrRemove(nodeId1), LuceneFulltextDocumentStructure.documentRepresentingProperties(nodeId1, FulltextIndexPopulator.this.descriptor.propertyNames(), update.values()));
                        break;
                    }
                    case REMOVED: {
                        FulltextIndexPopulator.this.luceneIndex.getIndexWriter().deleteDocuments(LuceneFulltextDocumentStructure.newTermForChangeOrRemove(update.getEntityId()));
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException();
                    }
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        public void close() {
        }
    }
}

