/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.fulltext;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.lucene.queryparser.classic.ParseException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.internal.kernel.api.IndexReference;
import org.neo4j.internal.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.kernel.api.exceptions.schema.SchemaKernelException;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.impl.fulltext.FulltextAdapter;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndexProviderFactory;
import org.neo4j.kernel.api.impl.fulltext.ScoreEntityIterator;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;
import org.neo4j.storageengine.api.EntityType;
import org.neo4j.storageengine.api.schema.IndexDescriptor;
import org.neo4j.util.FeatureToggles;

public class FulltextProcedures {
    private static final long INDEX_ONLINE_QUERY_TIMEOUT_SECONDS = FeatureToggles.getInteger(FulltextProcedures.class, (String)"INDEX_ONLINE_QUERY_TIMEOUT_SECONDS", (int)30);
    @Context
    public KernelTransaction tx;
    @Context
    public GraphDatabaseService db;
    @Context
    public FulltextAdapter accessor;

    @Description(value="List the available analyzers that the fulltext indexes can be configured with.")
    @Procedure(name="db.index.fulltext.listAvailableAnalyzers", mode=Mode.READ)
    public Stream<AvailableAnalyzer> listAvailableAnalyzers() {
        return this.accessor.listAvailableAnalyzers().map(AvailableAnalyzer::new);
    }

    @Description(value="Wait for the updates from recently committed transactions to be applied to any eventually-consistent fulltext indexes.")
    @Procedure(name="db.index.fulltext.awaitEventuallyConsistentIndexRefresh", mode=Mode.READ)
    public void awaitRefresh() {
        this.accessor.awaitRefresh();
    }

    @Description(value="Create a node fulltext index for the given labels and properties. The optional 'config' map parameter can be used to supply settings to the index. Note: index specific settings are currently experimental, and might not replicated correctly in a cluster, or during backup. Supported settings are 'analyzer', for specifying what analyzer to use when indexing and querying. Use the `db.index.fulltext.listAvailableAnalyzers` procedure to see what options are available. And 'eventually_consistent' which can be set to 'true' to make this index eventually consistent, such that updates from committing transactions are applied in a background thread.")
    @Procedure(name="db.index.fulltext.createNodeIndex", mode=Mode.SCHEMA)
    public void createNodeFulltextIndex(@Name(value="indexName") String name, @Name(value="labels") List<String> labels, @Name(value="propertyNames") List<String> properties, @Name(value="config", defaultValue="") Map<String, String> indexConfigurationMap) throws InvalidTransactionTypeKernelException, SchemaKernelException {
        Properties indexConfiguration = new Properties();
        indexConfiguration.putAll(indexConfigurationMap);
        SchemaDescriptor schemaDescriptor = this.accessor.schemaFor(EntityType.NODE, this.stringArray(labels), indexConfiguration, this.stringArray(properties));
        this.tx.schemaWrite().indexCreate(schemaDescriptor, FulltextIndexProviderFactory.DESCRIPTOR.name(), Optional.of(name));
    }

    private String[] stringArray(List<String> strings) {
        return strings.toArray(ArrayUtils.EMPTY_STRING_ARRAY);
    }

    @Description(value="Create a relationship fulltext index for the given relationship types and properties. The optional 'config' map parameter can be used to supply settings to the index. Note: index specific settings are currently experimental, and might not replicated correctly in a cluster, or during backup. Supported settings are 'analyzer', for specifying what analyzer to use when indexing and querying. Use the `db.index.fulltext.listAvailableAnalyzers` procedure to see what options are available. And 'eventually_consistent' which can be set to 'true' to make this index eventually consistent, such that updates from committing transactions are applied in a background thread.")
    @Procedure(name="db.index.fulltext.createRelationshipIndex", mode=Mode.SCHEMA)
    public void createRelationshipFulltextIndex(@Name(value="indexName") String name, @Name(value="relationshipTypes") List<String> relTypes, @Name(value="propertyNames") List<String> properties, @Name(value="config", defaultValue="") Map<String, String> config) throws InvalidTransactionTypeKernelException, SchemaKernelException {
        Properties settings = new Properties();
        settings.putAll(config);
        SchemaDescriptor schemaDescriptor = this.accessor.schemaFor(EntityType.RELATIONSHIP, this.stringArray(relTypes), settings, this.stringArray(properties));
        this.tx.schemaWrite().indexCreate(schemaDescriptor, FulltextIndexProviderFactory.DESCRIPTOR.name(), Optional.of(name));
    }

    @Description(value="Drop the specified index.")
    @Procedure(name="db.index.fulltext.drop", mode=Mode.SCHEMA)
    public void drop(@Name(value="indexName") String name) throws InvalidTransactionTypeKernelException, SchemaKernelException {
        IndexReference indexReference = this.getValidIndexReference(name);
        this.tx.schemaWrite().indexDrop(indexReference);
    }

    @Description(value="Query the given fulltext index. Returns the matching nodes and their lucene query score, ordered by score.")
    @Procedure(name="db.index.fulltext.queryNodes", mode=Mode.READ)
    public Stream<NodeOutput> queryFulltextForNodes(@Name(value="indexName") String name, @Name(value="queryString") String query) throws ParseException, IndexNotFoundKernelException, IOException {
        IndexReference indexReference = this.getValidIndexReference(name);
        this.awaitOnline(indexReference);
        EntityType entityType = indexReference.schema().entityType();
        if (entityType != EntityType.NODE) {
            throw new IllegalArgumentException("The '" + name + "' index (" + indexReference + ") is an index on " + entityType + ", so it cannot be queried for nodes.");
        }
        ScoreEntityIterator resultIterator = this.accessor.query(this.tx, name, query);
        return resultIterator.stream().map(result -> NodeOutput.forExistingEntityOrNull(this.db, result)).filter(Objects::nonNull);
    }

    @Description(value="Query the given fulltext index. Returns the matching relationships and their lucene query score, ordered by score.")
    @Procedure(name="db.index.fulltext.queryRelationships", mode=Mode.READ)
    public Stream<RelationshipOutput> queryFulltextForRelationships(@Name(value="indexName") String name, @Name(value="queryString") String query) throws ParseException, IndexNotFoundKernelException, IOException {
        IndexReference indexReference = this.getValidIndexReference(name);
        this.awaitOnline(indexReference);
        EntityType entityType = indexReference.schema().entityType();
        if (entityType != EntityType.RELATIONSHIP) {
            throw new IllegalArgumentException("The '" + name + "' index (" + indexReference + ") is an index on " + entityType + ", so it cannot be queried for relationships.");
        }
        ScoreEntityIterator resultIterator = this.accessor.query(this.tx, name, query);
        return resultIterator.stream().map(result -> RelationshipOutput.forExistingEntityOrNull(this.db, result)).filter(Objects::nonNull);
    }

    private IndexReference getValidIndexReference(@Name(value="indexName") String name) {
        IndexReference indexReference = this.tx.schemaRead().indexGetForName(name);
        if (indexReference == IndexReference.NO_INDEX) {
            throw new IllegalArgumentException("There is no such fulltext schema index: " + name);
        }
        return indexReference;
    }

    private void awaitOnline(IndexReference indexReference) throws IndexNotFoundKernelException {
        if (!((KernelTransactionImplementation)this.tx).txState().indexDiffSetsBySchema(indexReference.schema()).isAdded((Object)((IndexDescriptor)indexReference))) {
            Schema schema = this.db.schema();
            IndexDefinition index = schema.getIndexByName(indexReference.name());
            schema.awaitIndexOnline(index, INDEX_ONLINE_QUERY_TIMEOUT_SECONDS, TimeUnit.SECONDS);
        }
    }

    public static final class AvailableAnalyzer {
        public final String analyzer;

        AvailableAnalyzer(String analyzer) {
            this.analyzer = analyzer;
        }
    }

    public static final class RelationshipOutput {
        public final Relationship relationship;
        public final double score;

        public RelationshipOutput(Relationship relationship, double score) {
            this.relationship = relationship;
            this.score = score;
        }

        public static RelationshipOutput forExistingEntityOrNull(GraphDatabaseService db, ScoreEntityIterator.ScoreEntry result) {
            try {
                return new RelationshipOutput(db.getRelationshipById(result.entityId()), result.score());
            }
            catch (NotFoundException ignore) {
                return null;
            }
        }
    }

    public static final class NodeOutput {
        public final Node node;
        public final double score;

        protected NodeOutput(Node node, double score) {
            this.node = node;
            this.score = score;
        }

        public static NodeOutput forExistingEntityOrNull(GraphDatabaseService db, ScoreEntityIterator.ScoreEntry result) {
            try {
                return new NodeOutput(db.getNodeById(result.entityId()), result.score());
            }
            catch (NotFoundException ignore) {
                return null;
            }
        }
    }
}

