/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.fulltext;

import org.neo4j.kernel.api.impl.fulltext.IndexUpdateSink;
import org.neo4j.kernel.api.impl.index.DatabaseIndex;
import org.neo4j.kernel.api.index.IndexReader;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.storageengine.api.IndexEntryUpdate;

class EventuallyConsistentIndexUpdater
implements IndexUpdater {
    private final DatabaseIndex<? extends IndexReader> index;
    private final IndexUpdater indexUpdater;
    private final IndexUpdateSink indexUpdateSink;

    EventuallyConsistentIndexUpdater(DatabaseIndex<? extends IndexReader> index, IndexUpdater indexUpdater, IndexUpdateSink indexUpdateSink) {
        this.index = index;
        this.indexUpdater = indexUpdater;
        this.indexUpdateSink = indexUpdateSink;
    }

    public void process(IndexEntryUpdate<?> update) {
        this.indexUpdateSink.enqueueUpdate(this.index, this.indexUpdater, update);
    }

    public void close() {
        this.indexUpdateSink.closeUpdater(this.index, this.indexUpdater);
    }
}

