/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.function;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.neo4j.function.Predicate;
import org.neo4j.function.Supplier;
import org.neo4j.function.Suppliers;

public class Predicates {
    private static final Predicate TRUE = new Predicate(){

        @Override
        public boolean test(Object item) {
            return true;
        }
    };
    private static final Predicate FALSE = new Predicate(){

        @Override
        public boolean test(Object item) {
            return false;
        }
    };
    private static final Predicate NOT_NULL = new Predicate(){

        @Override
        public boolean test(Object item) {
            return item != null;
        }
    };

    public static <T> Predicate<T> alwaysTrue() {
        return TRUE;
    }

    public static <T> Predicate<T> alwaysFalse() {
        return FALSE;
    }

    public static <T> Predicate<T> notNull() {
        return NOT_NULL;
    }

    @SafeVarargs
    public static <T> Predicate<T> all(Predicate<T> ... predicates) {
        return Predicates.all(Arrays.asList(predicates));
    }

    public static <T> Predicate<T> all(final Iterable<Predicate<T>> predicates) {
        return new Predicate<T>(){

            @Override
            public boolean test(T item) {
                for (Predicate predicate : predicates) {
                    if (predicate.test(item)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    @SafeVarargs
    public static <T> Predicate<T> any(Predicate<T> ... predicates) {
        return Predicates.any(Arrays.asList(predicates));
    }

    public static <T> Predicate<T> any(final Iterable<Predicate<T>> predicates) {
        return new Predicate<T>(){

            @Override
            public boolean test(T item) {
                for (Predicate predicate : predicates) {
                    if (!predicate.test(item)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static <T> Predicate<T> not(final Predicate<T> other) {
        return new Predicate<T>(){

            @Override
            public boolean test(T item) {
                return !other.test(item);
            }
        };
    }

    public static <T> Predicate<T> equalTo(final T other) {
        return new Predicate<T>(){

            @Override
            public boolean test(T item) {
                return other == null ? item == null : other.equals(item);
            }
        };
    }

    public static <T> Predicate<T> instanceOf(final Class clazz) {
        return new Predicate<T>(){

            @Override
            public boolean test(T item) {
                return item != null && clazz.isInstance(item);
            }
        };
    }

    public static <T> Predicate<T> instanceOfAny(final Class ... classes) {
        return new Predicate<T>(){

            @Override
            public boolean test(T item) {
                if (item != null) {
                    for (Class clazz : classes) {
                        if (!clazz.isInstance(item)) continue;
                        return true;
                    }
                }
                return false;
            }
        };
    }

    public static <T> Predicate<T> noDuplicates() {
        return new Predicate<T>(){
            private final Set<T> visitedItems = new HashSet();

            @Override
            public boolean test(T item) {
                return this.visitedItems.add(item);
            }
        };
    }

    public static <TYPE> void await(Supplier<TYPE> supplier, Predicate<TYPE> predicate, long timeout, TimeUnit unit) throws TimeoutException, InterruptedException {
        Predicates.await(Suppliers.compose(supplier, predicate), timeout, unit);
    }

    public static void await(Supplier<Boolean> condition, long timeout, TimeUnit unit) throws TimeoutException, InterruptedException {
        long sleep = Math.max(unit.toMillis(timeout) / 100L, 1L);
        long deadline = System.currentTimeMillis() + unit.toMillis(timeout);
        do {
            if (condition.get().booleanValue()) {
                return;
            }
            Thread.sleep(sleep);
        } while (System.currentTimeMillis() < deadline);
        throw new TimeoutException("Waited for " + timeout + " " + (Object)((Object)unit) + ", but " + condition + " was not accepted.");
    }

    public static void awaitForever(Supplier<Boolean> condition, long checkInterval, TimeUnit unit) throws InterruptedException {
        long sleep = unit.toMillis(checkInterval);
        while (!condition.get().booleanValue()) {
            Thread.sleep(sleep);
        }
        return;
    }
}

