/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.function;

import org.neo4j.function.Function;
import org.neo4j.function.Predicate;
import org.neo4j.function.Supplier;

public final class Suppliers {
    public static <T> Supplier<T> singleton(final T instance) {
        return new Supplier<T>(){

            @Override
            public T get() {
                return instance;
            }
        };
    }

    public static <T> Supplier<T> lazySingleton(final Supplier<T> supplier) {
        return new Supplier<T>(){
            volatile T instance = null;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T get() {
                if (this.instance != null) {
                    return this.instance;
                }
                2 var1_1 = this;
                synchronized (var1_1) {
                    if (this.instance == null) {
                        this.instance = supplier.get();
                    }
                }
                return this.instance;
            }
        };
    }

    public static <T, V> Supplier<T> adapted(final Supplier<V> supplier, final Function<V, T> adaptor) {
        return new Supplier<T>(){
            volatile V lastValue = null;
            T instance = null;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T get() {
                Object value = supplier.get();
                if (value == this.lastValue) {
                    return this.instance;
                }
                Object adaptedValue = adaptor.apply(value);
                3 var3_3 = this;
                synchronized (var3_3) {
                    if (value != this.lastValue) {
                        this.instance = adaptedValue;
                        this.lastValue = value;
                    }
                }
                return this.instance;
            }
        };
    }

    public static <T> Supplier<Boolean> compose(final Supplier<T> input, final Predicate<T> predicate) {
        return new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                return predicate.test(input.get());
            }
        };
    }
}

