/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl.path;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableInt;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.api.map.primitive.MutableIntObjectMap;
import org.eclipse.collections.impl.map.mutable.primitive.IntObjectHashMap;
import org.neo4j.collection.trackable.HeapTrackingArrayList;
import org.neo4j.collection.trackable.HeapTrackingCollections;
import org.neo4j.collection.trackable.HeapTrackingUnifiedMap;
import org.neo4j.collection.trackable.HeapTrackingUnifiedSet;
import org.neo4j.cypher.internal.runtime.ClosingIterator;
import org.neo4j.graphalgo.EvaluationContext;
import org.neo4j.graphalgo.PathFinder;
import org.neo4j.graphalgo.impl.util.PathImpl;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PathExpander;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.traversal.BranchState;
import org.neo4j.graphdb.traversal.TraversalMetadata;
import org.neo4j.internal.helpers.collection.IterableWrapper;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.helpers.collection.NestingResourceIterator;
import org.neo4j.internal.helpers.collection.PrefetchingResourceIterator;
import org.neo4j.internal.helpers.collection.ResourceClosingIterator;
import org.neo4j.kernel.impl.core.NodeEntity;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.memory.DefaultScopedMemoryTracker;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.monitoring.Monitors;

public class ShortestPath
implements PathFinder<Path> {
    public final int NULL = -1;
    private final int maxDepth;
    private final int maxResultCount;
    private final PathExpander expander;
    private Metadata lastMetadata;
    private ShortestPathPredicate predicate;
    private final EvaluationContext context;
    private DataMonitor dataMonitor;
    private MemoryTracker memoryTracker;
    private static final long DIRECTION_DATA_SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(DirectionData.class);

    public ShortestPath(EvaluationContext context, int maxDepth, PathExpander expander) {
        this(context, maxDepth, expander, Integer.MAX_VALUE, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
    }

    public ShortestPath(EvaluationContext context, int maxDepth, PathExpander expander, ShortestPathPredicate predicate, MemoryTracker memoryTracker) {
        this(context, maxDepth, expander, Integer.MAX_VALUE, memoryTracker);
        this.predicate = predicate;
    }

    public ShortestPath(EvaluationContext context, int maxDepth, PathExpander expander, int maxResultCount) {
        this(context, maxDepth, expander, maxResultCount, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
    }

    public ShortestPath(EvaluationContext context, int maxDepth, PathExpander expander, int maxResultCount, MemoryTracker memoryTracker) {
        this.context = context;
        this.maxDepth = maxDepth;
        this.expander = expander;
        this.maxResultCount = maxResultCount;
        this.memoryTracker = new DefaultScopedMemoryTracker(memoryTracker);
    }

    @Override
    public Iterable<Path> findAllPaths(Node start, Node end) {
        return this.internalPaths(start, end, false);
    }

    public ClosingIterator<Path> findAllPathsAutoCloseableIterator(final Node start, final Node end) {
        return new ClosingIterator(){
            Iterator<Path> inner;
            {
                this.inner = ShortestPath.this.internalPaths(start, end, false).iterator();
            }

            public void closeMore() {
                this.inner = null;
                ShortestPath.this.memoryTracker.reset();
            }

            public boolean innerHasNext() {
                return this.inner.hasNext();
            }

            public Path next() {
                if (this.inner == null) {
                    throw new NoSuchElementException();
                }
                return this.inner.next();
            }
        };
    }

    @Override
    public Path findSinglePath(Node start, Node end) {
        Iterator<Path> paths = this.internalPaths(start, end, true).iterator();
        Path path = paths.hasNext() ? paths.next() : null;
        this.memoryTracker.reset();
        return path;
    }

    private void resolveMonitor() {
        if (this.dataMonitor == null) {
            GraphDatabaseService service = this.context.databaseService();
            Monitors monitors = (Monitors)((GraphDatabaseFacade)service).getDependencyResolver().resolveDependency(Monitors.class);
            this.dataMonitor = (DataMonitor)monitors.newMonitor(DataMonitor.class, new String[0]);
        }
    }

    private Iterable<Path> internalPaths(Node start, Node end, boolean stopAsap) {
        this.lastMetadata = new Metadata();
        if (start.equals((Object)end)) {
            return this.filterPaths(Collections.singletonList(PathImpl.singular(start)));
        }
        Hits hits = new Hits();
        MutableInt sharedFrozenDepth = new MutableInt(-1);
        MutableBoolean sharedStop = new MutableBoolean();
        MutableInt sharedCurrentDepth = new MutableInt(0);
        try (DirectionData startData = new DirectionData(start, sharedFrozenDepth, sharedStop, sharedCurrentDepth, this.expander, this.memoryTracker);){
            DirectionData endData = new DirectionData(end, sharedFrozenDepth, sharedStop, sharedCurrentDepth, this.expander.reverse(), this.memoryTracker);
            try {
                while (startData.hasNext() || endData.hasNext()) {
                    this.goOneStep(startData, endData, hits, startData, stopAsap);
                    this.goOneStep(endData, startData, hits, startData, stopAsap);
                }
                Collection<Hit> least = hits.least();
                List<Path> list = least != null ? this.filterPaths(ShortestPath.hitsToPaths(least, start, end, stopAsap, this.maxResultCount, this.memoryTracker)) : Collections.emptyList();
                endData.close();
                return list;
            }
            catch (Throwable throwable) {
                try {
                    endData.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    @Override
    public TraversalMetadata metadata() {
        return this.lastMetadata;
    }

    private void goOneStep(DirectionData directionData, DirectionData otherSide, Hits hits, DirectionData startSide, boolean stopAsap) {
        if (!directionData.hasNext()) {
            otherSide.finishCurrentLayerThenStop = true;
            return;
        }
        Node nextNode = (Node)directionData.next();
        LevelData otherSideHit = (LevelData)otherSide.visitedNodes.get((Object)nextNode);
        if (otherSideHit != null) {
            int depth = directionData.currentDepth + otherSideHit.depth;
            if (directionData.sharedFrozenDepth.intValue() == -1) {
                directionData.sharedFrozenDepth.setValue(depth);
            }
            if (depth <= directionData.sharedFrozenDepth.intValue()) {
                Node end;
                directionData.haveFoundSomething = true;
                if (depth < directionData.sharedFrozenDepth.intValue()) {
                    directionData.sharedFrozenDepth.setValue(depth);
                    otherSide.stop = true;
                }
                DirectionData startSideData = directionData == startSide ? directionData : otherSide;
                DirectionData endSideData = directionData == startSide ? otherSide : directionData;
                Hit hit = new Hit(startSideData, endSideData, nextNode);
                Node start = startSide.startNode;
                Node node = end = startSide == directionData ? otherSide.startNode : directionData.startNode;
                if (!stopAsap || !this.filterPaths(ShortestPath.hitToPaths(hit, start, end, stopAsap)).isEmpty()) {
                    if (hits.add(hit, depth) >= this.maxResultCount) {
                        directionData.stop = true;
                        otherSide.stop = true;
                        ++this.lastMetadata.paths;
                    } else if (stopAsap) {
                        if (otherSide.stop) {
                            return;
                        }
                        directionData.stop = true;
                    }
                } else {
                    directionData.haveFoundSomething = false;
                    directionData.sharedFrozenDepth.setValue(-1);
                    otherSide.stop = false;
                }
            }
        }
    }

    private void monitorData(DirectionData directionData, DirectionData otherSide, Node connectingNode) {
        this.resolveMonitor();
        if (this.dataMonitor != null) {
            this.dataMonitor.monitorData((MutableMap<Node, LevelData>)directionData.visitedNodes, (Iterable<Node>)directionData.nextNodes, (MutableMap<Node, LevelData>)otherSide.visitedNodes, (Iterable<Node>)otherSide.nextNodes, connectingNode);
        }
    }

    private <T extends Path> Collection<T> filterPaths(Collection<T> paths) {
        if (this.predicate == null) {
            return paths;
        }
        ArrayList<Path> filteredPaths = new ArrayList<Path>();
        for (Path path : paths) {
            if (!this.predicate.test(path)) continue;
            filteredPaths.add(path);
        }
        return filteredPaths;
    }

    protected Node filterNextLevelNodes(Node nextNode) {
        return nextNode;
    }

    private static Collection<Path> hitsToPaths(Collection<Hit> depthHits, Node start, Node end, boolean stopAsap, int maxResultCount, MemoryTracker memoryTracker) {
        HeapTrackingUnifiedSet paths = HeapTrackingCollections.newSet((MemoryTracker)memoryTracker);
        block0: for (Hit hit : depthHits) {
            for (PathImpl path : ShortestPath.hitToPaths(hit, start, end, stopAsap)) {
                memoryTracker.allocateHeap(path.estimatedHeapUsage());
                paths.add(path);
                if (paths.size() < maxResultCount) continue;
                continue block0;
            }
        }
        return paths;
    }

    private static Collection<PathImpl> hitToPaths(Hit hit, Node start, Node end, boolean stopAsap) {
        ArrayList<PathImpl> paths = new ArrayList<PathImpl>();
        Iterable<List<Relationship>> startPaths = ShortestPath.getPaths(hit.connectingNode, hit.start, stopAsap);
        Iterable<List<Relationship>> endPaths = ShortestPath.getPaths(hit.connectingNode, hit.end, stopAsap);
        for (List<Relationship> startPath : startPaths) {
            PathImpl.Builder startBuilder = ShortestPath.toBuilder(start, startPath);
            for (List<Relationship> endPath : endPaths) {
                PathImpl.Builder endBuilder = ShortestPath.toBuilder(end, endPath);
                PathImpl path = startBuilder.build(endBuilder);
                paths.add(path);
            }
        }
        return paths;
    }

    private static Iterable<List<Relationship>> getPaths(Node connectingNode, DirectionData data, boolean stopAsap) {
        LevelData levelData = (LevelData)data.visitedNodes.get((Object)connectingNode);
        if (levelData.depth == 0) {
            ArrayList<List<Relationship>> result = new ArrayList<List<Relationship>>();
            result.add(new LinkedList());
            return result;
        }
        ArrayList<PathData> set = new ArrayList<PathData>();
        for (Relationship rel : levelData.relsToHere) {
            set.add(new PathData(connectingNode, new LinkedList<Relationship>(Arrays.asList(rel))));
            if (stopAsap) break;
        }
        for (int i = 0; i < levelData.depth - 1; ++i) {
            ArrayList<PathData> nextSet = new ArrayList<PathData>();
            block2: for (PathData entry : set) {
                Node otherNode = entry.rels.getFirst().getOtherNode(entry.node);
                LevelData otherLevelData = (LevelData)data.visitedNodes.get((Object)otherNode);
                int counter = 0;
                for (Relationship rel : otherLevelData.relsToHere) {
                    LinkedList<Relationship> rels = ++counter == otherLevelData.relsToHere.length ? entry.rels : new LinkedList<Relationship>(entry.rels);
                    rels.addFirst(rel);
                    nextSet.add(new PathData(otherNode, rels));
                    if (stopAsap) continue block2;
                }
            }
            set = nextSet;
        }
        return new IterableWrapper<List<Relationship>, PathData>(set){

            protected List<Relationship> underlyingObjectToObject(PathData object) {
                return object.rels;
            }
        };
    }

    private static PathImpl.Builder toBuilder(Node startNode, List<Relationship> rels) {
        PathImpl.Builder builder = new PathImpl.Builder(startNode);
        for (Relationship rel : rels) {
            builder = builder.push(rel);
        }
        return builder;
    }

    public static interface ShortestPathPredicate {
        public boolean test(Path var1);
    }

    public static interface DataMonitor {
        public void monitorData(MutableMap<Node, LevelData> var1, Iterable<Node> var2, MutableMap<Node, LevelData> var3, Iterable<Node> var4, Node var5);
    }

    private static class Metadata
    implements TraversalMetadata {
        private int rels;
        private int paths;

        private Metadata() {
        }

        public int getNumberOfPathsReturned() {
            return this.paths;
        }

        public int getNumberOfRelationshipsTraversed() {
            return this.rels;
        }
    }

    private static class Hits {
        private final MutableIntObjectMap<Collection<Hit>> hits = new IntObjectHashMap();
        private int lowestDepth;
        private int totalHitCount;

        private Hits() {
        }

        int add(Hit hit, int atDepth) {
            Collection depthHits = (Collection)this.hits.getIfAbsentPut(atDepth, HashSet::new);
            if (depthHits.add(hit)) {
                ++this.totalHitCount;
            }
            if (this.lowestDepth == 0 || atDepth < this.lowestDepth) {
                this.lowestDepth = atDepth;
            }
            return this.totalHitCount;
        }

        Collection<Hit> least() {
            return (Collection)this.hits.get(this.lowestDepth);
        }
    }

    private class DirectionData
    extends PrefetchingResourceIterator<Node> {
        private boolean finishCurrentLayerThenStop;
        private final Node startNode;
        private int currentDepth;
        private ResourceIterator<Relationship> nextRelationships;
        private final HeapTrackingArrayList<Node> nextNodes;
        private final HeapTrackingUnifiedMap<Node, LevelData> visitedNodes;
        private final DirectionDataPath lastPath;
        private final MutableInt sharedFrozenDepth;
        private final MutableBoolean sharedStop;
        private final MutableInt sharedCurrentDepth;
        private boolean haveFoundSomething;
        private boolean stop;
        private final PathExpander expander;

        DirectionData(Node startNode, MutableInt sharedFrozenDepth, MutableBoolean sharedStop, MutableInt sharedCurrentDepth, PathExpander expander, MemoryTracker memoryTracker) {
            this.startNode = startNode;
            this.visitedNodes = HeapTrackingCollections.newMap((MemoryTracker)memoryTracker);
            this.nextNodes = HeapTrackingArrayList.newArrayList((MemoryTracker)memoryTracker);
            memoryTracker.allocateHeap(LevelData.SHALLOW_SIZE + NodeEntity.SHALLOW_SIZE + DIRECTION_DATA_SHALLOW_SIZE);
            this.visitedNodes.put((Object)startNode, (Object)new LevelData(null, 0));
            this.nextNodes.add((Object)startNode);
            this.sharedFrozenDepth = sharedFrozenDepth;
            this.sharedStop = sharedStop;
            this.sharedCurrentDepth = sharedCurrentDepth;
            this.expander = expander;
            this.lastPath = new DirectionDataPath(startNode);
            if (sharedCurrentDepth.intValue() < ShortestPath.this.maxDepth) {
                this.prepareNextLevel();
            } else {
                this.nextRelationships = Iterators.emptyResourceIterator();
            }
        }

        private void prepareNextLevel() {
            HeapTrackingArrayList nodesToIterate = this.nextNodes.clone();
            this.nextNodes.clear();
            this.lastPath.setLength(this.currentDepth);
            this.closeRelationshipsIterator();
            this.nextRelationships = new NestingResourceIterator<Relationship, Node>(nodesToIterate.autoClosingIterator()){

                protected ResourceIterator<Relationship> createNestedIterator(Node node) {
                    DirectionData.this.lastPath.setEndNode(node);
                    return ResourceClosingIterator.fromResourceIterable((ResourceIterable)DirectionData.this.expander.expand((Path)DirectionData.this.lastPath, BranchState.NO_STATE));
                }
            };
            ++this.currentDepth;
            this.sharedCurrentDepth.increment();
        }

        private void closeRelationshipsIterator() {
            if (this.nextRelationships != null) {
                this.nextRelationships.close();
            }
        }

        public void close() {
            this.nextNodes.close();
            this.visitedNodes.close();
            this.closeRelationshipsIterator();
        }

        protected Node fetchNextOrNull() {
            Relationship nextRel;
            while ((nextRel = this.fetchNextRelOrNull()) != null) {
                Node result = nextRel.getOtherNode(this.lastPath.endNode());
                if (ShortestPath.this.filterNextLevelNodes(result) == null) continue;
                ++ShortestPath.this.lastMetadata.rels;
                LevelData levelData = (LevelData)this.visitedNodes.get((Object)result);
                if (levelData == null) {
                    ShortestPath.this.memoryTracker.allocateHeap(LevelData.SHALLOW_SIZE + NodeEntity.SHALLOW_SIZE + HeapEstimator.sizeOfLongArray((int)1));
                    levelData = new LevelData(nextRel, this.currentDepth);
                    this.visitedNodes.put((Object)result, (Object)levelData);
                    this.nextNodes.add((Object)result);
                    return result;
                }
                if (this.currentDepth != levelData.depth) continue;
                ShortestPath.this.memoryTracker.allocateHeap(8L);
                levelData.addRel(nextRel);
            }
            return null;
        }

        private boolean canGoDeeper() {
            return this.sharedFrozenDepth.intValue() == -1 && this.sharedCurrentDepth.intValue() < ShortestPath.this.maxDepth && !this.finishCurrentLayerThenStop;
        }

        private Relationship fetchNextRelOrNull() {
            boolean hasComeTooFarEmptyHanded;
            if (this.stop || this.sharedStop.booleanValue()) {
                return null;
            }
            boolean bl = hasComeTooFarEmptyHanded = this.sharedFrozenDepth.intValue() != -1 && this.sharedCurrentDepth.intValue() > this.sharedFrozenDepth.intValue() && !this.haveFoundSomething;
            if (hasComeTooFarEmptyHanded) {
                return null;
            }
            if (!this.nextRelationships.hasNext() && this.canGoDeeper()) {
                this.prepareNextLevel();
            }
            return this.nextRelationships.hasNext() ? (Relationship)this.nextRelationships.next() : null;
        }
    }

    public static class LevelData {
        public static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(LevelData.class);
        private Relationship[] relsToHere;
        public final int depth;

        LevelData(Relationship relToHere, int depth) {
            if (relToHere != null) {
                this.addRel(relToHere);
            }
            this.depth = depth;
        }

        void addRel(Relationship rel) {
            Relationship[] newRels;
            if (this.relsToHere == null) {
                newRels = new Relationship[1];
            } else {
                newRels = new Relationship[this.relsToHere.length + 1];
                System.arraycopy(this.relsToHere, 0, newRels, 0, this.relsToHere.length);
            }
            newRels[newRels.length - 1] = rel;
            this.relsToHere = newRels;
        }
    }

    private static class Hit {
        private final DirectionData start;
        private final DirectionData end;
        private final Node connectingNode;

        Hit(DirectionData start, DirectionData end, Node connectingNode) {
            this.start = start;
            this.end = end;
            this.connectingNode = connectingNode;
        }

        public int hashCode() {
            return this.connectingNode.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Hit o = (Hit)obj;
            return this.connectingNode.equals((Object)o.connectingNode);
        }
    }

    private static class PathData {
        private final LinkedList<Relationship> rels;
        private final Node node;

        PathData(Node node, LinkedList<Relationship> rels) {
            this.rels = rels;
            this.node = node;
        }
    }

    private static class DirectionDataPath
    implements Path {
        private final Node startNode;
        private Node endNode;
        private int length;

        DirectionDataPath(Node startNode) {
            this.startNode = startNode;
            this.endNode = startNode;
            this.length = 0;
        }

        void setEndNode(Node endNode) {
            this.endNode = endNode;
        }

        void setLength(int length) {
            this.length = length;
        }

        public Node startNode() {
            return this.startNode;
        }

        public Node endNode() {
            return this.endNode;
        }

        public Relationship lastRelationship() {
            throw new UnsupportedOperationException();
        }

        public Iterable<Relationship> relationships() {
            throw new UnsupportedOperationException();
        }

        public Iterable<Relationship> reverseRelationships() {
            throw new UnsupportedOperationException();
        }

        public Iterable<Node> nodes() {
            throw new UnsupportedOperationException();
        }

        public Iterable<Node> reverseNodes() {
            throw new UnsupportedOperationException();
        }

        public int length() {
            return this.length;
        }

        public Iterator<Entity> iterator() {
            throw new UnsupportedOperationException();
        }
    }
}

