/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl.shortestpath;

import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.neo4j.graphalgo.CostAccumulator;
import org.neo4j.graphalgo.CostEvaluator;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;

public class FloydWarshall<CostType> {
    protected CostType startCost;
    protected CostType infinitelyBad;
    protected Direction relationDirection;
    protected CostEvaluator<CostType> costEvaluator;
    protected CostAccumulator<CostType> costAccumulator;
    protected Comparator<CostType> costComparator;
    protected Set<Node> nodeSet;
    protected Set<Relationship> relationshipSet;
    CostType[][] costMatrix;
    Integer[][] predecessors;
    Map<Node, Integer> nodeIndexes;
    Node[] IndexedNodes;
    protected boolean doneCalculation;

    public FloydWarshall(CostType startCost, CostType infinitelyBad, Direction relationDirection, CostEvaluator<CostType> costEvaluator, CostAccumulator<CostType> costAccumulator, Comparator<CostType> costComparator, Set<Node> nodeSet, Set<Relationship> relationshipSet) {
        this.startCost = startCost;
        this.infinitelyBad = infinitelyBad;
        this.relationDirection = relationDirection;
        this.costEvaluator = costEvaluator;
        this.costAccumulator = costAccumulator;
        this.costComparator = costComparator;
        this.nodeSet = nodeSet;
        this.relationshipSet = relationshipSet;
    }

    public void reset() {
        this.doneCalculation = false;
    }

    public void calculate() {
        if (this.doneCalculation) {
            return;
        }
        this.doneCalculation = true;
        int n = this.nodeSet.size();
        this.costMatrix = new Object[n][n];
        this.predecessors = new Integer[n][n];
        this.IndexedNodes = new Node[n];
        this.nodeIndexes = new HashMap<Node, Integer>();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                this.costMatrix[i][j] = this.infinitelyBad;
            }
            this.costMatrix[i][i] = this.startCost;
        }
        int nodeIndex = 0;
        for (Node node : this.nodeSet) {
            this.nodeIndexes.put(node, nodeIndex);
            this.IndexedNodes[nodeIndex] = node;
            ++nodeIndex;
        }
        for (Relationship relationship : this.relationshipSet) {
            Integer i1 = this.nodeIndexes.get(relationship.getStartNode());
            Integer i2 = this.nodeIndexes.get(relationship.getEndNode());
            if (i1 == null || i2 == null) continue;
            if (this.relationDirection.equals((Object)Direction.BOTH) || this.relationDirection.equals((Object)Direction.OUTGOING)) {
                this.costMatrix[i1.intValue()][i2.intValue()] = this.costEvaluator.getCost(relationship, Direction.OUTGOING);
                this.predecessors[i1.intValue()][i2.intValue()] = i1;
            }
            if (!this.relationDirection.equals((Object)Direction.BOTH) && !this.relationDirection.equals((Object)Direction.INCOMING)) continue;
            this.costMatrix[i2.intValue()][i1.intValue()] = this.costEvaluator.getCost(relationship, Direction.INCOMING);
            this.predecessors[i2.intValue()][i1.intValue()] = i2;
        }
        for (int v = 0; v < n; ++v) {
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n; ++j) {
                    CostType alternative = this.costAccumulator.addCosts(this.costMatrix[i][v], this.costMatrix[v][j]);
                    if (this.costComparator.compare(this.costMatrix[i][j], alternative) <= 0) continue;
                    this.costMatrix[i][j] = alternative;
                    this.predecessors[i][j] = this.predecessors[v][j];
                }
            }
        }
    }

    public CostType getCost(Node node1, Node node2) {
        this.calculate();
        return this.costMatrix[this.nodeIndexes.get(node1)][this.nodeIndexes.get(node2)];
    }

    public List<Node> getPath(Node startNode, Node targetNode) {
        this.calculate();
        LinkedList<Node> path = new LinkedList<Node>();
        int index = this.nodeIndexes.get(targetNode);
        int startIndex = this.nodeIndexes.get(startNode);
        Node n = targetNode;
        while (!n.equals((Object)startNode)) {
            path.addFirst(n);
            index = this.predecessors[startIndex][index];
            n = this.IndexedNodes[index];
        }
        path.addFirst(n);
        return path;
    }
}

