/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl.util;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.PriorityQueue;

public class PriorityMap<E, K, P> {
    private static final Converter SELF_KEY = source -> source;
    private final Converter<K, E> keyFunction;
    private final Comparator<P> order;
    private final boolean onlyKeepBestPriorities;
    private final Map<K, Node<E, P>> map = new HashMap<K, Node<E, P>>();
    private final PriorityQueue<Node<E, P>> queue = new PriorityQueue(11, new Comparator<Node<E, P>>(){

        @Override
        public int compare(Node<E, P> o1, Node<E, P> o2) {
            return PriorityMap.this.order.compare(o1.head.priority, o2.head.priority);
        }
    });

    public static <K, P> PriorityMap<K, K, P> withSelfKey(Comparator<P> priority) {
        return new PriorityMap(SELF_KEY, priority, true);
    }

    public static <E, K, P extends Comparable<P>> PriorityMap<E, K, P> withNaturalOrder(Converter<K, E> key) {
        return PriorityMap.withNaturalOrder(key, false);
    }

    public static <E, K, P extends Comparable<P>> PriorityMap<E, K, P> withNaturalOrder(Converter<K, E> key, boolean reversed) {
        return PriorityMap.withNaturalOrder(key, reversed, true);
    }

    public static <E, K, P extends Comparable<P>> PriorityMap<E, K, P> withNaturalOrder(Converter<K, E> key, boolean reversed, boolean onlyKeepBestPriorities) {
        NaturalPriority priority = new NaturalPriority(reversed);
        return new PriorityMap(key, priority, onlyKeepBestPriorities);
    }

    public static <K, P extends Comparable<P>> PriorityMap<K, K, P> withSelfKeyNaturalOrder() {
        return PriorityMap.withSelfKeyNaturalOrder(false);
    }

    public static <K, P extends Comparable<P>> PriorityMap<K, K, P> withSelfKeyNaturalOrder(boolean reversed) {
        return PriorityMap.withSelfKeyNaturalOrder(reversed, true);
    }

    public static <K, P extends Comparable<P>> PriorityMap<K, K, P> withSelfKeyNaturalOrder(boolean reversed, boolean onlyKeepBestPriorities) {
        NaturalPriority priority = new NaturalPriority(reversed);
        return new PriorityMap(SELF_KEY, priority, onlyKeepBestPriorities);
    }

    public PriorityMap(Converter<K, E> key, Comparator<P> priority, boolean onlyKeepBestPriorities) {
        this.keyFunction = key;
        this.order = priority;
        this.onlyKeepBestPriorities = onlyKeepBestPriorities;
    }

    public boolean put(E entity, P priority) {
        K key = this.keyFunction.convert(entity);
        Node<E, P> node = this.map.get(key);
        boolean result = false;
        if (node != null) {
            if (this.onlyKeepBestPriorities) {
                if (this.order.compare(priority, ((Node)node).head.priority) == 0) {
                    ((Node)node).head = new Link<E, P>(entity, priority, ((Node)node).head);
                    result = true;
                } else if (this.order.compare(priority, ((Node)node).head.priority) < 0) {
                    this.queue.remove(node);
                    this.putNew(entity, priority, key);
                    result = true;
                }
            } else if (this.order.compare(priority, ((Node)node).head.priority) < 0) {
                ((Node)node).head = new Link<E, P>(entity, priority, ((Node)node).head);
                this.reinsert(node);
                result = true;
            } else {
                Link link;
                Link prev = link = ((Node)node).head;
                link = link.next;
                while (link != null) {
                    if (this.order.compare(priority, link.priority) <= 0) {
                        prev.next = (Link)new Link<E, P>(entity, priority, link);
                        result = true;
                        break;
                    }
                    prev = link;
                    link = link.next;
                }
                if (!result) {
                    prev.next = (Link)new Link<E, P>(entity, priority, null);
                    result = true;
                }
            }
        } else {
            this.putNew(entity, priority, key);
            result = true;
        }
        return result;
    }

    private void putNew(E entity, P priority, K key) {
        Node<E, P> node = new Node<E, P>(new Link<E, P>(entity, priority, null));
        this.map.put(key, node);
        this.queue.add(node);
    }

    private void reinsert(Node<E, P> node) {
        this.queue.remove(node);
        this.queue.add(node);
    }

    public P get(K key) {
        Node<E, P> node = this.map.get(key);
        return (P)(node != null ? ((Node)node).head.priority : null);
    }

    public Entry<E, P> pop() {
        Node<E, P> node = this.queue.peek();
        Entry<E, P> result = null;
        if (node == null) {
            return null;
        }
        if (((Node)node).head.next == null) {
            node = this.queue.poll();
            this.map.remove(this.keyFunction.convert(((Node)node).head.entity));
            result = new Entry<E, P>(node);
        } else {
            result = new Entry<E, P>(node);
            ((Node)node).head = ((Node)node).head.next;
            if (this.order.compare(((Entry)result).priority, ((Node)node).head.priority) != 0) {
                this.reinsert(node);
            }
        }
        return result;
    }

    public Entry<E, P> peek() {
        Node<E, P> node = this.queue.peek();
        if (node == null) {
            return null;
        }
        return new Entry<E, P>(node);
    }

    private static class Link<E, P> {
        private final E entity;
        private final P priority;
        private Link<E, P> next;

        Link(E entity, P priority, Link<E, P> next) {
            this.entity = entity;
            this.priority = priority;
            this.next = next;
        }
    }

    private static class Node<E, P> {
        private Link<E, P> head;

        Node(Link<E, P> head) {
            this.head = head;
        }
    }

    private static class NaturalPriority<P extends Comparable<P>>
    implements Comparator<P> {
        private final boolean reversed;

        NaturalPriority(boolean reversed) {
            this.reversed = reversed;
        }

        @Override
        public int compare(P o1, P o2) {
            return this.reversed ? o2.compareTo(o1) : o1.compareTo(o2);
        }
    }

    public static final class Entry<E, P> {
        private final E entity;
        private final P priority;

        private Entry(E entity, P priority) {
            this.entity = entity;
            this.priority = priority;
        }

        Entry(Node<E, P> node) {
            this(((Node)node).head.entity, ((Node)node).head.priority);
        }

        public E getEntity() {
            return this.entity;
        }

        public P getPriority() {
            return this.priority;
        }
    }

    public static interface Converter<T, S> {
        public T convert(S var1);
    }
}

