/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl.shortestpath;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.neo4j.graphalgo.CostAccumulator;
import org.neo4j.graphalgo.CostEvaluator;
import org.neo4j.graphalgo.impl.shortestpath.DijkstraPriorityQueue;
import org.neo4j.graphalgo.impl.shortestpath.DijkstraPriorityQueueFibonacciImpl;
import org.neo4j.graphalgo.impl.shortestpath.SingleSourceSingleSinkShortestPath;
import org.neo4j.graphalgo.impl.shortestpath.Util;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterable;

public class Dijkstra<CostType>
implements SingleSourceSingleSinkShortestPath<CostType> {
    protected CostType startCost;
    protected Node startNode;
    protected Node endNode;
    protected RelationshipType[] costRelationTypes;
    protected Direction relationDirection;
    protected CostEvaluator<CostType> costEvaluator;
    protected CostAccumulator<CostType> costAccumulator;
    protected Comparator<CostType> costComparator;
    protected boolean calculateAllShortestPaths;
    protected long maxRelationShipsToTraverse = -1L;
    protected long numberOfTraversedRelationShips;
    protected long maxNodesToTraverse = -1L;
    protected long numberOfNodesTraversed;
    protected CostType maxCost;
    protected boolean doneCalculation;
    protected Set<Node> foundPathsMiddleNodes;
    protected CostType foundPathsCost;
    protected Map<Node, List<Relationship>> predecessors1 = new HashMap<Node, List<Relationship>>();
    protected Map<Node, List<Relationship>> predecessors2 = new HashMap<Node, List<Relationship>>();

    protected boolean limitReached() {
        return this.maxRelationShipsToTraverse >= 0L && this.numberOfTraversedRelationShips >= this.maxRelationShipsToTraverse || this.maxNodesToTraverse >= 0L && this.numberOfNodesTraversed >= this.maxNodesToTraverse;
    }

    protected boolean limitReached(CostType cost1, CostType cost2) {
        CostType totalCost;
        if (this.maxCost != null && this.costComparator.compare(totalCost = this.costAccumulator.addCosts(cost1, cost2), this.maxCost) > 0) {
            this.foundPathsMiddleNodes = null;
            this.foundPathsCost = null;
            return true;
        }
        return false;
    }

    @Override
    public void reset() {
        this.doneCalculation = false;
        this.foundPathsMiddleNodes = null;
        this.predecessors1 = new HashMap<Node, List<Relationship>>();
        this.predecessors2 = new HashMap<Node, List<Relationship>>();
        this.numberOfTraversedRelationShips = 0L;
        this.numberOfNodesTraversed = 0L;
    }

    public Dijkstra(CostType startCost, Node startNode, Node endNode, CostEvaluator<CostType> costEvaluator, CostAccumulator<CostType> costAccumulator, Comparator<CostType> costComparator, Direction relationDirection, RelationshipType ... costRelationTypes) {
        this.startCost = startCost;
        this.startNode = startNode;
        this.endNode = endNode;
        this.costRelationTypes = costRelationTypes;
        this.relationDirection = relationDirection;
        this.costEvaluator = costEvaluator;
        this.costAccumulator = costAccumulator;
        this.costComparator = costComparator;
    }

    public boolean calculateMultiple() {
        if (!this.calculateAllShortestPaths) {
            this.reset();
            this.calculateAllShortestPaths = true;
        }
        return this.calculate();
    }

    public boolean calculate() {
        if (this.startNode == null || this.endNode == null) {
            throw new RuntimeException("Start or end node undefined.");
        }
        if (this.doneCalculation) {
            return true;
        }
        this.doneCalculation = true;
        if (this.startNode.equals(this.endNode)) {
            this.foundPathsMiddleNodes = new HashSet<Node>();
            this.foundPathsMiddleNodes.add(this.startNode);
            this.foundPathsCost = this.costAccumulator.addCosts(this.startCost, this.startCost);
            return true;
        }
        HashMap seen1 = new HashMap();
        HashMap seen2 = new HashMap();
        HashMap dists1 = new HashMap();
        HashMap dists2 = new HashMap();
        DijkstraIterator iter1 = new DijkstraIterator(this.startNode, this.predecessors1, seen1, seen2, dists1, dists2, false);
        DijkstraIterator iter2 = new DijkstraIterator(this.endNode, this.predecessors2, seen2, seen1, dists2, dists1, true);
        Node node1 = null;
        Node node2 = null;
        while (!(!iter1.hasNext() || !iter2.hasNext() || this.limitReached() || iter1.hasNext() && (node1 = iter1.next()) == null || this.limitReached() || !iter1.isDone() && iter2.hasNext() && (node2 = iter2.next()) == null || this.limitReached(seen1.get(node1), seen2.get(node2)))) {
            if (!iter1.isDone() && !iter2.isDone()) continue;
            return true;
        }
        return false;
    }

    @Override
    public CostType getCost() {
        if (this.startNode == null || this.endNode == null) {
            throw new RuntimeException("Start or end node undefined.");
        }
        this.calculate();
        return this.foundPathsCost;
    }

    @Override
    public List<List<Entity>> getPaths() {
        if (this.startNode == null || this.endNode == null) {
            throw new RuntimeException("Start or end node undefined.");
        }
        this.calculateMultiple();
        if (this.foundPathsMiddleNodes == null || this.foundPathsMiddleNodes.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<List<Entity>> paths = new LinkedList<List<Entity>>();
        for (Node middleNode : this.foundPathsMiddleNodes) {
            List<List<Entity>> paths1 = Util.constructAllPathsToNode(middleNode, this.predecessors1, true, false);
            List<List<Entity>> paths2 = Util.constructAllPathsToNode(middleNode, this.predecessors2, false, true);
            for (List<Entity> part1 : paths1) {
                for (List<Entity> part2 : paths2) {
                    LinkedList<Entity> path = new LinkedList<Entity>();
                    path.addAll(part1);
                    path.addAll(part2);
                    paths.add(path);
                }
            }
        }
        return paths;
    }

    @Override
    public List<List<Node>> getPathsAsNodes() {
        if (this.startNode == null || this.endNode == null) {
            throw new RuntimeException("Start or end node undefined.");
        }
        this.calculateMultiple();
        if (this.foundPathsMiddleNodes == null || this.foundPathsMiddleNodes.isEmpty()) {
            return null;
        }
        LinkedList<List<Node>> paths = new LinkedList<List<Node>>();
        for (Node middleNode : this.foundPathsMiddleNodes) {
            List<List<Node>> paths1 = Util.constructAllPathsToNodeAsNodes(middleNode, this.predecessors1, true, false);
            List<List<Node>> paths2 = Util.constructAllPathsToNodeAsNodes(middleNode, this.predecessors2, false, true);
            for (List<Node> part1 : paths1) {
                for (List<Node> part2 : paths2) {
                    LinkedList<Node> path = new LinkedList<Node>();
                    path.addAll(part1);
                    path.addAll(part2);
                    paths.add(path);
                }
            }
        }
        return paths;
    }

    @Override
    public List<List<Relationship>> getPathsAsRelationships() {
        if (this.startNode == null || this.endNode == null) {
            throw new RuntimeException("Start or end node undefined.");
        }
        this.calculateMultiple();
        if (this.foundPathsMiddleNodes == null || this.foundPathsMiddleNodes.isEmpty()) {
            return null;
        }
        LinkedList<List<Relationship>> paths = new LinkedList<List<Relationship>>();
        for (Node middleNode : this.foundPathsMiddleNodes) {
            List<List<Relationship>> paths1 = Util.constructAllPathsToNodeAsRelationships(middleNode, this.predecessors1, false);
            List<List<Relationship>> paths2 = Util.constructAllPathsToNodeAsRelationships(middleNode, this.predecessors2, true);
            for (List<Relationship> part1 : paths1) {
                for (List<Relationship> part2 : paths2) {
                    LinkedList<Relationship> path = new LinkedList<Relationship>();
                    path.addAll(part1);
                    path.addAll(part2);
                    paths.add(path);
                }
            }
        }
        return paths;
    }

    @Override
    public List<Entity> getPath() {
        if (this.startNode == null || this.endNode == null) {
            throw new RuntimeException("Start or end node undefined.");
        }
        this.calculate();
        if (this.foundPathsMiddleNodes == null || this.foundPathsMiddleNodes.isEmpty()) {
            return null;
        }
        Node middleNode = this.foundPathsMiddleNodes.iterator().next();
        LinkedList<Entity> path = new LinkedList<Entity>();
        path.addAll(Util.constructSinglePathToNode(middleNode, this.predecessors1, true, false));
        path.addAll(Util.constructSinglePathToNode(middleNode, this.predecessors2, false, true));
        return path;
    }

    @Override
    public List<Node> getPathAsNodes() {
        if (this.startNode == null || this.endNode == null) {
            throw new RuntimeException("Start or end node undefined.");
        }
        this.calculate();
        if (this.foundPathsMiddleNodes == null || this.foundPathsMiddleNodes.isEmpty()) {
            return null;
        }
        Node middleNode = this.foundPathsMiddleNodes.iterator().next();
        LinkedList<Node> pathNodes = new LinkedList<Node>();
        pathNodes.addAll(Util.constructSinglePathToNodeAsNodes(middleNode, this.predecessors1, true, false));
        pathNodes.addAll(Util.constructSinglePathToNodeAsNodes(middleNode, this.predecessors2, false, true));
        return pathNodes;
    }

    @Override
    public List<Relationship> getPathAsRelationships() {
        if (this.startNode == null || this.endNode == null) {
            throw new RuntimeException("Start or end node undefined.");
        }
        this.calculate();
        if (this.foundPathsMiddleNodes == null || this.foundPathsMiddleNodes.isEmpty()) {
            return null;
        }
        Node middleNode = this.foundPathsMiddleNodes.iterator().next();
        LinkedList<Relationship> path = new LinkedList<Relationship>();
        path.addAll(Util.constructSinglePathToNodeAsRelationships(middleNode, this.predecessors1, false));
        path.addAll(Util.constructSinglePathToNodeAsRelationships(middleNode, this.predecessors2, true));
        return path;
    }

    public void limitMaxRelationShipsToTraverse(long maxRelationShipsToTraverse) {
        this.maxRelationShipsToTraverse = maxRelationShipsToTraverse;
    }

    public void limitMaxNodesToTraverse(long maxNodesToTraverse) {
        this.maxNodesToTraverse = maxNodesToTraverse;
    }

    @Override
    public void setEndNode(Node endNode) {
        this.reset();
        this.endNode = endNode;
    }

    @Override
    public void setStartNode(Node startNode) {
        this.startNode = startNode;
        this.reset();
    }

    @Override
    public Direction getDirection() {
        return this.relationDirection;
    }

    @Override
    public RelationshipType[] getRelationshipTypes() {
        return this.costRelationTypes;
    }

    public void limitMaxCostToTraverse(CostType maxCost) {
        this.maxCost = maxCost;
    }

    protected class DijkstraIterator
    implements Iterator<Node> {
        protected Node startNode;
        protected Map<Node, List<Relationship>> predecessors;
        protected Map<Node, CostType> mySeen;
        protected Map<Node, CostType> otherSeen;
        protected Map<Node, CostType> myDistances;
        protected Map<Node, CostType> otherDistances;
        protected boolean backwards;
        protected DijkstraPriorityQueue<CostType> queue;
        protected boolean oneShortestPathHasBeenFound;
        protected boolean allShortestPathsHasBeenFound;

        public DijkstraIterator(Node startNode, Map<Node, List<Relationship>> predecessors, Map<Node, CostType> mySeen, Map<Node, CostType> otherSeen, Map<Node, CostType> myDistances, Map<Node, CostType> otherDistances, boolean backwards) {
            this.startNode = startNode;
            this.predecessors = predecessors;
            this.mySeen = mySeen;
            this.otherSeen = otherSeen;
            this.myDistances = myDistances;
            this.otherDistances = otherDistances;
            this.backwards = backwards;
            this.InitQueue();
        }

        protected Direction getDirection() {
            if (this.backwards) {
                if (Dijkstra.this.relationDirection.equals((Object)Direction.INCOMING)) {
                    return Direction.OUTGOING;
                }
                if (Dijkstra.this.relationDirection.equals((Object)Direction.OUTGOING)) {
                    return Direction.INCOMING;
                }
            }
            return Dijkstra.this.relationDirection;
        }

        protected void InitQueue() {
            this.queue = new DijkstraPriorityQueueFibonacciImpl(Dijkstra.this.costComparator);
            this.queue.insertValue(this.startNode, Dijkstra.this.startCost);
            this.mySeen.put(this.startNode, Dijkstra.this.startCost);
        }

        @Override
        public boolean hasNext() {
            return !this.queue.isEmpty() && !Dijkstra.this.limitReached();
        }

        @Override
        public void remove() {
        }

        protected void checkForPath(Node currentNode, CostType currentCost, Map<Node, CostType> otherSideDistances) {
            if (otherSideDistances.containsKey(currentNode)) {
                Object otherCost = otherSideDistances.get(currentNode);
                Object newTotalCost = Dijkstra.this.costAccumulator.addCosts(currentCost, otherCost);
                if (Dijkstra.this.foundPathsMiddleNodes == null) {
                    Dijkstra.this.foundPathsMiddleNodes = new HashSet<Node>();
                }
                if (Dijkstra.this.foundPathsMiddleNodes.isEmpty() || Dijkstra.this.costComparator.compare(Dijkstra.this.foundPathsCost, newTotalCost) == 0) {
                    Dijkstra.this.foundPathsCost = newTotalCost;
                    Dijkstra.this.foundPathsMiddleNodes.add(currentNode);
                } else if (Dijkstra.this.costComparator.compare(Dijkstra.this.foundPathsCost, newTotalCost) > 0) {
                    Dijkstra.this.foundPathsMiddleNodes.clear();
                    Dijkstra.this.foundPathsCost = newTotalCost;
                    Dijkstra.this.foundPathsMiddleNodes.add(currentNode);
                }
            }
        }

        @Override
        public Node next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Node currentNode = this.queue.extractMin();
            Object currentCost = this.mySeen.get(currentNode);
            if (this.myDistances.containsKey(currentNode)) {
                return null;
            }
            if (Dijkstra.this.limitReached()) {
                return null;
            }
            ++Dijkstra.this.numberOfNodesTraversed;
            this.myDistances.put(currentNode, currentCost);
            this.checkForPath(currentNode, currentCost, this.otherSeen);
            if (this.otherDistances.containsKey(currentNode)) {
                this.oneShortestPathHasBeenFound = true;
            } else {
                block5: for (RelationshipType costRelationType : Dijkstra.this.costRelationTypes) {
                    try (ResourceIterable relationships = currentNode.getRelationships(this.getDirection(), new RelationshipType[]{costRelationType});){
                        for (Relationship relationship : relationships) {
                            List<Object> predList;
                            if (Dijkstra.this.limitReached()) {
                                continue block5;
                            }
                            ++Dijkstra.this.numberOfTraversedRelationShips;
                            Node target = relationship.getOtherNode(currentNode);
                            if (this.otherDistances.containsKey(target)) continue;
                            boolean backwardsEdge = relationship.getEndNode().equals(currentNode) ^ this.backwards;
                            Object newCost = Dijkstra.this.costAccumulator.addCosts(currentCost, Dijkstra.this.costEvaluator.getCost(relationship, backwardsEdge ? Direction.INCOMING : Direction.OUTGOING));
                            if (this.myDistances.containsKey(target)) {
                                List<Relationship> predList2;
                                List<Relationship> myPredecessors;
                                if (Dijkstra.this.costComparator.compare(this.myDistances.get(target), newCost) > 0) {
                                    throw new RuntimeException("Cycle with negative costs found.");
                                }
                                if (!Dijkstra.this.calculateAllShortestPaths || Dijkstra.this.costComparator.compare(this.myDistances.get(target), newCost) != 0 || (myPredecessors = this.predecessors.get(currentNode)) != null && myPredecessors.contains(relationship) || (predList2 = this.predecessors.get(target)) == null) continue;
                                predList2.add(relationship);
                                continue;
                            }
                            if (!this.mySeen.containsKey(target) || Dijkstra.this.costComparator.compare(this.mySeen.get(target), newCost) > 0) {
                                if (!this.mySeen.containsKey(target)) {
                                    this.queue.insertValue(target, newCost);
                                } else {
                                    this.queue.decreaseValue(target, newCost);
                                }
                                this.mySeen.put(target, newCost);
                                predList = new LinkedList<Relationship>();
                                predList.add(relationship);
                                this.predecessors.put(target, predList);
                                continue;
                            }
                            if (!Dijkstra.this.calculateAllShortestPaths || Dijkstra.this.costComparator.compare(this.mySeen.get(target), newCost) != 0) continue;
                            predList = this.predecessors.get(target);
                            predList.add(relationship);
                        }
                    }
                }
            }
            if (Dijkstra.this.calculateAllShortestPaths && this.oneShortestPathHasBeenFound) {
                this.allShortestPathsHasBeenFound = this.queue.isEmpty() || Dijkstra.this.costComparator.compare(this.mySeen.get(this.queue.peek()), currentCost) > 0;
            }
            return currentNode;
        }

        public boolean isDone() {
            if (!Dijkstra.this.calculateAllShortestPaths) {
                return this.oneShortestPathHasBeenFound;
            }
            return this.allShortestPathsHasBeenFound;
        }
    }
}

