/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl.path;

import org.neo4j.graphalgo.PathFinder;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.traversal.TraversalMetadata;
import org.neo4j.graphdb.traversal.Traverser;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.helpers.collection.LimitingIterable;

public abstract class TraversalPathFinder
implements PathFinder<Path> {
    private Traverser lastTraverser;

    @Override
    public Path findSinglePath(Node start, Node end) {
        return (Path)Iterables.firstOrNull(this.findAllPaths(start, end));
    }

    protected Integer maxResultCount() {
        return null;
    }

    @Override
    public Iterable<Path> findAllPaths(Node start, Node end) {
        this.lastTraverser = this.instantiateTraverser(start, end);
        Integer maxResultCount = this.maxResultCount();
        return maxResultCount != null ? new LimitingIterable((Iterable)this.lastTraverser, maxResultCount.intValue()) : this.lastTraverser;
    }

    protected abstract Traverser instantiateTraverser(Node var1, Node var2);

    @Override
    public TraversalMetadata metadata() {
        if (this.lastTraverser == null) {
            throw new IllegalStateException("No traversal has been made");
        }
        return this.lastTraverser.metadata();
    }
}

