/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import org.neo4j.com.ComException;
import org.neo4j.com.RequestContext;
import org.neo4j.com.Response;
import org.neo4j.graphdb.TransientTransactionFailureException;
import org.neo4j.kernel.ha.com.RequestContextFactory;
import org.neo4j.kernel.ha.com.master.Master;
import org.neo4j.kernel.impl.core.TokenCreator;

public abstract class AbstractTokenCreator
implements TokenCreator {
    private final Master master;
    private final RequestContextFactory requestContextFactory;

    protected AbstractTokenCreator(Master master, RequestContextFactory requestContextFactory) {
        this.master = master;
        this.requestContextFactory = requestContextFactory;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final int getOrCreate(String name) {
        try (Response<Integer> response = this.create(this.master, this.requestContextFactory.newRequestContext(), name);){
            int n = (Integer)response.response();
            return n;
        }
        catch (ComException e) {
            throw new TransientTransactionFailureException("Cannot create identifier for token '" + name + "' on the master " + this.master + ". The master is either down, or we have network connectivity problems", (Throwable)e);
        }
    }

    protected abstract Response<Integer> create(Master var1, RequestContext var2, String var3);
}

