/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.net.URI;
import org.neo4j.cluster.InstanceId;
import org.neo4j.cluster.member.ClusterMemberListener;
import org.neo4j.cluster.protocol.cluster.ClusterConfiguration;
import org.neo4j.cluster.protocol.cluster.ClusterListener;
import org.neo4j.kernel.AvailabilityGuard;
import org.neo4j.kernel.impl.store.StoreId;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class HighAvailabilityLogger
implements ClusterMemberListener,
ClusterListener,
AvailabilityGuard.AvailabilityListener {
    private final Log log;
    private final InstanceId myId;
    private URI myUri;

    public HighAvailabilityLogger(LogProvider logProvider, InstanceId myId) {
        this.log = logProvider.getLog(this.getClass());
        this.myId = myId;
    }

    public void enteredCluster(ClusterConfiguration clusterConfiguration) {
        this.myUri = clusterConfiguration.getUriForId(this.myId);
        this.log.info("Instance %s entered the cluster", new Object[]{this.printId(this.myId, this.myUri)});
    }

    public void leftCluster() {
        this.log.info("Instance %s left the cluster", new Object[]{this.printId(this.myId, this.myUri)});
    }

    public void joinedCluster(InstanceId instanceId, URI member) {
        this.log.info("Instance %s joined the cluster", new Object[]{this.printId(instanceId, member)});
    }

    public void leftCluster(InstanceId instanceId, URI member) {
        this.log.info("Instance %s has left the cluster", new Object[]{this.printId(instanceId, member)});
    }

    public void elected(String role, InstanceId instanceId, URI electedMember) {
        this.log.info("Instance %s was elected as %s", new Object[]{this.printId(instanceId, electedMember), role});
    }

    public void unelected(String role, InstanceId instanceId, URI electedMember) {
        this.log.info("Instance %s was demoted as %s", new Object[]{this.printId(instanceId, electedMember), role});
    }

    public void coordinatorIsElected(InstanceId coordinatorId) {
    }

    public void memberIsAvailable(String role, InstanceId availableId, URI atUri, StoreId storeId) {
        this.log.info("Instance %s is available as %s at %s with %s", new Object[]{this.printId(availableId, atUri), role, atUri.toASCIIString(), storeId});
    }

    public void memberIsUnavailable(String role, InstanceId unavailableId) {
        this.log.info("Instance %s is unavailable as %s", new Object[]{this.printId(unavailableId, null), role});
    }

    public void memberIsFailed(InstanceId instanceId) {
        this.log.info("Instance %s has failed", new Object[]{this.printId(instanceId, null)});
    }

    public void memberIsAlive(InstanceId instanceId) {
        this.log.info("Instance %s is alive", new Object[]{this.printId(instanceId, null)});
    }

    public void available() {
        this.log.info("Database available for write transactions");
    }

    public void unavailable() {
        this.log.info("Write transactions to database disabled");
    }

    private String printId(InstanceId id, URI member) {
        String name = id.instanceNameFromURI(member);
        return name + (id.equals((Object)this.myId) ? " (this server) " : " ");
    }
}

