/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.cluster;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.function.BiFunction;
import org.neo4j.cluster.member.paxos.MemberIsAvailable;
import org.neo4j.helpers.collection.Iterables;

public class HANewSnapshotFunction
implements Serializable,
BiFunction<Iterable<MemberIsAvailable>, MemberIsAvailable, Iterable<MemberIsAvailable>> {
    private static final long serialVersionUID = -8065136460852260734L;

    @Override
    public Iterable<MemberIsAvailable> apply(Iterable<MemberIsAvailable> previousSnapshot, MemberIsAvailable newMessage) {
        if (newMessage.getRole().equals("master")) {
            LinkedList<MemberIsAvailable> result = new LinkedList<MemberIsAvailable>();
            for (MemberIsAvailable existing : previousSnapshot) {
                if (this.isSlave(existing) && this.sameIds(newMessage, existing) || this.isMaster(existing)) continue;
                result.add(existing);
            }
            result.add(newMessage);
            return result;
        }
        if (newMessage.getRole().equals("slave")) {
            LinkedList<MemberIsAvailable> result = new LinkedList<MemberIsAvailable>();
            for (MemberIsAvailable existing : previousSnapshot) {
                if (this.sameIds(newMessage, existing)) continue;
                result.add(existing);
            }
            result.add(newMessage);
            return result;
        }
        if (newMessage.getRole().equals("backup")) {
            LinkedList<MemberIsAvailable> result = new LinkedList<MemberIsAvailable>();
            for (MemberIsAvailable existing : previousSnapshot) {
                if (existing.getRole().equals("backup")) continue;
                result.add(existing);
            }
            result.add(newMessage);
            return result;
        }
        return Iterables.append((Object)newMessage, previousSnapshot);
    }

    private boolean isMaster(MemberIsAvailable existing) {
        return existing.getRole().equals("master");
    }

    private boolean isSlave(MemberIsAvailable existing) {
        return existing.getRole().equals("slave");
    }

    private boolean sameIds(MemberIsAvailable newMessage, MemberIsAvailable existing) {
        return existing.getInstanceId().equals((Object)newMessage.getInstanceId());
    }
}

