/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.cluster;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.function.Function;
import java.util.function.Supplier;
import org.neo4j.cluster.member.ClusterMemberAvailability;
import org.neo4j.com.storecopy.MoveAfterCopy;
import org.neo4j.com.storecopy.StoreCopyClient;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.helpers.CancellationRequest;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.ha.BranchedDataPolicy;
import org.neo4j.kernel.ha.DelegateInvocationHandler;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.PullerFactory;
import org.neo4j.kernel.ha.StoreUnableToParticipateInClusterException;
import org.neo4j.kernel.ha.UpdatePuller;
import org.neo4j.kernel.ha.cluster.SwitchToSlave;
import org.neo4j.kernel.ha.com.RequestContextFactory;
import org.neo4j.kernel.ha.com.master.Master;
import org.neo4j.kernel.ha.com.master.Slave;
import org.neo4j.kernel.ha.com.slave.MasterClient;
import org.neo4j.kernel.ha.com.slave.MasterClientResolver;
import org.neo4j.kernel.ha.com.slave.SlaveServer;
import org.neo4j.kernel.ha.id.HaIdGeneratorFactory;
import org.neo4j.kernel.ha.store.ForeignStoreException;
import org.neo4j.kernel.ha.store.UnableToCopyStoreFromOldMasterException;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.store.MismatchingStoreIdException;
import org.neo4j.kernel.impl.store.StoreId;
import org.neo4j.kernel.impl.transaction.TransactionStats;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.monitoring.Monitors;

public class SwitchToSlaveCopyThenBranch
extends SwitchToSlave {
    private final LogService logService;

    public SwitchToSlaveCopyThenBranch(File storeDir, LogService logService, FileSystemAbstraction fileSystemAbstraction, Config config, DependencyResolver resolver, HaIdGeneratorFactory idGeneratorFactory, DelegateInvocationHandler<Master> masterDelegateHandler, ClusterMemberAvailability clusterMemberAvailability, RequestContextFactory requestContextFactory, PullerFactory pullerFactory, Iterable<KernelExtensionFactory<?>> kernelExtensions, MasterClientResolver masterClientResolver, SwitchToSlave.Monitor monitor, StoreCopyClient.Monitor storeCopyMonitor, Supplier<NeoStoreDataSource> neoDataSourceSupplier, Supplier<TransactionIdStore> transactionIdStoreSupplier, Function<Slave, SlaveServer> slaveServerFactory, UpdatePuller updatePuller, PageCache pageCache, Monitors monitors, TransactionStats transactionCounters) {
        this(storeDir, logService, config, resolver, idGeneratorFactory, masterDelegateHandler, clusterMemberAvailability, requestContextFactory, pullerFactory, masterClientResolver, monitor, new StoreCopyClient(storeDir, config, kernelExtensions, logService.getUserLogProvider(), fileSystemAbstraction, pageCache, storeCopyMonitor, false), neoDataSourceSupplier, transactionIdStoreSupplier, slaveServerFactory, updatePuller, pageCache, monitors, transactionCounters);
    }

    SwitchToSlaveCopyThenBranch(File storeDir, LogService logService, Config config, DependencyResolver resolver, HaIdGeneratorFactory idGeneratorFactory, DelegateInvocationHandler<Master> masterDelegateHandler, ClusterMemberAvailability clusterMemberAvailability, RequestContextFactory requestContextFactory, PullerFactory pullerFactory, MasterClientResolver masterClientResolver, SwitchToSlave.Monitor monitor, StoreCopyClient storeCopyClient, Supplier<NeoStoreDataSource> neoDataSourceSupplier, Supplier<TransactionIdStore> transactionIdStoreSupplier, Function<Slave, SlaveServer> slaveServerFactory, UpdatePuller updatePuller, PageCache pageCache, Monitors monitors, TransactionStats transactionCounters) {
        super(idGeneratorFactory, resolver, monitors, requestContextFactory, masterDelegateHandler, clusterMemberAvailability, masterClientResolver, monitor, pullerFactory, updatePuller, slaveServerFactory, config, logService, pageCache, storeDir, transactionIdStoreSupplier, transactionCounters, neoDataSourceSupplier, storeCopyClient);
        this.logService = logService;
    }

    @Override
    void checkDataConsistency(MasterClient masterClient, TransactionIdStore txIdStore, StoreId storeId, URI masterUri, URI me, CancellationRequest cancellationRequest) throws Throwable {
        try {
            this.userLog.info("Checking store consistency with master");
            this.checkMyStoreIdAndMastersStoreId(storeId, masterUri, this.resolver);
            this.checkDataConsistencyWithMaster(masterUri, masterClient, storeId, txIdStore);
            this.userLog.info("Store is consistent");
        }
        catch (StoreUnableToParticipateInClusterException upe) {
            this.userLog.info("The store is inconsistent. Will treat it as branched and fetch a new one from the master");
            this.msgLog.warn("Current store is unable to participate in the cluster; fetching new store from master", (Throwable)upe);
            try {
                this.stopServicesAndHandleBranchedStore((BranchedDataPolicy)((Object)this.config.get(HaSettings.branched_data_policy)), masterUri, me, cancellationRequest);
            }
            catch (IOException e) {
                this.msgLog.warn("Failed while trying to handle branched data", (Throwable)e);
            }
            throw upe;
        }
        catch (MismatchingStoreIdException e) {
            this.userLog.info("The store does not represent the same database as master. Will remove and fetch a new one from master");
            if (txIdStore.getLastCommittedTransactionId() == 1L) {
                this.msgLog.warn("Found and deleting empty store with mismatching store id", (Throwable)e);
                this.stopServicesAndHandleBranchedStore(BranchedDataPolicy.keep_none, masterUri, me, cancellationRequest);
                throw e;
            }
            this.msgLog.error("Store cannot participate in cluster due to mismatching store IDs", (Throwable)e);
            throw new ForeignStoreException(e.getExpected(), e.getEncountered());
        }
    }

    void stopServicesAndHandleBranchedStore(BranchedDataPolicy branchPolicy, URI masterUri, URI me, CancellationRequest cancellationRequest) throws Throwable {
        MoveAfterCopy moveWithCopyThenBranch = (moves, fromDirectory, toDirectory) -> {
            this.stopServices();
            this.msgLog.debug("Branching store: " + this.storeDir);
            branchPolicy.handle(this.storeDir, this.pageCache, this.logService);
            this.msgLog.debug("Moving downloaded store from " + fromDirectory + " to " + toDirectory);
            MoveAfterCopy.moveReplaceExisting().move(moves, fromDirectory, toDirectory);
            this.msgLog.debug("Moved downloaded store from " + fromDirectory + " to " + toDirectory);
        };
        this.copyStore(masterUri, me, cancellationRequest, moveWithCopyThenBranch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyStore(URI masterUri, URI me, CancellationRequest cancellationRequest, MoveAfterCopy moveAfterCopy) throws Throwable {
        boolean success = false;
        this.monitor.storeCopyStarted();
        LifeSupport copyLife = new LifeSupport();
        try {
            boolean masterIsOld;
            MasterClient masterClient = this.newMasterClient(masterUri, me, null, copyLife);
            copyLife.start();
            boolean bl = masterIsOld = MasterClient.CURRENT.compareTo(masterClient.getProtocolVersion()) > 0;
            if (masterIsOld) {
                throw new UnableToCopyStoreFromOldMasterException(MasterClient.CURRENT.getApplicationProtocol(), masterClient.getProtocolVersion().getApplicationProtocol());
            }
            this.copyStoreFromMaster(masterClient, cancellationRequest, moveAfterCopy);
            success = true;
        }
        finally {
            this.monitor.storeCopyCompleted(success);
            copyLife.shutdown();
        }
    }
}

