/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.cluster.member;

import java.util.function.Predicate;
import org.neo4j.cluster.InstanceId;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberState;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberStateMachine;
import org.neo4j.kernel.ha.cluster.member.ClusterMember;
import org.neo4j.kernel.ha.cluster.member.ObservedClusterMembers;

public class ClusterMembers {
    private final ObservedClusterMembers observedClusterMembers;
    private final HighAvailabilityMemberStateMachine stateMachine;

    public static Predicate<ClusterMember> inRole(String role) {
        return item -> item.hasRole(role);
    }

    public static Predicate<ClusterMember> hasInstanceId(InstanceId instanceId) {
        return item -> item.getInstanceId().equals((Object)instanceId);
    }

    public ClusterMembers(ObservedClusterMembers observedClusterMembers, HighAvailabilityMemberStateMachine stateMachine) {
        this.observedClusterMembers = observedClusterMembers;
        this.stateMachine = stateMachine;
    }

    public ClusterMember getCurrentMember() {
        ClusterMember currentMember = this.observedClusterMembers.getCurrentMember();
        if (currentMember == null) {
            return null;
        }
        HighAvailabilityMemberState currentState = this.stateMachine.getCurrentState();
        return ClusterMembers.updateRole(currentMember, currentState);
    }

    public String getCurrentMemberRole() {
        ClusterMember currentMember = this.getCurrentMember();
        return currentMember == null ? "UNKNOWN" : currentMember.getHARole();
    }

    public Iterable<ClusterMember> getMembers() {
        return this.getActualMembers(this.observedClusterMembers.getMembers());
    }

    public Iterable<ClusterMember> getAliveMembers() {
        return this.getActualMembers(this.observedClusterMembers.getAliveMembers());
    }

    private Iterable<ClusterMember> getActualMembers(Iterable<ClusterMember> members) {
        ClusterMember currentMember = this.getCurrentMember();
        if (currentMember == null) {
            return members;
        }
        return Iterables.map(member -> currentMember.getInstanceId().equals((Object)member.getInstanceId()) ? currentMember : member, members);
    }

    private static ClusterMember updateRole(ClusterMember member, HighAvailabilityMemberState state) {
        switch (state) {
            case MASTER: {
                return member.availableAs("master", member.getHAUri(), member.getStoreId());
            }
            case SLAVE: {
                return member.availableAs("slave", member.getHAUri(), member.getStoreId());
            }
        }
        return member.unavailable();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        for (ClusterMember clusterMember : this.getMembers()) {
            buf.append("  ").append(clusterMember.getInstanceId()).append(":").append(clusterMember.getHARole()).append(" (is alive = ").append(clusterMember.isAlive()).append(")").append(String.format("%n", new Object[0]));
        }
        return buf.toString();
    }
}

