/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.factory;

import java.lang.reflect.Proxy;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.ha.DelegateInvocationHandler;
import org.neo4j.kernel.impl.api.CommitProcessFactory;
import org.neo4j.kernel.impl.api.ReadOnlyTransactionCommitProcess;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.transaction.log.TransactionAppender;
import org.neo4j.storageengine.api.StorageEngine;

class HighlyAvailableCommitProcessFactory
implements CommitProcessFactory {
    private final DelegateInvocationHandler<TransactionCommitProcess> commitProcessDelegate;

    HighlyAvailableCommitProcessFactory(DelegateInvocationHandler<TransactionCommitProcess> commitProcessDelegate) {
        this.commitProcessDelegate = commitProcessDelegate;
    }

    public TransactionCommitProcess create(TransactionAppender appender, StorageEngine storageEngine, Config config) {
        if (((Boolean)config.get(GraphDatabaseSettings.read_only)).booleanValue()) {
            return new ReadOnlyTransactionCommitProcess();
        }
        return (TransactionCommitProcess)Proxy.newProxyInstance(TransactionCommitProcess.class.getClassLoader(), new Class[]{TransactionCommitProcess.class}, this.commitProcessDelegate);
    }
}

