/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.id.indexed;

import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.mutable.MutableInt;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.Seeker;
import org.neo4j.internal.id.IdGenerator;
import org.neo4j.internal.id.IdUtils;
import org.neo4j.internal.id.indexed.IdCache;
import org.neo4j.internal.id.indexed.IdRange;
import org.neo4j.internal.id.indexed.IdRangeKey;
import org.neo4j.internal.id.indexed.IdRangeLayout;
import org.neo4j.internal.id.indexed.IndexedIdGenerator;
import org.neo4j.internal.id.indexed.MarkerProvider;
import org.neo4j.internal.id.indexed.PendingIdQueue;
import org.neo4j.internal.id.indexed.ScanLock;
import org.neo4j.io.pagecache.context.CursorContext;

class FreeIdScanner
implements Closeable {
    private static final IdRangeKey LOW_KEY = new IdRangeKey(0L);
    private static final IdRangeKey HIGH_KEY = new IdRangeKey(Long.MAX_VALUE);
    static final int MAX_SLOT_SIZE = 128;
    private final int idsPerEntry;
    private final GBPTree<IdRangeKey, IdRange> tree;
    private final IdRangeLayout layout;
    private final IdCache cache;
    private final AtomicBoolean atLeastOneIdOnFreelist;
    private final MarkerProvider markerProvider;
    private final long generation;
    private final ScanLock lock;
    private final IndexedIdGenerator.Monitor monitor;
    private final ConcurrentLinkedQueue<Long> queuedSkippedHighIds = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<Long> queuedWastedCachedIds = new ConcurrentLinkedQueue();
    private final AtomicLong numBufferedIds = new AtomicLong();
    private volatile Long ongoingScanRangeIndex;

    FreeIdScanner(int idsPerEntry, GBPTree<IdRangeKey, IdRange> tree, IdRangeLayout layout, IdCache cache, AtomicBoolean atLeastOneIdOnFreelist, MarkerProvider markerProvider, long generation, boolean strictlyPrioritizeFreelistOverHighId, IndexedIdGenerator.Monitor monitor) {
        this.idsPerEntry = idsPerEntry;
        this.tree = tree;
        this.layout = layout;
        this.cache = cache;
        this.atLeastOneIdOnFreelist = atLeastOneIdOnFreelist;
        this.markerProvider = markerProvider;
        this.generation = generation;
        this.lock = strictlyPrioritizeFreelistOverHighId ? ScanLock.lockyAndPessimistic() : ScanLock.lockFreeAndOptimistic();
        this.monitor = monitor;
    }

    boolean tryLoadFreeIdsIntoCache(boolean maintenance, CursorContext cursorContext) {
        return this.tryLoadFreeIdsIntoCache(maintenance, false, cursorContext);
    }

    boolean tryLoadFreeIdsIntoCache(boolean maintenance, boolean forceScan, CursorContext cursorContext) {
        if (!forceScan && !this.hasMoreFreeIds(maintenance)) {
            return false;
        }
        if (this.scanLock(maintenance)) {
            try {
                MutableInt availableSpaceById;
                this.markQueuedSkippedHighIdsAsFree(cursorContext);
                this.markWastedIdsAsUnreserved(cursorContext);
                if (this.atLeastOneIdOnFreelist.get() && (availableSpaceById = new MutableInt(this.cache.availableSpaceById())).intValue() > 0) {
                    PendingIdQueue pendingIdQueue = new PendingIdQueue(this.cache.slotsByAvailableSpace());
                    this.cacheWastedIds(pendingIdQueue, cursorContext);
                    if (this.findSomeIdsToCache(pendingIdQueue, availableSpaceById, cursorContext)) {
                        this.markIdsAsReserved(pendingIdQueue, cursorContext);
                        this.cache.offer(pendingIdQueue, this.monitor);
                        boolean bl = true;
                        return bl;
                    }
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            finally {
                this.lock.unlock();
            }
        }
        return false;
    }

    private void cacheWastedIds(PendingIdQueue pendingIdQueue, CursorContext cursorContext) {
        this.consumeQueuedIds(this.queuedWastedCachedIds, (marker, id, size) -> {
            int accepted = pendingIdQueue.offer(id, size);
            if (accepted < size) {
                marker.markUnreserved(id + (long)accepted, size - accepted);
            }
        }, cursorContext);
    }

    private void consumeQueuedIds(ConcurrentLinkedQueue<Long> queue, QueueConsumer consumer, CursorContext cursorContext) {
        if (!queue.isEmpty()) {
            try (IndexedIdGenerator.InternalMarker marker = this.markerProvider.getMarker(cursorContext);){
                Long idAndSize;
                int numConsumedIds = 0;
                while ((idAndSize = queue.poll()) != null) {
                    long id = IdUtils.idFromCombinedId(idAndSize);
                    int size = IdUtils.numberOfIdsFromCombinedId(idAndSize);
                    consumer.accept(marker, id, size);
                    ++numConsumedIds;
                }
                this.numBufferedIds.addAndGet(-numConsumedIds);
            }
        }
    }

    private void markQueuedSkippedHighIdsAsFree(CursorContext cursorContext) {
        this.consumeQueuedIds(this.queuedSkippedHighIds, IdGenerator.Marker::markFree, cursorContext);
    }

    private void markWastedIdsAsUnreserved(CursorContext cursorContext) {
        this.consumeQueuedIds(this.queuedWastedCachedIds, IndexedIdGenerator.InternalMarker::markUnreserved, cursorContext);
    }

    boolean hasMoreFreeIds(boolean maintenance) {
        int numBufferedIdsThreshold = maintenance ? 1 : 1000;
        return this.ongoingScanRangeIndex != null || this.atLeastOneIdOnFreelist.get() || this.numBufferedIds.get() >= (long)numBufferedIdsThreshold;
    }

    private boolean scanLock(boolean awaitOngoing) {
        if (awaitOngoing) {
            this.lock.lock();
            return true;
        }
        return this.lock.tryLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearCache(CursorContext cursorContext) {
        this.lock.lock();
        try {
            this.ongoingScanRangeIndex = null;
            try (IndexedIdGenerator.InternalMarker marker = this.markerProvider.getMarker(cursorContext);){
                this.cache.drain(marker::markUnreserved);
            }
            this.atLeastOneIdOnFreelist.set(true);
        }
        finally {
            this.lock.unlock();
        }
    }

    void queueSkippedHighId(long id, int numberOfIds) {
        this.queuedSkippedHighIds.offer(IdUtils.combinedIdAndNumberOfIds(id, numberOfIds, false));
        this.numBufferedIds.incrementAndGet();
    }

    void queueWastedCachedId(long id, int numberOfIds) {
        this.queuedWastedCachedIds.offer(IdUtils.combinedIdAndNumberOfIds(id, numberOfIds, false));
        this.numBufferedIds.incrementAndGet();
    }

    private void markIdsAsReserved(PendingIdQueue pendingIdQueue, CursorContext cursorContext) {
        try (IndexedIdGenerator.InternalMarker marker = this.markerProvider.getMarker(cursorContext);){
            pendingIdQueue.accept((slotIndex, slotSize, ids) -> ids.forEach((LongProcedure & Serializable)id -> marker.markReserved(id, slotSize)));
        }
    }

    private boolean findSomeIdsToCache(PendingIdQueue pendingIdQueue, MutableInt availableSpaceById, CursorContext cursorContext) throws IOException {
        boolean somethingWasCached;
        boolean startedNow = this.ongoingScanRangeIndex == null;
        IdRangeKey from = this.ongoingScanRangeIndex == null ? LOW_KEY : new IdRangeKey(this.ongoingScanRangeIndex);
        boolean seekerExhausted = false;
        try (Seeker scanner = this.tree.seek((Object)from, (Object)HIGH_KEY, cursorContext);){
            while (availableSpaceById.intValue() > 0) {
                if (!scanner.next()) {
                    seekerExhausted = true;
                    break;
                }
                this.queueIdsFromTreeItem((IdRangeKey)scanner.key(), (IdRange)scanner.value(), pendingIdQueue, availableSpaceById);
            }
            this.ongoingScanRangeIndex = seekerExhausted ? null : Long.valueOf(((IdRangeKey)scanner.key()).getIdRangeIdx());
        }
        boolean bl = somethingWasCached = !pendingIdQueue.isEmpty();
        if (seekerExhausted && !somethingWasCached && startedNow) {
            this.atLeastOneIdOnFreelist.set(false);
        }
        return somethingWasCached;
    }

    private void queueIdsFromTreeItem(IdRangeKey key, IdRange range, PendingIdQueue pendingIdQueue, MutableInt availableSpaceById) {
        long baseId = key.getIdRangeIdx() * (long)this.idsPerEntry;
        boolean differentGeneration = this.generation != range.getGeneration();
        int firstFreeI = -1;
        for (int i = 0; i < this.idsPerEntry && availableSpaceById.intValue() > 0; ++i) {
            boolean isFree;
            IdRange.IdState state = range.getState(i);
            boolean bl = isFree = state == IdRange.IdState.FREE || differentGeneration && state == IdRange.IdState.DELETED;
            if (isFree) {
                if (firstFreeI != -1) continue;
                firstFreeI = i;
                continue;
            }
            if (firstFreeI == -1) continue;
            this.queueId(pendingIdQueue, availableSpaceById, baseId, firstFreeI, i - firstFreeI);
            firstFreeI = -1;
        }
        if (firstFreeI != -1) {
            this.queueId(pendingIdQueue, availableSpaceById, baseId, firstFreeI, this.idsPerEntry - firstFreeI);
        }
    }

    private void queueId(PendingIdQueue pendingIdQueue, MutableInt availableSpaceById, long baseId, int firstFreeI, int slotSize) {
        long startId = baseId + (long)firstFreeI;
        assert (this.layout.idRangeIndex(startId) == this.layout.idRangeIndex(startId + (long)slotSize - 1L));
        int accepted = pendingIdQueue.offer(startId, slotSize);
        if (accepted > 0) {
            availableSpaceById.addAndGet(-accepted);
        }
    }

    @Override
    public void close() throws IOException {
    }

    private static interface QueueConsumer {
        public void accept(IndexedIdGenerator.InternalMarker var1, long var2, int var4);
    }
}

