/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.id.indexed;

import java.util.Arrays;
import org.eclipse.collections.api.list.primitive.LongList;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.impl.factory.primitive.LongLists;
import org.neo4j.internal.id.IdSlotDistribution;

class PendingIdQueue {
    private final IdSlotDistribution.Slot[] slots;
    final MutableLongList[] queues;
    private final int[] slotSizes;

    PendingIdQueue(IdSlotDistribution.Slot ... slots) {
        this.slots = slots;
        this.queues = new MutableLongList[slots.length];
        this.slotSizes = new int[slots.length];
        for (int i = 0; i < slots.length; ++i) {
            this.queues[i] = LongLists.mutable.empty();
            this.slotSizes[i] = slots[i].slotSize();
        }
    }

    private boolean cache(int slotIndex, long startId) {
        if (this.queues[slotIndex].size() >= this.slots[slotIndex].capacity()) {
            return false;
        }
        return this.queues[slotIndex].add(startId);
    }

    int offer(long id, int slotSize) {
        int slotIndex = this.largestSlotIndex(slotSize);
        int acceptedSlots = 0;
        while (slotSize > 0 && slotIndex >= 0) {
            int thisSlotSize = this.slotSizes[slotIndex];
            boolean added = this.cache(slotIndex, id);
            if (added) {
                id += (long)thisSlotSize;
                acceptedSlots += thisSlotSize;
                slotSize -= thisSlotSize;
                while (slotIndex >= 0 && slotSize < this.slotSizes[slotIndex]) {
                    --slotIndex;
                }
                continue;
            }
            --slotIndex;
        }
        return acceptedSlots;
    }

    void accept(IdVisitor visitor) {
        for (int i = 0; i < this.slotSizes.length; ++i) {
            visitor.ids(i, this.slotSizes[i], (LongList)this.queues[i]);
        }
    }

    private int largestSlotIndex(int slotSize) {
        for (int slotIndex = this.slotSizes.length - 1; slotIndex >= 0; --slotIndex) {
            if (slotSize < this.slotSizes[slotIndex]) continue;
            return slotIndex;
        }
        throw new IllegalArgumentException("No slot size found for " + slotSize + " among " + Arrays.toString(this.slotSizes));
    }

    boolean isEmpty() {
        for (MutableLongList queue : this.queues) {
            if (queue.isEmpty()) continue;
            return false;
        }
        return true;
    }

    static interface IdVisitor {
        public void ids(int var1, int var2, LongList var3);
    }
}

