/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.id;

import java.io.IOException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Consumer;
import java.util.function.LongSupplier;
import org.eclipse.collections.api.set.ImmutableSet;
import org.neo4j.annotations.documented.ReporterFactory;
import org.neo4j.configuration.Config;
import org.neo4j.internal.helpers.progress.ProgressMonitorFactory;
import org.neo4j.internal.id.FreeIds;
import org.neo4j.internal.id.IdGenerator;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.internal.id.IdSlotDistribution;
import org.neo4j.internal.id.IdType;
import org.neo4j.internal.id.range.PageIdRange;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.tracing.FileFlushEvent;

public class EmptyIdGeneratorFactory
implements IdGeneratorFactory {
    public static final IdGeneratorFactory EMPTY_ID_GENERATOR_FACTORY = new EmptyIdGeneratorFactory();

    private EmptyIdGeneratorFactory() {
    }

    @Override
    public IdGenerator open(PageCache pageCache, Path filename, IdType idType, LongSupplier highIdScanner, long maxId, boolean readOnly, Config config, CursorContextFactory contextFactory, ImmutableSet<OpenOption> openOptions, IdSlotDistribution slotDistribution) throws IOException {
        return EmptyIdGenerator.EMPTY_ID_GENERATOR;
    }

    @Override
    public IdGenerator create(PageCache pageCache, Path filename, IdType idType, long highId, boolean throwIfFileExists, long maxId, boolean readOnly, Config config, CursorContextFactory contextFactory, ImmutableSet<OpenOption> openOptions, IdSlotDistribution slotDistribution) throws IOException {
        return EmptyIdGenerator.EMPTY_ID_GENERATOR;
    }

    @Override
    public IdGenerator get(IdType idType) {
        return EmptyIdGenerator.EMPTY_ID_GENERATOR;
    }

    @Override
    public void visit(Consumer<IdGenerator> visitor) {
    }

    @Override
    public void clearCache(CursorContext cursorContext) {
    }

    @Override
    public Collection<Path> listIdFiles() {
        return Collections.emptyList();
    }

    private static class EmptyIdGenerator
    implements IdGenerator {
        private static final EmptyIdGenerator EMPTY_ID_GENERATOR = new EmptyIdGenerator();
        private static final int EMPTY_ID = -1;

        private EmptyIdGenerator() {
        }

        @Override
        public void setHighId(long id) {
        }

        @Override
        public void markHighestWrittenAtHighId() {
        }

        @Override
        public long getHighestWritten() {
            return -1L;
        }

        @Override
        public long getHighId() {
            return -1L;
        }

        @Override
        public long getHighestPossibleIdInUse() {
            return -1L;
        }

        @Override
        public IdGenerator.TransactionalMarker transactionalMarker(CursorContext cursorContext) {
            return NOOP_MARKER;
        }

        @Override
        public IdGenerator.ContextualMarker contextualMarker(CursorContext cursorContext) {
            return NOOP_MARKER;
        }

        @Override
        public void close() {
        }

        @Override
        public void checkpoint(FileFlushEvent flushEvent, CursorContext cursorContext) {
        }

        @Override
        public void maintenance(CursorContext cursorContext) {
        }

        @Override
        public void start(FreeIds freeIdsForRebuild, CursorContext cursorContext) {
        }

        @Override
        public void clearCache(CursorContext cursorContext) {
        }

        @Override
        public IdType idType() {
            return null;
        }

        @Override
        public boolean hasOnlySingleIds() {
            return true;
        }

        @Override
        public long nextId(CursorContext cursorContext) {
            return -1L;
        }

        @Override
        public long nextConsecutiveIdRange(int numberOfIds, boolean favorSamePage, CursorContext cursorContext) {
            return -1L;
        }

        @Override
        public PageIdRange nextPageRange(CursorContext cursorContext, int idsPerPage) {
            return PageIdRange.EMPTY;
        }

        @Override
        public void releasePageRange(PageIdRange range, CursorContext cursorContext) {
        }

        public boolean consistencyCheck(ReporterFactory reporterFactory, CursorContextFactory contextFactory, int numThreads, ProgressMonitorFactory progressMonitorFactory) {
            return true;
        }
    }
}

