/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.id.indexed;

import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.internal.id.IdSlotDistribution;
import org.neo4j.internal.id.indexed.ConcurrentLongQueue;
import org.neo4j.internal.id.indexed.DynamicConcurrentLongQueue;
import org.neo4j.internal.id.indexed.IndexedIdGenerator;
import org.neo4j.internal.id.indexed.MpmcLongQueue;
import org.neo4j.util.Preconditions;

class IdCache {
    private static final int DYNAMIC_CHUNK_SIZE = 256;
    private final int[] slotSizes;
    private final ConcurrentLongQueue[] queues;
    private final AtomicInteger size = new AtomicInteger();
    private final int singleIdSlotIndex;
    private final boolean singleSlotted;
    private final int[] slotIndexBySize;

    IdCache(IdSlotDistribution.Slot ... slots) {
        this.queues = new ConcurrentLongQueue[slots.length];
        this.slotSizes = new int[slots.length];
        for (int slotIndex = 0; slotIndex < slots.length; ++slotIndex) {
            int slotSize = this.slotSizes[slotIndex] = slots[slotIndex].slotSize();
            int capacity = slots[slotIndex].capacity();
            Preconditions.checkArgument((slotSize <= 128 ? 1 : 0) != 0, (String)"Max slot size is %d", (Object[])new Object[]{128});
            Preconditions.checkArgument((slotIndex == 0 || slotSize > this.slotSizes[slotIndex - 1] ? 1 : 0) != 0, (String)"Slot sizes should be provided ordered from smaller to bigger");
            ConcurrentLongQueue queue = capacity > 256 ? new DynamicConcurrentLongQueue(256, capacity / 256) : new MpmcLongQueue(capacity);
            this.queues[slotIndex] = queue;
        }
        this.singleSlotted = this.isSingleSlotted();
        this.singleIdSlotIndex = IdCache.findSingleSlotIndex(this.slotSizes);
        this.slotIndexBySize = IdCache.buildSlotIndexBySize(this.slotSizes);
    }

    static int[] buildSlotIndexBySize(int[] slotSizes) {
        int[] slotIndexBySize = new int[slotSizes[slotSizes.length - 1]];
        for (int i = 0; i < slotSizes.length; ++i) {
            Arrays.fill(slotIndexBySize, i == 0 ? 0 : slotSizes[i - 1] - 1, slotSizes[i] - 1, i - 1);
        }
        slotIndexBySize[slotIndexBySize.length - 1] = slotSizes.length - 1;
        return slotIndexBySize;
    }

    private boolean isSingleSlotted() {
        for (int slotSize : this.slotSizes) {
            if (slotSize == 1) continue;
            return false;
        }
        return true;
    }

    private static int findSingleSlotIndex(int[] slotSizes) {
        for (int i = 0; i < slotSizes.length; ++i) {
            if (slotSizes[i] != 1) continue;
            return i;
        }
        throw new IllegalArgumentException("Must have a slot for single IDs");
    }

    private int largestSlotIndex(int slotSize) {
        return this.slotIndexBySize[Integer.min(slotSize, this.slotIndexBySize.length) - 1];
    }

    int offer(long id, int numberOfIds, IndexedIdGenerator.Monitor monitor) {
        int slotIndex = this.largestSlotIndex(numberOfIds);
        int acceptedSlots = 0;
        while (numberOfIds > 0 && slotIndex >= 0) {
            boolean added = this.queues[slotIndex].offer(id);
            if (added) {
                int slotSize = this.slotSizes[slotIndex];
                acceptedSlots += slotSize;
                slotIndex = (numberOfIds -= slotSize) > 0 ? this.largestSlotIndex(numberOfIds) : -1;
                this.size.incrementAndGet();
                monitor.cached(id, slotSize);
                id += (long)slotSize;
                continue;
            }
            --slotIndex;
        }
        return acceptedSlots;
    }

    long takeOrDefault(long defaultValue) {
        long id = this.queues[this.singleIdSlotIndex].takeOrDefault(defaultValue);
        if (id != defaultValue) {
            this.size.decrementAndGet();
        }
        return id;
    }

    long takeOrDefault(long defaultValue, int numberOfIds, IndexedIdGenerator.Monitor monitor, IdRangeConsumer wasteNotifier) {
        long id = defaultValue;
        for (int slotIndex = this.lowestSlotIndexCapableOf(numberOfIds); id == defaultValue && slotIndex < this.slotSizes.length; ++slotIndex) {
            int wastedNumberOfIds;
            long wastedId;
            int accepted;
            id = this.queues[slotIndex].takeOrDefault(defaultValue);
            if (id == -1L || this.slotSizes[slotIndex] == numberOfIds || (accepted = this.offer(wastedId = id + (long)numberOfIds, wastedNumberOfIds = this.slotSizes[slotIndex] - numberOfIds, monitor)) >= wastedNumberOfIds) continue;
            wasteNotifier.accept(wastedId + (long)accepted, wastedNumberOfIds - accepted);
        }
        if (id != defaultValue) {
            this.size.decrementAndGet();
        }
        return id;
    }

    int availableSpaceById() {
        int space = 0;
        for (int i = 0; i < this.slotSizes.length; ++i) {
            space += this.queues[i].availableSpace() * this.slotSizes[i];
        }
        return space;
    }

    IdSlotDistribution.Slot[] slotsByAvailableSpace() {
        IdSlotDistribution.Slot[] slots = new IdSlotDistribution.Slot[this.slotSizes.length];
        for (int slotIndex = 0; slotIndex < this.slotSizes.length; ++slotIndex) {
            ConcurrentLongQueue queue = this.queues[slotIndex];
            slots[slotIndex] = new IdSlotDistribution.Slot(queue.availableSpace(), this.slotSizes[slotIndex]);
        }
        return slots;
    }

    void drain(IdRangeConsumer consumer) {
        for (int i = 0; i < this.queues.length; ++i) {
            long id;
            ConcurrentLongQueue queue = this.queues[i];
            int slotSize = this.slotSizes[i];
            while ((id = queue.takeOrDefault(-1L)) != -1L) {
                consumer.accept(id, slotSize);
                this.size.decrementAndGet();
            }
        }
    }

    long[] drainRange(int idsPerPage) {
        assert (this.singleSlotted);
        long[] ids = null;
        int position = 0;
        long idPageLowerBoundary = Long.MIN_VALUE;
        long idPageUpperBoundary = Long.MAX_VALUE;
        for (ConcurrentLongQueue queue : this.queues) {
            long id;
            while (position < idsPerPage && (id = queue.takeInRange(idPageLowerBoundary, idPageUpperBoundary)) < idPageUpperBoundary) {
                if (ids == null) {
                    ids = new long[idsPerPage];
                    idPageLowerBoundary = id / (long)idsPerPage * (long)idsPerPage;
                    idPageUpperBoundary = idPageLowerBoundary + (long)idsPerPage;
                }
                ids[position++] = id;
            }
        }
        if (ids == null) {
            return ArrayUtils.EMPTY_LONG_ARRAY;
        }
        this.size.getAndAdd(-position);
        return Arrays.copyOf(ids, position);
    }

    int size() {
        return this.size.get();
    }

    boolean isFull() {
        for (ConcurrentLongQueue queue : this.queues) {
            if (queue.availableSpace() <= 0) continue;
            return false;
        }
        return true;
    }

    private int lowestSlotIndexCapableOf(int numberOfIds) {
        for (int slotIndex = 0; slotIndex < this.slotSizes.length; ++slotIndex) {
            if (this.slotSizes[slotIndex] < numberOfIds) continue;
            return slotIndex;
        }
        throw new IllegalArgumentException("Slot size " + numberOfIds + " too large");
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("IdCache{size:" + this.size + ", availableSpace:");
        for (int i = 0; i < this.slotSizes.length; ++i) {
            builder.append(this.slotSizes[i]).append(":").append(this.queues[i].availableSpace()).append(", ");
        }
        return builder.append("}").toString();
    }

    static interface IdRangeConsumer {
        public void accept(long var1, int var3);
    }
}

