/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.id;

import org.neo4j.util.Preconditions;

public interface IdSlotDistribution {
    public static final IdSlotDistribution SINGLE_IDS = new IdSlotDistribution(){

        @Override
        public Slot[] slots(int capacity) {
            return new Slot[]{new Slot(capacity, 1)};
        }

        @Override
        public int maxSlotSize() {
            return 1;
        }
    };

    public static IdSlotDistribution slotDistribution(int ... slotSizes) {
        return IdSlotDistribution.slotDistribution(128, slotSizes);
    }

    public static IdSlotDistribution slotDistribution(int idsPerEntry, final int ... slotSizes) {
        return new BaseIdSlotDistribution(idsPerEntry, slotSizes){

            @Override
            public Slot[] slots(int capacity) {
                Slot[] slots = new Slot[slotSizes.length];
                int capacityPerSlot = (int)((double)capacity / Math.floor(Math.sqrt(slotSizes.length)));
                for (int i = 0; i < slotSizes.length; ++i) {
                    slots[i] = new Slot(capacityPerSlot, slotSizes[i]);
                }
                return slots;
            }
        };
    }

    public static int[] powerTwoSlotSizesDownwards(int highSlotSize) {
        Preconditions.requirePowerOfTwo((long)highSlotSize);
        int[] slots = new int[Integer.numberOfTrailingZeros(highSlotSize) + 1];
        for (int i = 0; i < slots.length; ++i) {
            slots[i] = 1 << i;
        }
        return slots;
    }

    public Slot[] slots(int var1);

    public int maxSlotSize();

    default public int idsPerEntry() {
        return 128;
    }

    public static abstract class BaseIdSlotDistribution
    implements IdSlotDistribution {
        private final int idsPerEntry;
        private final int[] slotSizes;

        BaseIdSlotDistribution(int idsPerEntry, int[] slotSizes) {
            this.idsPerEntry = idsPerEntry;
            this.slotSizes = slotSizes;
        }

        @Override
        public int idsPerEntry() {
            return this.idsPerEntry;
        }

        @Override
        public int maxSlotSize() {
            return this.slotSizes[this.slotSizes.length - 1];
        }
    }

    public record Slot(int capacity, int slotSize) {
    }
}

