/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.cache.idmapping.string;

import org.neo4j.internal.batchimport.cache.IntArray;
import org.neo4j.internal.batchimport.cache.idmapping.string.AbstractTracker;

public class IntTracker
extends AbstractTracker<IntArray> {
    static final int SIZE = 4;
    static final int ID_BITS = 31;
    static final int DEFAULT_VALUE = -1;
    static final long ID_MASK = Integer.MAX_VALUE;

    public IntTracker(IntArray array) {
        super(array);
    }

    @Override
    public long get(long index) {
        long value = (long)((IntArray)this.array).get(index) & Integer.MAX_VALUE;
        return value == Integer.MAX_VALUE ? -1L : value;
    }

    @Override
    public void set(long index, long value) {
        long isDuplicate = (long)((IntArray)this.array).get(index) & Integer.MIN_VALUE;
        ((IntArray)this.array).set(index, (int)(isDuplicate | value));
    }

    @Override
    public void markAsDuplicate(long index) {
        ((IntArray)this.array).set(index, (int)((long)((IntArray)this.array).get(index) & Integer.MAX_VALUE));
    }

    @Override
    public boolean isMarkedAsDuplicate(long index) {
        long isDuplicate = (long)((IntArray)this.array).get(index) & Integer.MIN_VALUE;
        return isDuplicate == 0L;
    }
}

