/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.input;

import java.io.IOException;
import java.lang.reflect.Array;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.internal.helpers.TimeUtil;
import org.neo4j.io.fs.FlushableChannel;
import org.neo4j.io.fs.ReadableChannel;
import org.neo4j.string.UTF8;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.TimeZones;
import org.neo4j.values.storable.Values;
import org.neo4j.values.utils.TemporalUtil;

public abstract class ValueType {
    private static final Map<Class<?>, ValueType> byClass = new HashMap();
    private static final Map<Byte, ValueType> byId = new HashMap<Byte, ValueType>();
    private static final ValueType stringType;
    private static byte next;
    private static final ValueType arrayType;
    private final Class<?>[] classes;
    private final byte id;

    private ValueType(Class<?> ... classes) {
        byte by = next;
        next = (byte)(by + 1);
        this.id = by;
        this.classes = classes;
    }

    private static void add(ValueType type) {
        for (Class<?> cls : type.classes) {
            byClass.put(cls, type);
        }
        byId.put(type.id(), type);
    }

    public static ValueType typeOf(Object value) {
        return ValueType.typeOf(value.getClass());
    }

    public static ValueType typeOf(Class<?> cls) {
        if (cls.isArray()) {
            return arrayType;
        }
        ValueType type = byClass.get(cls);
        assert (type != null) : "Unrecognized value type " + String.valueOf(cls);
        return type;
    }

    public static ValueType typeOf(byte id) {
        if (id == arrayType.id()) {
            return arrayType;
        }
        ValueType type = byId.get(id);
        assert (type != null) : "Unrecognized value type id " + id;
        return type;
    }

    public static ValueType stringType() {
        return stringType;
    }

    private Class<?> componentClass() {
        return this.classes[0];
    }

    public final byte id() {
        return this.id;
    }

    public abstract Object read(ReadableChannel var1) throws IOException;

    public abstract int length(Object var1);

    public abstract void write(Object var1, FlushableChannel var2) throws IOException;

    static {
        ValueType.add(new ValueType(new Class[]{Boolean.TYPE, Boolean.class}){

            @Override
            public Object read(ReadableChannel from) throws IOException {
                return from.get() == 0 ? Boolean.FALSE : Boolean.TRUE;
            }

            @Override
            public int length(Object value) {
                return 1;
            }

            @Override
            public void write(Object value, FlushableChannel into) throws IOException {
                into.put((Boolean)value != false ? (byte)1 : 0);
            }
        });
        ValueType.add(new ValueType(new Class[]{Byte.TYPE, Byte.class}){

            @Override
            public Object read(ReadableChannel from) throws IOException {
                return from.get();
            }

            @Override
            public int length(Object value) {
                return 1;
            }

            @Override
            public void write(Object value, FlushableChannel into) throws IOException {
                into.put(((Byte)value).byteValue());
            }
        });
        ValueType.add(new ValueType(new Class[]{Short.TYPE, Short.class}){

            @Override
            public Object read(ReadableChannel from) throws IOException {
                return from.getShort();
            }

            @Override
            public int length(Object value) {
                return 2;
            }

            @Override
            public void write(Object value, FlushableChannel into) throws IOException {
                into.putShort(((Short)value).shortValue());
            }
        });
        ValueType.add(new ValueType(new Class[]{Character.TYPE, Character.class}){

            @Override
            public Object read(ReadableChannel from) throws IOException {
                return Character.valueOf((char)from.getInt());
            }

            @Override
            public int length(Object value) {
                return 2;
            }

            @Override
            public void write(Object value, FlushableChannel into) throws IOException {
                into.putInt((int)((Character)value).charValue());
            }
        });
        ValueType.add(new ValueType(new Class[]{Integer.TYPE, Integer.class}){

            @Override
            public Object read(ReadableChannel from) throws IOException {
                return from.getInt();
            }

            @Override
            public int length(Object value) {
                return 4;
            }

            @Override
            public void write(Object value, FlushableChannel into) throws IOException {
                into.putInt(((Integer)value).intValue());
            }
        });
        ValueType.add(new ValueType(new Class[]{Long.TYPE, Long.class}){

            @Override
            public Object read(ReadableChannel from) throws IOException {
                return from.getLong();
            }

            @Override
            public int length(Object value) {
                return 8;
            }

            @Override
            public void write(Object value, FlushableChannel into) throws IOException {
                into.putLong(((Long)value).longValue());
            }
        });
        ValueType.add(new ValueType(new Class[]{Float.TYPE, Float.class}){

            @Override
            public Object read(ReadableChannel from) throws IOException {
                return Float.valueOf(from.getFloat());
            }

            @Override
            public int length(Object value) {
                return 4;
            }

            @Override
            public void write(Object value, FlushableChannel into) throws IOException {
                into.putFloat(((Float)value).floatValue());
            }
        });
        stringType = new ValueType(new Class[]{String.class}){

            @Override
            public Object read(ReadableChannel from) throws IOException {
                int length = from.getInt();
                byte[] bytes = new byte[length];
                from.get(bytes, length);
                return UTF8.decode((byte[])bytes);
            }

            @Override
            public int length(Object value) {
                return 4 + UTF8.encode((String)((String)value)).length * 2;
            }

            @Override
            public void write(Object value, FlushableChannel into) throws IOException {
                byte[] bytes = UTF8.encode((String)((String)value));
                into.putInt(bytes.length).put(bytes, bytes.length);
            }
        };
        ValueType.add(stringType);
        ValueType.add(new ValueType(new Class[]{Double.class, Double.TYPE}){

            @Override
            public Object read(ReadableChannel from) throws IOException {
                return from.getDouble();
            }

            @Override
            public int length(Object value) {
                return 8;
            }

            @Override
            public void write(Object value, FlushableChannel into) throws IOException {
                into.putDouble(((Double)value).doubleValue());
            }
        });
        ValueType.add(new ValueType(new Class[]{LocalDate.class}){

            @Override
            public Object read(ReadableChannel from) throws IOException {
                return LocalDate.ofEpochDay(from.getLong());
            }

            @Override
            public int length(Object value) {
                return 8;
            }

            @Override
            public void write(Object value, FlushableChannel into) throws IOException {
                into.putLong(((LocalDate)value).toEpochDay());
            }
        });
        ValueType.add(new ValueType(new Class[]{LocalTime.class}){

            @Override
            public Object read(ReadableChannel from) throws IOException {
                return LocalTime.ofNanoOfDay(from.getLong());
            }

            @Override
            public int length(Object value) {
                return 8;
            }

            @Override
            public void write(Object value, FlushableChannel into) throws IOException {
                into.putLong(((LocalTime)value).toNanoOfDay());
            }
        });
        ValueType.add(new ValueType(new Class[]{LocalDateTime.class}){

            @Override
            public Object read(ReadableChannel from) throws IOException {
                return LocalDateTime.ofEpochSecond(from.getLong(), from.getInt(), ZoneOffset.UTC);
            }

            @Override
            public int length(Object value) {
                return 12;
            }

            @Override
            public void write(Object value, FlushableChannel into) throws IOException {
                LocalDateTime ldt = (LocalDateTime)value;
                into.putLong(ldt.toEpochSecond(ZoneOffset.UTC));
                into.putInt(ldt.getNano());
            }
        });
        ValueType.add(new ValueType(new Class[]{OffsetTime.class}){

            @Override
            public Object read(ReadableChannel from) throws IOException {
                return OffsetTime.ofInstant(Instant.ofEpochSecond(0L, from.getLong()), TimeUtil.zoneOffsetOfTotalSeconds((int)from.getInt()));
            }

            @Override
            public int length(Object value) {
                return 12;
            }

            @Override
            public void write(Object value, FlushableChannel into) throws IOException {
                OffsetTime ot = (OffsetTime)value;
                into.putLong(TemporalUtil.getNanosOfDayUTC((OffsetTime)ot));
                into.putInt(ot.getOffset().getTotalSeconds());
            }
        });
        ValueType.add(new ValueType(new Class[]{ZonedDateTime.class}){

            @Override
            public Object read(ReadableChannel from) throws IOException {
                if (from.get() == 0) {
                    long epochSecondsUTC = from.getLong();
                    int nanos = from.getInt();
                    int offsetSeconds = from.getInt();
                    return ZonedDateTime.ofInstant(Instant.ofEpochSecond(epochSecondsUTC, nanos), TimeUtil.zoneOffsetOfTotalSeconds((int)offsetSeconds));
                }
                long epochSecondsUTC = from.getLong();
                int nanos = from.getInt();
                int zoneID = from.getInt();
                String zone = TimeZones.map((short)((short)zoneID));
                return ZonedDateTime.ofInstant(Instant.ofEpochSecond(epochSecondsUTC, nanos), ZoneId.of(zone));
            }

            @Override
            public int length(Object value) {
                return 17;
            }

            @Override
            public void write(Object value, FlushableChannel into) throws IOException {
                ZonedDateTime zonedDateTime = (ZonedDateTime)value;
                long epochSecondUTC = zonedDateTime.toEpochSecond();
                int nano = zonedDateTime.getNano();
                ZoneId zone = zonedDateTime.getZone();
                if (zone instanceof ZoneOffset) {
                    int offsetSeconds = ((ZoneOffset)zone).getTotalSeconds();
                    into.put((byte)0);
                    into.putLong(epochSecondUTC);
                    into.putInt(nano);
                    into.putInt(offsetSeconds);
                } else {
                    String zoneId = zone.getId();
                    into.put((byte)1);
                    into.putLong(epochSecondUTC);
                    into.putInt(nano);
                    into.putInt((int)TimeZones.map((String)zoneId));
                }
            }
        });
        ValueType.add(new ValueType(new Class[]{DurationValue.class, Duration.class, Period.class}){

            @Override
            public Object read(ReadableChannel from) throws IOException {
                int nanos = from.getInt();
                long seconds = from.getLong();
                long days = from.getLong();
                long months = from.getLong();
                return DurationValue.duration((long)months, (long)days, (long)seconds, (long)nanos);
            }

            @Override
            public int length(Object value) {
                return 28;
            }

            @Override
            public void write(Object value, FlushableChannel into) throws IOException {
                DurationValue duration = value instanceof Duration ? DurationValue.duration((Duration)((Duration)value)) : (value instanceof Period ? DurationValue.duration((Period)((Period)value)) : (DurationValue)value);
                into.putInt((int)duration.get((TemporalUnit)ChronoUnit.NANOS));
                into.putLong(duration.get((TemporalUnit)ChronoUnit.SECONDS));
                into.putLong(duration.get((TemporalUnit)ChronoUnit.DAYS));
                into.putLong(duration.get((TemporalUnit)ChronoUnit.MONTHS));
            }
        });
        ValueType.add(new ValueType(new Class[]{PointValue.class}){

            @Override
            public Object read(ReadableChannel from) throws IOException {
                int code = from.getInt();
                CoordinateReferenceSystem crs = CoordinateReferenceSystem.get((int)code);
                int length = from.getInt();
                double[] coordinate = new double[length];
                for (int i = 0; i < length; ++i) {
                    coordinate[i] = from.getDouble();
                }
                return Values.pointValue((CoordinateReferenceSystem)crs, (double[])coordinate);
            }

            @Override
            public int length(Object value) {
                return 8 + ((PointValue)value).coordinate().length * 8;
            }

            @Override
            public void write(Object value, FlushableChannel into) throws IOException {
                PointValue pointValue = (PointValue)value;
                into.putInt(pointValue.getCoordinateReferenceSystem().getCode());
                double[] coordinate = pointValue.coordinate();
                into.putInt(coordinate.length);
                for (double c : coordinate) {
                    into.putDouble(c);
                }
            }
        });
        arrayType = new ValueType(new Class[0]){

            @Override
            public Object read(ReadableChannel from) throws IOException {
                ValueType componentType = 17.typeOf(from.get());
                int length = from.getInt();
                Object value = Array.newInstance(componentType.componentClass(), length);
                for (int i = 0; i < length; ++i) {
                    Array.set(value, i, componentType.read(from));
                }
                return value;
            }

            @Override
            public int length(Object value) {
                ValueType componentType = 17.typeOf(value.getClass().getComponentType());
                int arrayLength = Array.getLength(value);
                int length = 5;
                for (int i = 0; i < arrayLength; ++i) {
                    length += componentType.length(Array.get(value, i));
                }
                return length;
            }

            @Override
            public void write(Object value, FlushableChannel into) throws IOException {
                ValueType componentType = 17.typeOf(value.getClass().getComponentType());
                into.put(componentType.id());
                int length = Array.getLength(value);
                into.putInt(length);
                for (int i = 0; i < length; ++i) {
                    componentType.write(Array.get(value, i), into);
                }
            }
        };
    }
}

