/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.input.csv;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.neo4j.batchimport.api.input.Group;
import org.neo4j.batchimport.api.input.IdType;
import org.neo4j.collection.RawIterator;
import org.neo4j.csv.reader.CharReadable;
import org.neo4j.csv.reader.CharSeeker;
import org.neo4j.csv.reader.Configuration;
import org.neo4j.csv.reader.Extractor;
import org.neo4j.csv.reader.Extractors;
import org.neo4j.csv.reader.Mark;
import org.neo4j.csv.reader.Readables;
import org.neo4j.csv.reader.VectorExtractor;
import org.neo4j.internal.batchimport.input.DuplicateHeaderException;
import org.neo4j.internal.batchimport.input.Groups;
import org.neo4j.internal.batchimport.input.HeaderException;
import org.neo4j.internal.batchimport.input.csv.CsvInput;
import org.neo4j.internal.batchimport.input.csv.Data;
import org.neo4j.internal.batchimport.input.csv.DataFactory;
import org.neo4j.internal.batchimport.input.csv.Decorator;
import org.neo4j.internal.batchimport.input.csv.Header;
import org.neo4j.internal.batchimport.input.csv.Type;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.util.Preconditions;
import org.neo4j.values.storable.CSVHeaderInformation;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.TemporalValue;
import org.neo4j.values.storable.Value;

public class DataFactories {
    private static final Supplier<ZoneId> DEFAULT_TIME_ZONE = () -> ZoneOffset.UTC;
    private static final Set<String> POINT_VALUE_CSV_HEADER_TYPES = new HashSet<String>(Arrays.asList("point", "point[]"));
    private static final Set<String> TEMPORAL_VALUE_CSV_HEADER_TYPES = new HashSet<String>(Arrays.asList("time", "time[]", "datetime", "datetime[]"));
    private static final String VECTOR_VALUE_CSV_HEADER_TYPE = "vector";

    private DataFactories() {
    }

    public static DataFactory data(final Decorator decorator, final Charset charset, final Path ... files) {
        if (files.length == 0) {
            throw new IllegalArgumentException("No files specified");
        }
        return config -> new Data(){

            @Override
            public RawIterator<CharReadable, IOException> stream() {
                return Readables.individualFiles((Configuration)config, (Charset)charset, (Path[])files);
            }

            @Override
            public Decorator decorator() {
                return decorator;
            }
        };
    }

    public static DataFactory data(final Decorator decorator, final Supplier<CharReadable> readable) {
        return config -> new Data(){

            @Override
            public RawIterator<CharReadable, IOException> stream() {
                return Readables.iterator(reader -> reader, (Object[])new CharReadable[]{(CharReadable)readable.get()});
            }

            @Override
            public Decorator decorator() {
                return decorator;
            }
        };
    }

    public static Header.Factory defaultFormatNodeFileHeader(Supplier<ZoneId> defaultTimeZone, boolean normalizeTypes) {
        return new DefaultNodeFileHeaderParser(defaultTimeZone, normalizeTypes);
    }

    public static Header.Factory defaultFormatNodeFileHeader(boolean normalizeTypes) {
        return DataFactories.defaultFormatNodeFileHeader(DEFAULT_TIME_ZONE, normalizeTypes);
    }

    public static Header.Factory defaultFormatNodeFileHeader() {
        return DataFactories.defaultFormatNodeFileHeader(false);
    }

    public static Header.Factory defaultFormatRelationshipFileHeader(Supplier<ZoneId> defaultTimeZone, boolean normalizeTypes) {
        return new DefaultRelationshipFileHeaderParser(defaultTimeZone, normalizeTypes);
    }

    public static Header.Factory defaultFormatRelationshipFileHeader(boolean normalizeTypes) {
        return DataFactories.defaultFormatRelationshipFileHeader(DEFAULT_TIME_ZONE, normalizeTypes);
    }

    public static Header.Factory defaultFormatRelationshipFileHeader() {
        return DataFactories.defaultFormatRelationshipFileHeader(DEFAULT_TIME_ZONE, false);
    }

    public static Header.Entry[] parseHeaderEntries(CharSeeker dataSeeker, Configuration config, IdType idType, Groups groups, Supplier<ZoneId> defaultTimeZone, HeaderEntryFactory entryFactory, Header.Monitor monitor) {
        try {
            Mark mark = new Mark();
            Extractors extractors = new Extractors(config.arrayDelimiter(), config.vectorDelimiter(), config.emptyQuotedStringsAsNull(), config.trimStrings(), defaultTimeZone);
            Extractor<?> idExtractor = CsvInput.idExtractor(idType, extractors);
            char delimiter = config.delimiter();
            ArrayList<Header.Entry> columns = new ArrayList<Header.Entry>();
            int i = 0;
            while (!mark.isEndOfLine() && dataSeeker.seek(mark, (int)delimiter)) {
                HeaderEntrySpec spec;
                String rawEntry = (String)dataSeeker.tryExtract(mark, extractors.string());
                HeaderEntrySpec headerEntrySpec = spec = !extractors.string().isEmpty((Object)rawEntry) ? DataFactories.parseHeaderEntrySpec(rawEntry) : null;
                if (spec == null || Type.IGNORE.name().equals(spec.type())) {
                    columns.add(new Header.Entry(rawEntry, null, Type.IGNORE, null, null));
                } else if (Type.ACTION.name().equals(spec.type())) {
                    columns.add(new Header.Entry(rawEntry, null, Type.ACTION, null, extractors.string()));
                } else {
                    columns.add(entryFactory.create(dataSeeker.sourceDescription(), i, spec, extractors, idExtractor, groups, monitor));
                }
                ++i;
            }
            return columns.toArray(new Header.Entry[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static HeaderEntrySpec parseHeaderEntrySpec(String rawEntry) {
        int typeIndex;
        int groupStartIndex;
        String rawHeaderField = rawEntry;
        String type = null;
        String groupName = null;
        HashMap<String, String> options = new HashMap();
        int optionsStartIndex = rawHeaderField.indexOf(123);
        if (optionsStartIndex != -1) {
            int optionsEndIndex = rawHeaderField.lastIndexOf(125);
            Preconditions.checkState((optionsEndIndex != -1 && optionsEndIndex > optionsStartIndex ? 1 : 0) != 0, (String)"Expected a closing '}' in header %s", (Object[])new Object[]{rawHeaderField});
            String rawOptions = rawHeaderField.substring(optionsStartIndex, optionsEndIndex + 1);
            options = Value.parseStringMap((CharSequence)rawOptions);
            rawHeaderField = DataFactories.cutOut(rawHeaderField, optionsStartIndex, optionsEndIndex);
        }
        if ((groupStartIndex = rawHeaderField.indexOf(40)) != -1) {
            int groupEndIndex = rawHeaderField.lastIndexOf(41);
            Preconditions.checkState((groupEndIndex != -1 && groupEndIndex > groupStartIndex ? 1 : 0) != 0, (String)"Expected a closing ')'");
            groupName = rawHeaderField.substring(groupStartIndex + 1, groupEndIndex);
            rawHeaderField = DataFactories.cutOut(rawHeaderField, groupStartIndex, groupEndIndex);
        }
        if ((typeIndex = rawHeaderField.lastIndexOf(58)) != -1) {
            type = rawHeaderField.substring(typeIndex + 1);
            rawHeaderField = rawHeaderField.substring(0, typeIndex);
        }
        String name = rawHeaderField.isEmpty() ? null : rawHeaderField;
        return new HeaderEntrySpec(rawEntry, name, type, groupName, options);
    }

    private static String cutOut(String string, int startIndex, int endIndex) {
        StringBuilder result = new StringBuilder();
        if (startIndex > 0) {
            result.append(string, 0, startIndex);
        }
        if (endIndex + 1 < string.length()) {
            result.append(string.substring(endIndex + 1));
        }
        return result.toString();
    }

    private static CSVHeaderInformation parseOptionalParameter(String typeSpec, Map<String, String> options) {
        String typeSpecLowerCase = typeSpec.toLowerCase(Locale.ROOT);
        if (!options.isEmpty()) {
            if (POINT_VALUE_CSV_HEADER_TYPES.contains(typeSpecLowerCase)) {
                return PointValue.parseHeaderInformation(options);
            }
            if (TEMPORAL_VALUE_CSV_HEADER_TYPES.contains(typeSpecLowerCase)) {
                return TemporalValue.parseHeaderInformation(options);
            }
            if (VECTOR_VALUE_CSV_HEADER_TYPE.equals(typeSpecLowerCase)) {
                return VectorExtractor.parseHeaderInformation(options);
            }
        }
        return null;
    }

    private static Extractor<?> parsePropertyType(String typeSpec, CSVHeaderInformation optionalParameter, Extractors extractors) {
        try {
            return extractors.valueOf(typeSpec, optionalParameter);
        }
        catch (IllegalArgumentException e) {
            throw new HeaderException("Unable to parse header. %s".formatted(e.getMessage()), e);
        }
    }

    public static Iterable<DataFactory> datas(DataFactory ... factories) {
        return Iterables.iterable((Object[])factories);
    }

    private static class DefaultNodeFileHeaderParser
    extends AbstractDefaultFileHeaderParser {
        DefaultNodeFileHeaderParser(Supplier<ZoneId> defaultTimeZone, boolean normalizeTypes) {
            super(defaultTimeZone, normalizeTypes, new Type[0]);
        }

        @Override
        public Header.Entry createSpecific(String sourceDescription, int entryIndex, HeaderEntrySpec spec, Extractors extractors, Extractor<?> defaultIdExtractor, Groups groups, Header.Monitor monitor) {
            Extractor<?> extractor;
            Type type;
            Group group = null;
            if (Type.ID.matches(spec.type())) {
                type = Type.ID;
                group = groups.getOrCreate(spec.group(), spec.options().get("id-type"));
                if (group.specificIdType() == null) {
                    extractor = defaultIdExtractor;
                } else {
                    if ("VECTOR".equals(group.specificIdType().toUpperCase(Locale.ROOT))) {
                        throw new HeaderException("vector is not allowed as an id-type");
                    }
                    extractor = DataFactories.parsePropertyType(group.specificIdType(), null, extractors);
                }
            } else if (Type.LABEL.matches(spec.type())) {
                type = Type.LABEL;
                extractor = extractors.stringArray();
            } else if (Type.REMOVE_LABEL.matches(spec.type())) {
                type = Type.REMOVE_LABEL;
                extractor = extractors.stringArray();
            } else {
                return null;
            }
            return new Header.Entry(spec.rawEntry(), spec.name(), type, group, extractor, spec.options(), null);
        }
    }

    private static class DefaultRelationshipFileHeaderParser
    extends AbstractDefaultFileHeaderParser {
        DefaultRelationshipFileHeaderParser(Supplier<ZoneId> defaultTimeZone, boolean normalizeTypes) {
            super(defaultTimeZone, normalizeTypes, Type.START_ID, Type.END_ID);
        }

        @Override
        public Header.Entry createSpecific(String sourceDescription, int entryIndex, HeaderEntrySpec spec, Extractors extractors, Extractor<?> defaultIdExtractor, Groups groups, Header.Monitor monitor) {
            Extractor<?> extractor;
            Type type;
            Group group = null;
            if (Type.START_ID.matches(spec.type()) || Type.END_ID.matches(spec.type())) {
                type = Type.START_ID.matches(spec.type()) ? Type.START_ID : Type.END_ID;
                group = groups.get(spec.group());
                extractor = group.specificIdType() == null ? defaultIdExtractor : DataFactories.parsePropertyType(group.specificIdType(), null, extractors);
            } else if (Type.TYPE.matches(spec.type())) {
                type = Type.TYPE;
                extractor = extractors.string();
            } else {
                return null;
            }
            return new Header.Entry(spec.rawEntry(), spec.name(), type, group, extractor, spec.options(), null);
        }
    }

    record HeaderEntrySpec(String rawEntry, String name, String type, String group, Map<String, String> options) {
    }

    static interface HeaderEntryFactory {
        public Header.Entry create(String var1, int var2, HeaderEntrySpec var3, Extractors var4, Extractor<?> var5, Groups var6, Header.Monitor var7);
    }

    private static abstract class AbstractDefaultFileHeaderParser
    implements Header.Factory,
    HeaderEntryFactory {
        private final Type[] mandatoryTypes;
        private final Supplier<ZoneId> defaultTimeZone;
        private final boolean normalizeTypes;

        AbstractDefaultFileHeaderParser(Supplier<ZoneId> defaultTimeZone, boolean normalizeTypes, Type ... mandatoryTypes) {
            this.defaultTimeZone = defaultTimeZone;
            this.normalizeTypes = normalizeTypes;
            this.mandatoryTypes = mandatoryTypes;
        }

        @Override
        public Header create(CharSeeker dataSeeker, Configuration config, IdType idType, Groups groups, Header.Monitor monitor) {
            Header.Entry[] entries = DataFactories.parseHeaderEntries(dataSeeker, config, idType, groups, this.defaultTimeZone, this, monitor);
            this.validateHeader(entries, dataSeeker);
            return new Header(entries);
        }

        @Override
        public Header.Entry create(String sourceDescription, int entryIndex, HeaderEntrySpec spec, Extractors extractors, Extractor<?> idExtractor, Groups groups, Header.Monitor monitor) {
            Object extractor;
            Type type;
            if (spec.type() == null) {
                return new Header.Entry(spec.rawEntry(), spec.name(), Type.PROPERTY, null, extractors.string());
            }
            Header.Entry specificEntry = this.createSpecific(sourceDescription, entryIndex, spec, extractors, idExtractor, groups, monitor);
            if (specificEntry != null) {
                return specificEntry;
            }
            CSVHeaderInformation optionalParameter = null;
            Group group = null;
            if (Type.REMOVE_PROPERTY.matches(spec.type())) {
                type = Type.REMOVE_PROPERTY;
                extractor = spec.name() != null ? extractors.string() : extractors.stringArray();
            } else {
                if (AbstractDefaultFileHeaderParser.isRecognizedType(spec.type())) {
                    throw new HeaderException("Unexpected header type '" + spec.type() + "'");
                }
                type = Type.PROPERTY;
                try {
                    optionalParameter = DataFactories.parseOptionalParameter(spec.type(), spec.options());
                }
                catch (IllegalArgumentException e) {
                    throw new HeaderException("Unable to parse header. %s".formatted(e.getMessage()), e);
                }
                extractor = this.propertyExtractor(sourceDescription, spec.name(), spec.type(), optionalParameter, extractors, monitor);
            }
            return new Header.Entry(spec.rawEntry(), spec.name(), type, group, (Extractor<?>)extractor, spec.options(), optionalParameter);
        }

        protected abstract Header.Entry createSpecific(String var1, int var2, HeaderEntrySpec var3, Extractors var4, Extractor<?> var5, Groups var6, Header.Monitor var7);

        private void validateHeader(Header.Entry[] entries, CharSeeker dataSeeker) {
            HashMap<String, Header.Entry> idProperties = new HashMap<String, Header.Entry>();
            HashMap<String, Header.Entry> properties = new HashMap<String, Header.Entry>();
            EnumMap<Type, Header.Entry> singletonEntries = new EnumMap<Type, Header.Entry>(Type.class);
            EnumSet<Type> multiEntries = EnumSet.noneOf(Type.class);
            block5: for (Header.Entry entry : entries) {
                switch (entry.type()) {
                    case ID: 
                    case PROPERTY: {
                        Header.Entry existingIdPropertyEntry;
                        String propertyName = entry.name();
                        if (propertyName == null) continue block5;
                        if (entry.type() == Type.ID && (existingIdPropertyEntry = idProperties.put(propertyName, entry)) != null) {
                            throw new DuplicateHeaderException(existingIdPropertyEntry, entry, dataSeeker.sourceDescription(), "Cannot store composite IDs as properties, only individual part");
                        }
                        Header.Entry existingPropertyEntry = properties.put(propertyName, entry);
                        if (existingPropertyEntry == null) continue block5;
                        throw new DuplicateHeaderException(existingPropertyEntry, entry, dataSeeker.sourceDescription());
                    }
                    case START_ID: 
                    case END_ID: {
                        multiEntries.add(entry.type());
                        continue block5;
                    }
                    case TYPE: {
                        Header.Entry existingSingletonEntry = (Header.Entry)singletonEntries.get((Object)entry.type());
                        if (existingSingletonEntry != null) {
                            throw new DuplicateHeaderException(existingSingletonEntry, entry, dataSeeker.sourceDescription());
                        }
                        singletonEntries.put(entry.type(), entry);
                        continue block5;
                    }
                }
            }
            for (Type type : this.mandatoryTypes) {
                if (singletonEntries.containsKey((Object)type) || multiEntries.contains((Object)type)) continue;
                throw new HeaderException(String.format("Missing header of type %s, among entries %s", new Object[]{type, Arrays.toString(entries)}));
            }
        }

        static boolean isRecognizedType(String typeSpec) {
            for (Type type : Type.values()) {
                if (!type.matches(typeSpec)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isDefined() {
            return false;
        }

        Extractor<?> propertyExtractor(String sourceDescription, String name, String typeSpec, CSVHeaderInformation optionalParameter, Extractors extractors, Header.Monitor monitor) {
            Extractor<?> extractor = DataFactories.parsePropertyType(typeSpec, optionalParameter, extractors);
            if (this.normalizeTypes) {
                String fromType = extractor.name();
                Extractor normalized = extractor.normalize();
                if (!normalized.equals(extractor)) {
                    String toType = normalized.name();
                    monitor.typeNormalized(sourceDescription, name, fromType, toType);
                    return normalized;
                }
            }
            return extractor;
        }
    }
}

