/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.stats;

import java.util.ArrayList;
import java.util.Collection;
import org.neo4j.internal.batchimport.stats.Key;
import org.neo4j.internal.batchimport.stats.Stat;
import org.neo4j.internal.batchimport.stats.StatsProvider;

public class GenericStatsProvider
implements StatsProvider {
    private final Collection<KeyStatistics> stats = new ArrayList<KeyStatistics>();

    public void add(Key key, Stat stat) {
        this.stats.add(new KeyStatistics(key, stat));
    }

    @Override
    public Stat stat(Key key) {
        for (KeyStatistics stat1 : this.stats) {
            if (!stat1.key().name().equals(key.name())) continue;
            return stat1.stat();
        }
        return null;
    }

    @Override
    public Key[] keys() {
        Key[] keys = new Key[this.stats.size()];
        int i = 0;
        for (KeyStatistics stat : this.stats) {
            keys[i++] = stat.key();
        }
        return keys;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (KeyStatistics stat : this.stats) {
            builder.append(builder.isEmpty() ? "" : ", ").append(String.format("%s: %s", stat.key().shortName(), stat.stat()));
        }
        return builder.toString();
    }

    private record KeyStatistics(Key key, Stat stat) {
    }
}

