/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.cache;

import org.neo4j.internal.batchimport.cache.DynamicNumberArray;
import org.neo4j.internal.batchimport.cache.IntArray;
import org.neo4j.internal.batchimport.cache.NumberArray;
import org.neo4j.internal.batchimport.cache.NumberArrayFactory;
import org.neo4j.memory.MemoryTracker;

public class DynamicIntArray
extends DynamicNumberArray<IntArray>
implements IntArray {
    private final int defaultValue;
    private final MemoryTracker memoryTracker;

    public DynamicIntArray(NumberArrayFactory factory, long chunkSize, int defaultValue, MemoryTracker memoryTracker) {
        super(factory, chunkSize, (NumberArray[])new IntArray[0]);
        this.defaultValue = defaultValue;
        this.memoryTracker = memoryTracker;
    }

    @Override
    public int get(long index) {
        IntArray chunk = (IntArray)this.chunkOrNullAt(index);
        return chunk != null ? chunk.get(index) : this.defaultValue;
    }

    @Override
    public void set(long index, int value) {
        ((IntArray)this.at(index)).set(index, value);
    }

    @Override
    protected IntArray addChunk(long chunkSize, long base) {
        return this.factory.newIntArray(chunkSize, this.defaultValue, base, this.memoryTracker);
    }
}

