/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.cache;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.neo4j.internal.batchimport.cache.MemoryStatsVisitor;
import org.neo4j.internal.batchimport.cache.NumberArray;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;

public abstract class PageCacheNumberArray<N extends NumberArray<N>>
implements NumberArray<N> {
    private static final String PAGE_CACHE_WORKER_TAG = "pageCacheNumberArrayWorker";
    protected final PagedFile pagedFile;
    protected final int entriesPerPage;
    protected final int entrySize;
    protected final CursorContextFactory contextFactory;
    private final long length;
    private final long defaultValue;
    private final long base;
    private boolean closed;

    PageCacheNumberArray(PagedFile pagedFile, CursorContextFactory contextFactory, int entrySize, long length, long base) throws IOException {
        this(pagedFile, contextFactory, entrySize, length, 0L, base);
    }

    PageCacheNumberArray(PagedFile pagedFile, CursorContextFactory contextFactory, int entrySize, long length, long defaultValue, long base) throws IOException {
        this.pagedFile = pagedFile;
        this.contextFactory = contextFactory;
        this.entrySize = entrySize;
        this.entriesPerPage = pagedFile.payloadSize() / entrySize;
        this.length = length;
        this.defaultValue = defaultValue;
        this.base = base;
        try (CursorContext cursorContext = contextFactory.create(PAGE_CACHE_WORKER_TAG);
             PageCursor cursorToSetLength = pagedFile.io(0L, 2, cursorContext);){
            this.setLength(cursorToSetLength, length);
        }
        if (defaultValue != 0L) {
            this.setDefaultValue(defaultValue);
        }
    }

    private void setLength(PageCursor cursor, long length) throws IOException {
        if (!cursor.next((length - 1L) / (long)this.entriesPerPage)) {
            throw new IllegalStateException(String.format("Unable to extend the backing file %s to desired size %d.", this.pagedFile, length));
        }
    }

    protected long pageId(long index) {
        return this.rebase(index) / (long)this.entriesPerPage;
    }

    protected int offset(long index) {
        return Math.toIntExact(this.rebase(index) % (long)this.entriesPerPage * (long)this.entrySize);
    }

    private long rebase(long index) {
        return index - this.base;
    }

    protected void setDefaultValue(long defaultValue) throws IOException {
        block19: {
            try (CursorContext cursorContext = this.contextFactory.create(PAGE_CACHE_WORKER_TAG);
                 PageCursor writeCursor = this.pagedFile.io(0L, 6, cursorContext);){
                writeCursor.next();
                int payloadSize = this.pagedFile.payloadSize();
                this.fillPageWithDefaultValue(writeCursor, defaultValue, payloadSize);
                if (this.pageId(this.length - 1L) <= 0L) break block19;
                try (PageCursor cursor = this.pagedFile.io(1L, 6, cursorContext);){
                    while (cursor.next()) {
                        writeCursor.copyTo(0, cursor, 0, payloadSize);
                        PageCacheNumberArray.checkBounds(writeCursor);
                    }
                }
            }
        }
    }

    protected void fillPageWithDefaultValue(PageCursor writeCursor, long defaultValue, int payloadSize) {
        int longsInPage = payloadSize / 8;
        for (int i = 0; i < longsInPage; ++i) {
            writeCursor.putLong(defaultValue);
        }
        PageCacheNumberArray.checkBounds(writeCursor);
    }

    @Override
    public long length() {
        return this.length;
    }

    @Override
    public void clear() {
        try {
            this.setDefaultValue(this.defaultValue);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.pagedFile.close();
        this.closed = true;
    }

    @Override
    public N at(long index) {
        return (N)this;
    }

    @Override
    public void acceptMemoryStatsVisitor(MemoryStatsVisitor visitor) {
        visitor.offHeapUsage(this.length() * (long)this.entrySize);
    }

    protected static void checkBounds(PageCursor cursor) {
        if (cursor.checkAndClearBoundsFlag()) {
            throw new IllegalStateException(String.format("Cursor %s access out of bounds, page id %d, offset %d", cursor, cursor.getCurrentPageId(), cursor.getOffset()));
        }
    }
}

